/*
 * Decompiled with CFR 0.152.
 */
package com.topjohnwu.superuser.io;

import android.os.Build;
import androidx.annotation.NonNull;
import com.topjohnwu.superuser.Shell;
import com.topjohnwu.superuser.internal.IOFactory;
import com.topjohnwu.superuser.io.SuFile;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.InputStream;

public class SuFileInputStream
extends FilterInputStream {
    @NonNull
    public static InputStream open(@NonNull String path) throws FileNotFoundException {
        return SuFileInputStream.open(new File(path));
    }

    @NonNull
    public static InputStream open(@NonNull File file) throws FileNotFoundException {
        if (file instanceof SuFile) {
            return SuFileInputStream.root((SuFile)file);
        }
        try {
            return new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            if (!Shell.rootAccess()) {
                throw e;
            }
            return SuFileInputStream.root(new SuFile(file));
        }
    }

    private static InputStream root(SuFile file) throws FileNotFoundException {
        if (Build.VERSION.SDK_INT >= 21) {
            return IOFactory.fifoIn(file);
        }
        return IOFactory.shellIn(file);
    }

    @Deprecated
    public SuFileInputStream(String path) throws FileNotFoundException {
        this(new File(path));
    }

    @Deprecated
    public SuFileInputStream(File file) throws FileNotFoundException {
        super(null);
        if (file instanceof SuFile) {
            this.in = SuFileInputStream.compat((SuFile)file);
        } else {
            try {
                this.in = new BufferedInputStream(new FileInputStream(file));
            }
            catch (FileNotFoundException e) {
                if (!Shell.rootAccess()) {
                    throw e;
                }
                this.in = SuFileInputStream.compat(new SuFile(file));
            }
        }
    }

    private static InputStream compat(SuFile file) throws FileNotFoundException {
        if (Build.VERSION.SDK_INT >= 21) {
            return new BufferedInputStream(IOFactory.fifoIn(file));
        }
        return IOFactory.shellIn(file);
    }
}

