/*
 * Decompiled with CFR 0.152.
 */
package com.topjohnwu.superuser.internal;

import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import com.topjohnwu.superuser.internal.CopyOutputStream;
import com.topjohnwu.superuser.internal.FifoInputStream;
import com.topjohnwu.superuser.internal.FifoOutputStream;
import com.topjohnwu.superuser.internal.RAFWrapper;
import com.topjohnwu.superuser.internal.ShellIO;
import com.topjohnwu.superuser.internal.ShellInputStream;
import com.topjohnwu.superuser.internal.ShellOutputStream;
import com.topjohnwu.superuser.io.SuFile;
import java.io.File;
import java.io.FileNotFoundException;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class IOFactory {
    static final byte[] JUNK = new byte[1];

    private IOFactory() {
    }

    public static ShellIO shellIO(SuFile file, String mode) throws FileNotFoundException {
        switch (mode) {
            case "r": {
                break;
            }
            case "rw": 
            case "rws": 
            case "rwd": {
                mode = "rw";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown mode: " + mode);
            }
        }
        return ShellIO.get(file, mode);
    }

    public static RAFWrapper raf(File file, String mode) throws FileNotFoundException {
        return new RAFWrapper(file, mode);
    }

    public static ShellInputStream shellIn(SuFile file) throws FileNotFoundException {
        return new ShellInputStream(file);
    }

    @RequiresApi(value=21)
    public static FifoInputStream fifoIn(SuFile file) throws FileNotFoundException {
        return new FifoInputStream(file);
    }

    public static ShellOutputStream shellOut(SuFile file, boolean append) throws FileNotFoundException {
        return new ShellOutputStream(file, append);
    }

    @RequiresApi(value=21)
    public static FifoOutputStream fifoOut(SuFile file, boolean append) throws FileNotFoundException {
        return new FifoOutputStream(file, append);
    }

    public static CopyOutputStream copyOut(SuFile file, boolean append) throws FileNotFoundException {
        return new CopyOutputStream(file, append);
    }
}

