/*
 * Decompiled with CFR 0.152.
 */
package com.topjohnwu.superuser.internal;

import androidx.annotation.NonNull;
import com.topjohnwu.superuser.internal.ByteOutputStream;
import com.topjohnwu.superuser.internal.Utils;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;

interface DataInputImpl
extends DataInput {
    public int read(byte[] var1, int var2, int var3) throws IOException;

    default public int read() throws IOException {
        byte[] b = new byte[1];
        if (this.read(b) != 1) {
            return -1;
        }
        return b[0] & 0xFF;
    }

    default public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    default public void readFully(@NonNull byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    @Override
    default public void readFully(byte[] b, int off, int len) throws IOException {
        if (this.read(b, off, len) != len) {
            throw new EOFException();
        }
    }

    @Override
    default public boolean readBoolean() throws IOException {
        return this.readByte() != 0;
    }

    @Override
    default public byte readByte() throws IOException {
        byte[] b = new byte[1];
        this.readFully(b);
        return b[0];
    }

    @Override
    default public int readUnsignedByte() throws IOException {
        return this.readByte() & 0xFF;
    }

    @Override
    default public short readShort() throws IOException {
        byte[] b = new byte[2];
        this.readFully(b);
        return (short)((b[0] << 8) + (b[1] << 0));
    }

    @Override
    default public int readUnsignedShort() throws IOException {
        byte[] b = new byte[2];
        this.readFully(b);
        return (b[0] << 8) + (b[1] << 0);
    }

    @Override
    default public char readChar() throws IOException {
        return (char)this.readUnsignedShort();
    }

    @Override
    default public int readInt() throws IOException {
        byte[] b = new byte[4];
        this.readFully(b);
        return (b[0] << 24) + (b[1] << 16) + (b[2] << 8) + (b[3] << 0);
    }

    @Override
    default public long readLong() throws IOException {
        byte[] b = new byte[8];
        this.readFully(b);
        return ((long)b[0] << 56) + ((long)(b[1] & 0xFF) << 48) + ((long)(b[2] & 0xFF) << 40) + ((long)(b[3] & 0xFF) << 32) + ((long)(b[4] & 0xFF) << 24) + (long)((b[5] & 0xFF) << 16) + (long)((b[6] & 0xFF) << 8) + (long)((b[7] & 0xFF) << 0);
    }

    @Override
    default public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    default public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    default public String readLine() throws IOException {
        ByteOutputStream buf = new ByteOutputStream();
        try {
            int b;
            do {
                b = this.readUnsignedByte();
                buf.write(b);
            } while (b != 10);
        }
        catch (EOFException b) {
            // empty catch block
        }
        int size = buf.size();
        if (size == 0) {
            return null;
        }
        byte[] bytes = buf.getBuf();
        if (bytes[size - 1] == 10 && --size > 0 && bytes[size - 1] == 13) {
            --size;
        }
        return new String(bytes, 0, size, Utils.UTF_8);
    }

    @Override
    @NonNull
    default public String readUTF() throws IOException {
        int len = this.readUnsignedShort();
        byte[] b = new byte[len + 2];
        b[0] = (byte)(len >>> 8);
        b[1] = (byte)(len >>> 0);
        this.readFully(b, 2, len);
        return new DataInputStream(new ByteArrayInputStream(b)).readUTF();
    }
}

