/*
 * Decompiled with CFR 0.152.
 */
package com.topjohnwu.superuser.internal;

import androidx.annotation.NonNull;
import com.topjohnwu.superuser.ShellUtils;
import com.topjohnwu.superuser.internal.Env;
import com.topjohnwu.superuser.internal.ShellIO;
import com.topjohnwu.superuser.io.SuFile;
import java.io.FileNotFoundException;
import java.io.IOException;

class ShellBlockIO
extends ShellIO {
    private long blockSize;

    ShellBlockIO(SuFile file, String mode) throws FileNotFoundException {
        super(file, mode);
        if (Env.blockdev()) {
            try {
                this.blockSize = Long.parseLong(ShellUtils.fastCmd((String[])new String[]{"blockdev --getsize64 '" + file.getAbsolutePath() + "'"}));
            }
            catch (NumberFormatException e) {
                this.blockSize = Long.MAX_VALUE;
            }
        } else {
            this.blockSize = Long.MAX_VALUE;
        }
        this.WRITE_CONV = "";
    }

    @Override
    int read(byte[] b, int off, int len, long fileOff, long bs) throws IOException {
        if (fileOff >= this.blockSize) {
            this.eof = true;
            return -1;
        }
        return super.read(b, off, len, fileOff, bs);
    }

    @Override
    public void write(@NonNull byte[] b, int off, int len) throws IOException {
        if (this.fileOff + (long)len > this.blockSize) {
            throw new IOException("Cannot write pass block size");
        }
        super.write(b, off, len);
    }

    @Override
    void streamWrite(byte[] b, int off, int len) throws IOException {
        this.write(b, off, len);
    }

    @Override
    public long length() {
        return this.blockSize;
    }

    @Override
    public void setLength(long newLength) {
        throw new UnsupportedOperationException("Block devices have fixed sizes");
    }

    @Override
    public void seek(long pos) throws IOException {
        if (pos > this.blockSize) {
            throw new IOException("Cannot seek pass block size");
        }
        this.fileOff = pos;
    }
}

