/*
 * Decompiled with CFR 0.152.
 */
package com.topjohnwu.superuser.io;

import androidx.annotation.NonNull;
import com.topjohnwu.superuser.Shell;
import com.topjohnwu.superuser.ShellUtils;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;

public class SuFile
extends File {
    private static int shellHash = -1;
    private static boolean stat;
    private static boolean blockdev;
    private static boolean wc;

    public static File open(String pathname) {
        return Shell.rootAccess() ? new SuFile(pathname) : new File(pathname);
    }

    public static File open(String parent, String child) {
        return Shell.rootAccess() ? new SuFile(parent, child) : new File(parent, child);
    }

    public static File open(File parent, String child) {
        return Shell.rootAccess() ? new SuFile(parent, child) : new File(parent, child);
    }

    public static File open(URI uri) {
        return Shell.rootAccess() ? new SuFile(uri) : new File(uri);
    }

    SuFile(@NonNull File file) {
        super(file.getAbsolutePath());
        Shell shell = Shell.getShell();
        if (shell.hashCode() != shellHash) {
            shellHash = shell.hashCode();
            stat = ShellUtils.fastCmdResult((Shell)shell, (String[])new String[]{"command -v stat"});
            blockdev = ShellUtils.fastCmdResult((Shell)shell, (String[])new String[]{"command -v blockdev"});
            wc = ShellUtils.fastCmdResult((Shell)shell, (String[])new String[]{"command -v wc"});
        }
    }

    public SuFile(String pathname) {
        this(new File(pathname));
    }

    public SuFile(String parent, String child) {
        this(new File(parent, child));
    }

    public SuFile(File parent, String child) {
        this(parent.getAbsolutePath(), child);
    }

    public SuFile(URI uri) {
        this(new File(uri));
    }

    private String[] genCmd(String ... cmds) {
        boolean needCfile = false;
        for (String cmd : cmds) {
            if (!cmd.contains("$CFILE")) continue;
            needCfile = true;
            break;
        }
        String[] newCmd = new String[cmds.length + 1];
        newCmd[0] = needCfile ? String.format("FILE='%s';CFILE=\"`readlink -f \"$FILE\"`\"", this.getAbsolutePath()) : String.format("FILE='%s'", this.getAbsolutePath());
        System.arraycopy(cmds, 0, newCmd, 1, cmds.length);
        return newCmd;
    }

    private String cmd(String ... cmds) {
        return ShellUtils.fastCmd((String[])this.genCmd(cmds));
    }

    private boolean cmdBoolean(String c) {
        return ShellUtils.fastCmdResult((String[])this.genCmd(c));
    }

    @Override
    public boolean canExecute() {
        return this.cmdBoolean("[ -x \"$FILE\" ]");
    }

    @Override
    public boolean canRead() {
        return this.cmdBoolean("[ -r \"$FILE\" ]");
    }

    @Override
    public boolean canWrite() {
        return this.cmdBoolean("[ -w \"$FILE\" ]");
    }

    @Override
    public boolean createNewFile() {
        boolean origImpl = false;
        try {
            origImpl = super.createNewFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return origImpl || this.cmdBoolean("[ ! -e \"$FILE\" ] && touch \"$FILE\"");
    }

    @Override
    public boolean delete() {
        return this.cmdBoolean("rm -f \"$FILE\" || rmdir -f \"$FILE\"");
    }

    public boolean clear() {
        return this.cmdBoolean("echo -n > \"$FILE\"");
    }

    public boolean deleteRecursive() {
        return this.cmdBoolean("rm -rf \"$FILE\"");
    }

    @Override
    public void deleteOnExit() {
    }

    @Override
    public boolean exists() {
        return this.cmdBoolean("[ -e \"$FILE\" ]");
    }

    @Override
    @NonNull
    public SuFile getAbsoluteFile() {
        return this;
    }

    @Override
    @NonNull
    public String getCanonicalPath() {
        String path = this.cmd("echo \"$CFILE\"");
        return path.isEmpty() ? this.getAbsolutePath() : path;
    }

    @Override
    @NonNull
    public SuFile getCanonicalFile() {
        return new SuFile(this.getCanonicalPath());
    }

    @Override
    public SuFile getParentFile() {
        return new SuFile(this.getParent());
    }

    private long statFS(String fmt) {
        if (!stat) {
            return Long.MAX_VALUE;
        }
        String[] res = this.cmd("stat -fc '%S " + fmt + "' \"$FILE\"").split(" ");
        if (res.length != 2) {
            return Long.MAX_VALUE;
        }
        return Long.parseLong(res[0]) * Long.parseLong(res[1]);
    }

    @Override
    public long getFreeSpace() {
        return this.statFS("%f");
    }

    @Override
    public long getTotalSpace() {
        return this.statFS("%b");
    }

    @Override
    public long getUsableSpace() {
        return this.statFS("%a");
    }

    @Override
    public boolean isDirectory() {
        return this.cmdBoolean("[ -d \"$FILE\" ]");
    }

    @Override
    public boolean isFile() {
        return this.cmdBoolean("[ -f \"$FILE\" ]");
    }

    public boolean isBlock() {
        return this.cmdBoolean("[ -b \"$FILE\" ]");
    }

    public boolean isCharacter() {
        return this.cmdBoolean("[ -c \"$FILE\" ]");
    }

    @Override
    public long lastModified() {
        try {
            if (!stat) {
                return 0L;
            }
            return Long.parseLong(this.cmd("stat -Lc '%Y' \"$FILE\"")) * 1000L;
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    @Override
    public long length() {
        try {
            if (stat) {
                if (blockdev) {
                    return Long.parseLong(this.cmd("[ -b \"$FILE\" ] && blockdev --getsize64 \"$FILE\" || stat -Lc '%s' \"$FILE\""));
                }
                return Long.parseLong(this.cmd("stat -Lc '%s' \"$FILE\""));
            }
            if (wc) {
                return Long.parseLong(this.cmd("[ -f \"$FILE\" ] && wc -c < \"$FILE\" || echo 0"));
            }
            return 0L;
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    @Override
    public boolean mkdir() {
        return this.cmdBoolean("mkdir \"$FILE\"");
    }

    @Override
    public boolean mkdirs() {
        return this.cmdBoolean("mkdir -p \"$FILE\"");
    }

    @Override
    public boolean renameTo(File dest) {
        return this.cmdBoolean("mv -f \"$FILE\" '" + dest.getAbsolutePath() + "'");
    }

    private boolean setPerms(boolean set, boolean ownerOnly, int b) {
        if (!stat) {
            return false;
        }
        char[] perms = this.cmd("stat -Lc '%a' \"$FILE\"").toCharArray();
        for (int i = 0; i < perms.length; ++i) {
            int perm = perms[i] - 48;
            perm = set && (!ownerOnly || i == 0) ? (perm |= b) : (perm &= ~b);
            perms[i] = (char)(perm + 48);
        }
        return this.cmdBoolean("chmod " + new String(perms) + " \"$CFILE\"");
    }

    @Override
    public boolean setExecutable(boolean executable, boolean ownerOnly) {
        return this.setPerms(executable, ownerOnly, 1);
    }

    @Override
    public boolean setReadable(boolean readable, boolean ownerOnly) {
        return this.setPerms(readable, ownerOnly, 4);
    }

    @Override
    public boolean setWritable(boolean writable, boolean ownerOnly) {
        return this.setPerms(writable, ownerOnly, 2);
    }

    @Override
    public boolean setReadOnly() {
        return this.setWritable(false, false) && this.setExecutable(false, false);
    }

    @Override
    public boolean setLastModified(long time) {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmm", Locale.US);
        String date = df.format(new Date(time));
        return this.cmdBoolean("[ -e \"$FILE\" ] && touch -t " + date + " \"$CFILE\"");
    }

    @Override
    public String[] list() {
        return this.list(null);
    }

    @Override
    public String[] list(FilenameFilter filter) {
        if (!this.isDirectory()) {
            return null;
        }
        FilenameFilter defFilter = (file, name) -> name.equals(".") || name.equals("..");
        List out = Shell.su((String[])this.genCmd("ls -a \"$FILE\"")).to(new LinkedList(), null).exec().getOut();
        ListIterator it = out.listIterator();
        while (it.hasNext()) {
            String name2 = (String)it.next();
            if (filter != null && !filter.accept(this, name2)) {
                it.remove();
                continue;
            }
            if (!defFilter.accept(this, name2)) continue;
            it.remove();
        }
        return out.toArray(new String[0]);
    }

    public SuFile[] listFiles() {
        if (!this.isDirectory()) {
            return null;
        }
        String[] ss = this.list();
        if (ss == null) {
            return null;
        }
        int n = ss.length;
        SuFile[] fs = new SuFile[n];
        for (int i = 0; i < n; ++i) {
            fs[i] = new SuFile(this, ss[i]);
        }
        return fs;
    }

    public SuFile[] listFiles(FilenameFilter filter) {
        if (!this.isDirectory()) {
            return null;
        }
        String[] ss = this.list(filter);
        if (ss == null) {
            return null;
        }
        int n = ss.length;
        SuFile[] fs = new SuFile[n];
        for (int i = 0; i < n; ++i) {
            fs[i] = new SuFile(this, ss[i]);
        }
        return fs;
    }

    public SuFile[] listFiles(FileFilter filter) {
        String[] ss = this.list();
        if (ss == null) {
            return null;
        }
        ArrayList<SuFile> files = new ArrayList<SuFile>();
        for (String s : ss) {
            SuFile f = new SuFile(this, s);
            if (filter != null && !filter.accept(f)) continue;
            files.add(f);
        }
        return files.toArray(new SuFile[0]);
    }
}

