/*
 * Decompiled with CFR 0.152.
 */
package com.topjohnwu.superuser.io;

import com.topjohnwu.superuser.Shell;
import com.topjohnwu.superuser.internal.IOFactory;
import com.topjohnwu.superuser.io.SuFile;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;

public class SuFileInputStream
extends FilterInputStream {
    public SuFileInputStream(String path) throws FileNotFoundException {
        this(new File(path));
    }

    public SuFileInputStream(File file) throws FileNotFoundException {
        super(null);
        if (file instanceof SuFile && ((SuFile)file).isSU()) {
            this.in = IOFactory.createShellInputStream(((SuFile)file).getShellFile());
        } else {
            try {
                this.in = new BufferedInputStream(new FileInputStream(file));
            }
            catch (FileNotFoundException e) {
                if (!Shell.rootAccess()) {
                    throw e;
                }
                this.in = IOFactory.createShellInputStream(IOFactory.createShellFile(file));
            }
        }
    }
}

