/*
 * Decompiled with CFR 0.152.
 */
package com.topjohnwu.superuser.io;

import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import com.topjohnwu.superuser.Shell;
import com.topjohnwu.superuser.internal.IOFactory;
import com.topjohnwu.superuser.internal.ShellFile;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;

public class SuFile
extends File {
    private File f;

    public SuFile(@NonNull File file) {
        super("");
        this.f = file instanceof SuFile ? ((SuFile)file).f : (file instanceof ShellFile || !Shell.rootAccess() ? file : IOFactory.createShellFile(file));
    }

    public SuFile(@NonNull String pathname) {
        this(new File(pathname));
    }

    public SuFile(String parent, @NonNull String child) {
        this(new File(parent, child));
    }

    public SuFile(File parent, @NonNull String child) {
        this(parent.getAbsolutePath(), child);
    }

    public SuFile(@NonNull URI uri) {
        this(new File(uri));
    }

    boolean isSU() {
        return this.f instanceof ShellFile;
    }

    ShellFile getShellFile() {
        return (ShellFile)this.f;
    }

    @Override
    @NonNull
    public String getName() {
        return this.f.getName();
    }

    @Override
    public String getParent() {
        return this.f.getParent();
    }

    @Override
    public SuFile getParentFile() {
        return new SuFile(this.f.getParentFile());
    }

    @Override
    @NonNull
    public String getPath() {
        return this.f.getPath();
    }

    @Override
    public boolean isAbsolute() {
        return this.f.isAbsolute();
    }

    @Override
    @NonNull
    public String getAbsolutePath() {
        return this.f.getAbsolutePath();
    }

    @Override
    @NonNull
    public SuFile getAbsoluteFile() {
        return new SuFile(this.f.getAbsoluteFile());
    }

    @Override
    @NonNull
    public String getCanonicalPath() throws IOException {
        return this.f.getCanonicalPath();
    }

    @Override
    @NonNull
    public SuFile getCanonicalFile() throws IOException {
        return new SuFile(this.f.getCanonicalFile());
    }

    @Override
    @Deprecated
    public URL toURL() throws MalformedURLException {
        return this.f.toURL();
    }

    @Override
    @NonNull
    public URI toURI() {
        return this.f.toURI();
    }

    @Override
    public boolean canRead() {
        return this.f.canRead();
    }

    @Override
    public boolean canWrite() {
        return this.f.canWrite();
    }

    @Override
    public boolean exists() {
        return this.f.exists();
    }

    @Override
    public boolean isDirectory() {
        return this.f.isDirectory();
    }

    @Override
    public boolean isFile() {
        return this.f.isFile();
    }

    @Override
    public boolean isHidden() {
        return this.f.isHidden();
    }

    @Override
    public long lastModified() {
        return this.f.lastModified();
    }

    @Override
    public long length() {
        return this.f.length();
    }

    @Override
    public boolean createNewFile() {
        try {
            return this.f.createNewFile();
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public boolean delete() {
        return this.f.delete();
    }

    @Override
    public void deleteOnExit() {
        this.f.deleteOnExit();
    }

    @Override
    public String[] list() {
        return this.f.list();
    }

    @Override
    public String[] list(FilenameFilter filter) {
        return this.f.list(filter);
    }

    private SuFile[] trans(File[] list) {
        if (list == null) {
            return null;
        }
        SuFile[] ret = new SuFile[list.length];
        for (int i = 0; i < list.length; ++i) {
            ret[i] = new SuFile(list[i]);
        }
        return ret;
    }

    public SuFile[] listFiles() {
        return this.trans(this.f.listFiles());
    }

    public SuFile[] listFiles(FilenameFilter filter) {
        return this.trans(this.f.listFiles(filter));
    }

    public SuFile[] listFiles(FileFilter filter) {
        return this.trans(this.f.listFiles(filter));
    }

    @Override
    public boolean mkdir() {
        return this.f.mkdir();
    }

    @Override
    public boolean mkdirs() {
        return this.f.mkdirs();
    }

    @Override
    public boolean renameTo(File dest) {
        return this.f.renameTo(dest);
    }

    @Override
    public boolean setLastModified(long time) {
        return this.f.setLastModified(time);
    }

    @Override
    public boolean setReadOnly() {
        return this.f.setReadOnly();
    }

    @Override
    public boolean setWritable(boolean writable, boolean ownerOnly) {
        return this.f.setWritable(writable, ownerOnly);
    }

    @Override
    public boolean setWritable(boolean writable) {
        return this.f.setWritable(writable);
    }

    @Override
    public boolean setReadable(boolean readable, boolean ownerOnly) {
        return this.f.setReadable(readable, ownerOnly);
    }

    @Override
    public boolean setReadable(boolean readable) {
        return this.f.setReadable(readable);
    }

    @Override
    public boolean setExecutable(boolean executable, boolean ownerOnly) {
        return this.f.setExecutable(executable, ownerOnly);
    }

    @Override
    public boolean setExecutable(boolean executable) {
        return this.f.setExecutable(executable);
    }

    @Override
    public boolean canExecute() {
        return this.f.canExecute();
    }

    @Override
    public long getTotalSpace() {
        return this.f.getTotalSpace();
    }

    @Override
    public long getFreeSpace() {
        return this.f.getFreeSpace();
    }

    @Override
    public long getUsableSpace() {
        return this.f.getUsableSpace();
    }

    @Override
    public int compareTo(File pathname) {
        return this.f.compareTo(pathname);
    }

    @Override
    public boolean equals(Object obj) {
        return this.f.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.f.hashCode();
    }

    @Override
    public String toString() {
        return this.f.toString();
    }

    @Override
    @NonNull
    @RequiresApi(value=26)
    public Path toPath() {
        return this.f.toPath();
    }
}

