/*
 * Decompiled with CFR 0.152.
 */
package com.topjohnwu.superuser.io;

import androidx.annotation.NonNull;
import com.topjohnwu.superuser.Shell;
import com.topjohnwu.superuser.internal.IOFactory;
import com.topjohnwu.superuser.io.SuFile;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;

public class SuFileOutputStream
extends FilterOutputStream {
    public SuFileOutputStream(String path) throws FileNotFoundException {
        this(path, false);
    }

    public SuFileOutputStream(String path, boolean append) throws FileNotFoundException {
        this(new File(path), append);
    }

    public SuFileOutputStream(File file) throws FileNotFoundException {
        this(file, false);
    }

    public SuFileOutputStream(File file, boolean append) throws FileNotFoundException {
        super(null);
        if (file instanceof SuFile && ((SuFile)file).isSU()) {
            this.out = new BufferedOutputStream(IOFactory.createShellOutputStream(((SuFile)file).getShellFile(), append), 0x400000);
        } else {
            try {
                this.out = new BufferedOutputStream(new FileOutputStream(file, append));
            }
            catch (FileNotFoundException e) {
                if (!Shell.rootAccess()) {
                    throw e;
                }
                this.out = new BufferedOutputStream(IOFactory.createShellOutputStream(IOFactory.createShellFile(file), append), 0x400000);
            }
        }
    }

    @Override
    public void write(@NonNull byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
    }
}

