/*
 * Decompiled with CFR 0.152.
 */
package com.tonyodev.fetch2.downloader;

import android.content.Context;
import android.content.Intent;
import com.tonyodev.fetch2.Download;
import com.tonyodev.fetch2.downloader.DownloadManager;
import com.tonyodev.fetch2.downloader.DownloadManagerCoordinator;
import com.tonyodev.fetch2.downloader.FileDownloader;
import com.tonyodev.fetch2.downloader.ParallelFileDownloaderImpl;
import com.tonyodev.fetch2.downloader.SequentialFileDownloaderImpl;
import com.tonyodev.fetch2.exception.FetchException;
import com.tonyodev.fetch2.fetch.ListenerCoordinator;
import com.tonyodev.fetch2.helper.DownloadInfoUpdater;
import com.tonyodev.fetch2.helper.FileDownloaderDelegate;
import com.tonyodev.fetch2.provider.GroupInfoProvider;
import com.tonyodev.fetch2.provider.NetworkInfoProvider;
import com.tonyodev.fetch2.util.FetchUtils;
import com.tonyodev.fetch2core.Downloader;
import com.tonyodev.fetch2core.FetchCoreUtils;
import com.tonyodev.fetch2core.FileServerDownloader;
import com.tonyodev.fetch2core.Logger;
import com.tonyodev.fetch2core.StorageResolver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0095\u0001\u0012\u000e\u0010\u0002\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\r\u0012\u0006\u0010\u0017\u001a\u00020\u0018\u0012\u0006\u0010\u0019\u001a\u00020\u001a\u0012\u0006\u0010\u001b\u001a\u00020\u001c\u0012\u0006\u0010\u001d\u001a\u00020\u001e\u0012\u0006\u0010\u001f\u001a\u00020\u0005\u0012\u0006\u0010 \u001a\u00020\r\u00a2\u0006\u0002\u0010!J\b\u00103\u001a\u00020\rH\u0016J\u0010\u00104\u001a\u00020\r2\u0006\u00105\u001a\u00020\u0005H\u0016J\b\u00106\u001a\u000207H\u0016J\b\u00108\u001a\u000207H\u0002J\u0010\u00109\u001a\u00020\r2\u0006\u00105\u001a\u00020\u0005H\u0002J\b\u0010:\u001a\u000207H\u0016J\u0010\u0010;\u001a\u00020\r2\u0006\u00105\u001a\u00020\u0005H\u0016J\b\u0010<\u001a\u00020\u0005H\u0016J\u000e\u0010=\u001a\b\u0012\u0004\u0012\u00020?0>H\u0016J\u000e\u0010@\u001a\b\u0012\u0004\u0012\u00020\u00050>H\u0016J\u0010\u0010A\u001a\u00020\u001c2\u0006\u0010B\u001a\u00020?H\u0016J \u0010C\u001a\u00020*2\u0006\u0010B\u001a\u00020?2\u000e\u0010D\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003H\u0002J\b\u0010E\u001a\u00020FH\u0016J\u0012\u0010G\u001a\u0004\u0018\u00010.2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0010\u0010H\u001a\u00020*2\u0006\u0010B\u001a\u00020?H\u0016J\u0010\u0010I\u001a\u0002072\u0006\u0010B\u001a\u00020?H\u0002J\u0010\u0010J\u001a\u00020\r2\u0006\u0010B\u001a\u00020?H\u0016J\b\u0010K\u001a\u000207H\u0002J\b\u0010L\u001a\u000207H\u0002R\u000e\u0010\"\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0004\u001a\u00020\u00052\u0006\u0010#\u001a\u00020\u0005@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R.\u0010(\u001a\"\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010*0)j\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010*`+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010-\u001a\u0004\u0018\u00010.X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0002\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010/\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u00100R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u000202X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006M"}, d2={"Lcom/tonyodev/fetch2/downloader/DownloadManagerImpl;", "Lcom/tonyodev/fetch2/downloader/DownloadManager;", "httpDownloader", "Lcom/tonyodev/fetch2core/Downloader;", "concurrentLimit", "", "progressReportingIntervalMillis", "", "logger", "Lcom/tonyodev/fetch2core/Logger;", "networkInfoProvider", "Lcom/tonyodev/fetch2/provider/NetworkInfoProvider;", "retryOnNetworkGain", "", "downloadInfoUpdater", "Lcom/tonyodev/fetch2/helper/DownloadInfoUpdater;", "downloadManagerCoordinator", "Lcom/tonyodev/fetch2/downloader/DownloadManagerCoordinator;", "listenerCoordinator", "Lcom/tonyodev/fetch2/fetch/ListenerCoordinator;", "fileServerDownloader", "Lcom/tonyodev/fetch2core/FileServerDownloader;", "hashCheckingEnabled", "storageResolver", "Lcom/tonyodev/fetch2core/StorageResolver;", "context", "Landroid/content/Context;", "namespace", "", "groupInfoProvider", "Lcom/tonyodev/fetch2/provider/GroupInfoProvider;", "globalAutoRetryMaxAttempts", "preAllocateFileOnCreation", "(Lcom/tonyodev/fetch2core/Downloader;IJLcom/tonyodev/fetch2core/Logger;Lcom/tonyodev/fetch2/provider/NetworkInfoProvider;ZLcom/tonyodev/fetch2/helper/DownloadInfoUpdater;Lcom/tonyodev/fetch2/downloader/DownloadManagerCoordinator;Lcom/tonyodev/fetch2/fetch/ListenerCoordinator;Lcom/tonyodev/fetch2core/FileServerDownloader;ZLcom/tonyodev/fetch2core/StorageResolver;Landroid/content/Context;Ljava/lang/String;Lcom/tonyodev/fetch2/provider/GroupInfoProvider;IZ)V", "closed", "value", "getConcurrentLimit", "()I", "setConcurrentLimit", "(I)V", "currentDownloadsMap", "Ljava/util/HashMap;", "Lcom/tonyodev/fetch2/downloader/FileDownloader;", "Lkotlin/collections/HashMap;", "downloadCounter", "executor", "Ljava/util/concurrent/ExecutorService;", "isClosed", "()Z", "lock", "", "canAccommodateNewDownload", "cancel", "downloadId", "cancelAll", "", "cancelAllDownloads", "cancelDownloadNoLock", "close", "contains", "getActiveDownloadCount", "getActiveDownloads", "", "Lcom/tonyodev/fetch2/Download;", "getActiveDownloadsIds", "getDownloadFileTempDir", "download", "getFileDownloader", "downloader", "getFileDownloaderDelegate", "Lcom/tonyodev/fetch2/downloader/FileDownloader$Delegate;", "getNewDownloadExecutorService", "getNewFileDownloaderForDownload", "removeDownloadMappings", "start", "terminateAllDownloads", "throwExceptionIfClosed", "fetch2_release"})
public final class DownloadManagerImpl
implements DownloadManager {
    private final Object lock;
    private ExecutorService executor;
    private volatile int concurrentLimit;
    private final HashMap<Integer, FileDownloader> currentDownloadsMap;
    private volatile int downloadCounter;
    private volatile boolean closed;
    private final Downloader<?, ?> httpDownloader;
    private final long progressReportingIntervalMillis;
    private final Logger logger;
    private final NetworkInfoProvider networkInfoProvider;
    private final boolean retryOnNetworkGain;
    private final DownloadInfoUpdater downloadInfoUpdater;
    private final DownloadManagerCoordinator downloadManagerCoordinator;
    private final ListenerCoordinator listenerCoordinator;
    private final FileServerDownloader fileServerDownloader;
    private final boolean hashCheckingEnabled;
    private final StorageResolver storageResolver;
    private final Context context;
    private final String namespace;
    private final GroupInfoProvider groupInfoProvider;
    private final int globalAutoRetryMaxAttempts;
    private final boolean preAllocateFileOnCreation;

    @Override
    public int getConcurrentLimit() {
        return this.concurrentLimit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setConcurrentLimit(int value) {
        Object object = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            try {
                Iterable $this$forEach$iv = this.getActiveDownloadsIds();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    int id = ((Number)element$iv).intValue();
                    boolean bl4 = false;
                    this.cancelDownloadNoLock(id);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                ExecutorService executorService = this.executor;
                if (executorService != null) {
                    executorService.shutdown();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.executor = this.getNewDownloadExecutorService(value);
            this.concurrentLimit = value;
            this.logger.d("DownloadManager concurrentLimit changed from " + this.concurrentLimit + " to " + value);
            Unit unit = Unit.INSTANCE;
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean start(@NotNull Download download) {
        Intrinsics.checkParameterIsNotNull((Object)download, (String)"download");
        Object object = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            block8: {
                block7: {
                    block6: {
                        boolean bl3 = false;
                        this.throwExceptionIfClosed();
                        if (!this.currentDownloadsMap.containsKey(download.getId())) break block6;
                        this.logger.d("DownloadManager already running download " + download);
                        boolean bl4 = false;
                        return bl4;
                    }
                    if (this.downloadCounter < this.getConcurrentLimit()) break block7;
                    this.logger.d("DownloadManager cannot init download " + download + " because " + "the download queue is full");
                    boolean bl5 = false;
                    return bl5;
                }
                ++this.downloadCounter;
                ((Map)this.currentDownloadsMap).put(download.getId(), null);
                this.downloadManagerCoordinator.addFileDownloader(download.getId(), null);
                ExecutorService downloadExecutor = this.executor;
                if (downloadExecutor == null || downloadExecutor.isShutdown()) break block8;
                downloadExecutor.execute(new Runnable(this, download){
                    final /* synthetic */ DownloadManagerImpl this$0;
                    final /* synthetic */ Download $download$inlined;
                    {
                        this.this$0 = downloadManagerImpl;
                        this.$download$inlined = download;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public final void run() {
                        try {
                            Thread thread = Thread.currentThread();
                            Intrinsics.checkExpressionValueIsNotNull((Object)thread, (String)"Thread.currentThread()");
                            thread.setName(this.$download$inlined.getNamespace() + '-' + this.$download$inlined.getId());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            FileDownloader fileDownloader = this.this$0.getNewFileDownloaderForDownload(this.$download$inlined);
                            Object object = DownloadManagerImpl.access$getLock$p(this.this$0);
                            boolean bl = false;
                            boolean bl2 = false;
                            synchronized (object) {
                                boolean bl3;
                                boolean bl4 = false;
                                if (DownloadManagerImpl.access$getCurrentDownloadsMap$p(this.this$0).containsKey(this.$download$inlined.getId())) {
                                    fileDownloader.setDelegate(this.this$0.getFileDownloaderDelegate());
                                    ((Map)DownloadManagerImpl.access$getCurrentDownloadsMap$p(this.this$0)).put(this.$download$inlined.getId(), fileDownloader);
                                    DownloadManagerImpl.access$getDownloadManagerCoordinator$p(this.this$0).addFileDownloader(this.$download$inlined.getId(), fileDownloader);
                                    DownloadManagerImpl.access$getLogger$p(this.this$0).d("DownloadManager starting download " + this.$download$inlined);
                                    bl3 = true;
                                } else {
                                    bl3 = false;
                                }
                                bl2 = bl3;
                            }
                            boolean runDownload = bl2;
                            if (runDownload) {
                                fileDownloader.run();
                            }
                            DownloadManagerImpl.access$removeDownloadMappings(this.this$0, this.$download$inlined);
                            DownloadManagerImpl.access$getGroupInfoProvider$p(this.this$0).clean();
                        }
                        catch (Exception e) {
                            DownloadManagerImpl.access$getLogger$p(this.this$0).e("DownloadManager failed to start download " + this.$download$inlined, (Throwable)e);
                        }
                        finally {
                            DownloadManagerImpl.access$removeDownloadMappings(this.this$0, this.$download$inlined);
                            Intent intent = new Intent("com.tonyodev.fetch2.action.QUEUE_BACKOFF_RESET");
                            intent.setPackage(DownloadManagerImpl.access$getContext$p(this.this$0).getPackageName());
                            intent.putExtra("com.tonyodev.fetch2.extra.NAMESPACE", DownloadManagerImpl.access$getNamespace$p(this.this$0));
                            DownloadManagerImpl.access$getContext$p(this.this$0).sendBroadcast(intent);
                        }
                    }
                });
                boolean bl6 = true;
                return bl6;
            }
            bl2 = false;
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void removeDownloadMappings(Download download) {
        Object object = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            if (this.currentDownloadsMap.containsKey(download.getId())) {
                this.currentDownloadsMap.remove(download.getId());
                --this.downloadCounter;
            }
            this.downloadManagerCoordinator.removeFileDownloader(download.getId());
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(int downloadId) {
        Object object = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            bl2 = this.cancelDownloadNoLock(downloadId);
        }
        return bl2;
    }

    private final boolean cancelDownloadNoLock(int downloadId) {
        boolean bl;
        this.throwExceptionIfClosed();
        FileDownloader fileDownloader = this.currentDownloadsMap.get(downloadId);
        if (fileDownloader != null) {
            fileDownloader.setInterrupted(true);
            this.currentDownloadsMap.remove(downloadId);
            --this.downloadCounter;
            this.downloadManagerCoordinator.removeFileDownloader(downloadId);
            this.logger.d("DownloadManager cancelled download " + fileDownloader.getDownload());
            bl = fileDownloader.getInterrupted();
        } else {
            this.downloadManagerCoordinator.interruptDownload(downloadId);
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelAll() {
        Object object = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            this.throwExceptionIfClosed();
            this.cancelAllDownloads();
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void cancelAllDownloads() {
        if (this.getConcurrentLimit() > 0) {
            Iterator<FileDownloader> $this$forEach$iv = this.downloadManagerCoordinator.getFileDownloaderList().iterator();
            boolean $i$f$forEach = false;
            Iterator<FileDownloader> iterator = $this$forEach$iv;
            boolean bl = false;
            Iterator<FileDownloader> iterator2 = iterator;
            while (iterator2.hasNext()) {
                FileDownloader element$iv;
                FileDownloader it = element$iv = iterator2.next();
                boolean bl2 = false;
                FileDownloader fileDownloader = it;
                if (fileDownloader == null) continue;
                fileDownloader.setInterrupted(true);
                this.downloadManagerCoordinator.removeFileDownloader(fileDownloader.getDownload().getId());
                this.logger.d("DownloadManager cancelled download " + fileDownloader.getDownload());
            }
        }
        this.currentDownloadsMap.clear();
        this.downloadCounter = 0;
    }

    private final void terminateAllDownloads() {
        Map map = this.currentDownloadsMap;
        boolean bl = false;
        Iterator $this$forEach$iv = map.entrySet().iterator();
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv;
        boolean bl2 = false;
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it = element$iv = iterator2.next();
            boolean bl3 = false;
            FileDownloader fileDownloader = (FileDownloader)it.getValue();
            if (fileDownloader == null) continue;
            fileDownloader.setTerminated(true);
            this.logger.d("DownloadManager terminated download " + fileDownloader.getDownload());
            this.downloadManagerCoordinator.removeFileDownloader(((Number)it.getKey()).intValue());
        }
        this.currentDownloadsMap.clear();
        this.downloadCounter = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            Unit unit;
            boolean bl3 = false;
            if (this.closed) {
                return;
            }
            this.closed = true;
            if (this.getConcurrentLimit() > 0) {
                this.terminateAllDownloads();
            }
            this.logger.d("DownloadManager closing download manager");
            try {
                Unit unit2;
                ExecutorService executorService = this.executor;
                if (executorService != null) {
                    executorService.shutdown();
                    unit2 = Unit.INSTANCE;
                } else {
                    unit2 = null;
                }
                unit = unit2;
            }
            catch (Exception e) {
                unit = Unit.INSTANCE;
            }
            Unit unit3 = unit;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(int downloadId) {
        Object object = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            boolean bl4 = !this.isClosed() && this.downloadManagerCoordinator.containsFileDownloader(downloadId);
            return bl4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canAccommodateNewDownload() {
        Object object = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            boolean bl4 = !this.closed && this.downloadCounter < this.getConcurrentLimit();
            return bl4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getActiveDownloadCount() {
        Object object = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            this.throwExceptionIfClosed();
            int n = this.downloadCounter;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Download> getActiveDownloads() {
        Object object = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            void $this$mapTo$iv$iv;
            boolean bl3 = false;
            this.throwExceptionIfClosed();
            Collection<FileDownloader> collection = this.currentDownloadsMap.values();
            Intrinsics.checkExpressionValueIsNotNull(collection, (String)"currentDownloadsMap.values");
            Iterable $this$map$iv = CollectionsKt.filterNotNull((Iterable)collection);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                FileDownloader fileDownloader = (FileDownloader)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl4 = false;
                Download download = it.getDownload();
                collection2.add(download);
            }
            List list = (List)destination$iv$iv;
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Integer> getActiveDownloadsIds() {
        Object object = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            void $this$mapTo$iv$iv;
            Map.Entry it;
            Map $this$filterTo$iv$iv;
            boolean bl3 = false;
            this.throwExceptionIfClosed();
            Map $this$filter$iv = this.currentDownloadsMap;
            boolean $i$f$filter = false;
            Map map = $this$filter$iv;
            Object destination$iv$iv = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            void var10_11 = $this$filterTo$iv$iv;
            boolean bl4 = false;
            Iterator iterator = var10_11.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv$iv;
                it = element$iv$iv = iterator.next();
                boolean bl5 = false;
                if (!(it.getValue() != null)) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            Map $this$map$iv = destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            var10_11 = $this$mapTo$iv$iv;
            bl4 = false;
            for (Map.Entry item$iv$iv : var10_11.entrySet()) {
                it = item$iv$iv;
                Object object2 = destination$iv$iv;
                boolean bl6 = false;
                Integer n = ((Number)it.getKey()).intValue();
                object2.add(n);
            }
            List list = (List)destination$iv$iv;
            return list;
        }
    }

    private final void throwExceptionIfClosed() {
        if (this.closed) {
            throw (Throwable)new FetchException("DownloadManager is already shutdown.");
        }
    }

    @Override
    @NotNull
    public FileDownloader getNewFileDownloaderForDownload(@NotNull Download download) {
        Intrinsics.checkParameterIsNotNull((Object)download, (String)"download");
        return !FetchCoreUtils.isFetchFileServerUrl((String)download.getUrl()) ? this.getFileDownloader(download, this.httpDownloader) : this.getFileDownloader(download, (Downloader)this.fileServerDownloader);
    }

    private final FileDownloader getFileDownloader(Download download, Downloader<?, ?> downloader) {
        Downloader.ServerRequest originalRequest = FetchUtils.getRequestForDownload$default(download, null, 2, null);
        Downloader.ServerRequest request = downloader.getHeadRequestMethodSupported(originalRequest) ? FetchUtils.getRequestForDownload(download, "HEAD") : originalRequest;
        Set supportedDownloadTypes = downloader.getRequestSupportedFileDownloaderTypes(request);
        return downloader.getRequestFileDownloaderType(request, supportedDownloadTypes) == Downloader.FileDownloaderType.SEQUENTIAL ? (FileDownloader)new SequentialFileDownloaderImpl(download, downloader, this.progressReportingIntervalMillis, this.logger, this.networkInfoProvider, this.retryOnNetworkGain, this.hashCheckingEnabled, this.storageResolver, this.preAllocateFileOnCreation) : (FileDownloader)new ParallelFileDownloaderImpl(download, downloader, this.progressReportingIntervalMillis, this.logger, this.networkInfoProvider, this.retryOnNetworkGain, this.storageResolver.getDirectoryForFileDownloaderTypeParallel(request), this.hashCheckingEnabled, this.storageResolver, this.preAllocateFileOnCreation);
    }

    @Override
    @NotNull
    public FileDownloader.Delegate getFileDownloaderDelegate() {
        return new FileDownloaderDelegate(this.downloadInfoUpdater, this.listenerCoordinator.getMainListener(), this.retryOnNetworkGain, this.globalAutoRetryMaxAttempts);
    }

    @Override
    @NotNull
    public String getDownloadFileTempDir(@NotNull Download download) {
        Intrinsics.checkParameterIsNotNull((Object)download, (String)"download");
        Downloader.ServerRequest request = FetchUtils.getRequestForDownload$default(download, null, 2, null);
        return this.storageResolver.getDirectoryForFileDownloaderTypeParallel(request);
    }

    private final ExecutorService getNewDownloadExecutorService(int concurrentLimit) {
        return concurrentLimit > 0 ? Executors.newFixedThreadPool(concurrentLimit) : null;
    }

    public DownloadManagerImpl(@NotNull Downloader<?, ?> httpDownloader, int concurrentLimit, long progressReportingIntervalMillis, @NotNull Logger logger, @NotNull NetworkInfoProvider networkInfoProvider, boolean retryOnNetworkGain, @NotNull DownloadInfoUpdater downloadInfoUpdater, @NotNull DownloadManagerCoordinator downloadManagerCoordinator, @NotNull ListenerCoordinator listenerCoordinator, @NotNull FileServerDownloader fileServerDownloader, boolean hashCheckingEnabled, @NotNull StorageResolver storageResolver, @NotNull Context context, @NotNull String namespace, @NotNull GroupInfoProvider groupInfoProvider, int globalAutoRetryMaxAttempts, boolean preAllocateFileOnCreation) {
        Intrinsics.checkParameterIsNotNull(httpDownloader, (String)"httpDownloader");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        Intrinsics.checkParameterIsNotNull((Object)networkInfoProvider, (String)"networkInfoProvider");
        Intrinsics.checkParameterIsNotNull((Object)downloadInfoUpdater, (String)"downloadInfoUpdater");
        Intrinsics.checkParameterIsNotNull((Object)downloadManagerCoordinator, (String)"downloadManagerCoordinator");
        Intrinsics.checkParameterIsNotNull((Object)listenerCoordinator, (String)"listenerCoordinator");
        Intrinsics.checkParameterIsNotNull((Object)fileServerDownloader, (String)"fileServerDownloader");
        Intrinsics.checkParameterIsNotNull((Object)storageResolver, (String)"storageResolver");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)namespace, (String)"namespace");
        Intrinsics.checkParameterIsNotNull((Object)groupInfoProvider, (String)"groupInfoProvider");
        this.httpDownloader = httpDownloader;
        this.progressReportingIntervalMillis = progressReportingIntervalMillis;
        this.logger = logger;
        this.networkInfoProvider = networkInfoProvider;
        this.retryOnNetworkGain = retryOnNetworkGain;
        this.downloadInfoUpdater = downloadInfoUpdater;
        this.downloadManagerCoordinator = downloadManagerCoordinator;
        this.listenerCoordinator = listenerCoordinator;
        this.fileServerDownloader = fileServerDownloader;
        this.hashCheckingEnabled = hashCheckingEnabled;
        this.storageResolver = storageResolver;
        this.context = context;
        this.namespace = namespace;
        this.groupInfoProvider = groupInfoProvider;
        this.globalAutoRetryMaxAttempts = globalAutoRetryMaxAttempts;
        this.preAllocateFileOnCreation = preAllocateFileOnCreation;
        this.lock = new Object();
        this.executor = this.getNewDownloadExecutorService(concurrentLimit);
        this.concurrentLimit = concurrentLimit;
        DownloadManagerImpl downloadManagerImpl = this;
        boolean bl = false;
        HashMap hashMap = new HashMap();
        downloadManagerImpl.currentDownloadsMap = hashMap;
    }

    public static final /* synthetic */ Object access$getLock$p(DownloadManagerImpl $this) {
        return $this.lock;
    }

    public static final /* synthetic */ HashMap access$getCurrentDownloadsMap$p(DownloadManagerImpl $this) {
        return $this.currentDownloadsMap;
    }

    public static final /* synthetic */ DownloadManagerCoordinator access$getDownloadManagerCoordinator$p(DownloadManagerImpl $this) {
        return $this.downloadManagerCoordinator;
    }

    public static final /* synthetic */ Logger access$getLogger$p(DownloadManagerImpl $this) {
        return $this.logger;
    }

    public static final /* synthetic */ void access$removeDownloadMappings(DownloadManagerImpl $this, Download download) {
        $this.removeDownloadMappings(download);
    }

    public static final /* synthetic */ GroupInfoProvider access$getGroupInfoProvider$p(DownloadManagerImpl $this) {
        return $this.groupInfoProvider;
    }

    public static final /* synthetic */ Context access$getContext$p(DownloadManagerImpl $this) {
        return $this.context;
    }

    public static final /* synthetic */ String access$getNamespace$p(DownloadManagerImpl $this) {
        return $this.namespace;
    }
}

