package com.tonyodev.fetch2.database;

import androidx.annotation.NonNull;
import androidx.room.DatabaseConfiguration;
import androidx.room.InvalidationTracker;
import androidx.room.RoomDatabase;
import androidx.room.RoomOpenHelper;
import androidx.room.migration.AutoMigrationSpec;
import androidx.room.migration.Migration;
import androidx.room.util.DBUtil;
import androidx.room.util.TableInfo;
import androidx.sqlite.db.SupportSQLiteDatabase;
import androidx.sqlite.db.SupportSQLiteOpenHelper;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.Generated;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class DownloadDatabase_Impl extends DownloadDatabase {
  private volatile DownloadDao _downloadDao;

  @Override
  @NonNull
  protected SupportSQLiteOpenHelper createOpenHelper(@NonNull final DatabaseConfiguration config) {
    final SupportSQLiteOpenHelper.Callback _openCallback = new RoomOpenHelper(config, new RoomOpenHelper.Delegate(7) {
      @Override
      public void createAllTables(@NonNull final SupportSQLiteDatabase db) {
        db.execSQL("CREATE TABLE IF NOT EXISTS `requests` (`_id` INTEGER NOT NULL, `_namespace` TEXT NOT NULL, `_url` TEXT NOT NULL, `_file` TEXT NOT NULL, `_group` INTEGER NOT NULL, `_priority` INTEGER NOT NULL, `_headers` TEXT NOT NULL, `_written_bytes` INTEGER NOT NULL, `_total_bytes` INTEGER NOT NULL, `_status` INTEGER NOT NULL, `_error` INTEGER NOT NULL, `_network_type` INTEGER NOT NULL, `_created` INTEGER NOT NULL, `_tag` TEXT, `_enqueue_action` INTEGER NOT NULL, `_identifier` INTEGER NOT NULL, `_download_on_enqueue` INTEGER NOT NULL, `_extras` TEXT NOT NULL, `_auto_retry_max_attempts` INTEGER NOT NULL, `_auto_retry_attempts` INTEGER NOT NULL, PRIMARY KEY(`_id`))");
        db.execSQL("CREATE UNIQUE INDEX IF NOT EXISTS `index_requests__file` ON `requests` (`_file`)");
        db.execSQL("CREATE INDEX IF NOT EXISTS `index_requests__group__status` ON `requests` (`_group`, `_status`)");
        db.execSQL("CREATE TABLE IF NOT EXISTS room_master_table (id INTEGER PRIMARY KEY,identity_hash TEXT)");
        db.execSQL("INSERT OR REPLACE INTO room_master_table (id,identity_hash) VALUES(42, '460643a974555d792b8f5a6e1a5d323c')");
      }

      @Override
      public void dropAllTables(@NonNull final SupportSQLiteDatabase db) {
        db.execSQL("DROP TABLE IF EXISTS `requests`");
        final List<? extends RoomDatabase.Callback> _callbacks = mCallbacks;
        if (_callbacks != null) {
          for (RoomDatabase.Callback _callback : _callbacks) {
            _callback.onDestructiveMigration(db);
          }
        }
      }

      @Override
      public void onCreate(@NonNull final SupportSQLiteDatabase db) {
        final List<? extends RoomDatabase.Callback> _callbacks = mCallbacks;
        if (_callbacks != null) {
          for (RoomDatabase.Callback _callback : _callbacks) {
            _callback.onCreate(db);
          }
        }
      }

      @Override
      public void onOpen(@NonNull final SupportSQLiteDatabase db) {
        mDatabase = db;
        internalInitInvalidationTracker(db);
        final List<? extends RoomDatabase.Callback> _callbacks = mCallbacks;
        if (_callbacks != null) {
          for (RoomDatabase.Callback _callback : _callbacks) {
            _callback.onOpen(db);
          }
        }
      }

      @Override
      public void onPreMigrate(@NonNull final SupportSQLiteDatabase db) {
        DBUtil.dropFtsSyncTriggers(db);
      }

      @Override
      public void onPostMigrate(@NonNull final SupportSQLiteDatabase db) {
      }

      @Override
      @NonNull
      public RoomOpenHelper.ValidationResult onValidateSchema(
          @NonNull final SupportSQLiteDatabase db) {
        final HashMap<String, TableInfo.Column> _columnsRequests = new HashMap<String, TableInfo.Column>(20);
        _columnsRequests.put("_id", new TableInfo.Column("_id", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsRequests.put("_namespace", new TableInfo.Column("_namespace", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsRequests.put("_url", new TableInfo.Column("_url", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsRequests.put("_file", new TableInfo.Column("_file", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsRequests.put("_group", new TableInfo.Column("_group", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsRequests.put("_priority", new TableInfo.Column("_priority", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsRequests.put("_headers", new TableInfo.Column("_headers", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsRequests.put("_written_bytes", new TableInfo.Column("_written_bytes", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsRequests.put("_total_bytes", new TableInfo.Column("_total_bytes", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsRequests.put("_status", new TableInfo.Column("_status", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsRequests.put("_error", new TableInfo.Column("_error", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsRequests.put("_network_type", new TableInfo.Column("_network_type", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsRequests.put("_created", new TableInfo.Column("_created", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsRequests.put("_tag", new TableInfo.Column("_tag", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsRequests.put("_enqueue_action", new TableInfo.Column("_enqueue_action", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsRequests.put("_identifier", new TableInfo.Column("_identifier", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsRequests.put("_download_on_enqueue", new TableInfo.Column("_download_on_enqueue", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsRequests.put("_extras", new TableInfo.Column("_extras", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsRequests.put("_auto_retry_max_attempts", new TableInfo.Column("_auto_retry_max_attempts", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsRequests.put("_auto_retry_attempts", new TableInfo.Column("_auto_retry_attempts", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysRequests = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesRequests = new HashSet<TableInfo.Index>(2);
        _indicesRequests.add(new TableInfo.Index("index_requests__file", true, Arrays.asList("_file"), Arrays.asList("ASC")));
        _indicesRequests.add(new TableInfo.Index("index_requests__group__status", false, Arrays.asList("_group", "_status"), Arrays.asList("ASC", "ASC")));
        final TableInfo _infoRequests = new TableInfo("requests", _columnsRequests, _foreignKeysRequests, _indicesRequests);
        final TableInfo _existingRequests = TableInfo.read(db, "requests");
        if (!_infoRequests.equals(_existingRequests)) {
          return new RoomOpenHelper.ValidationResult(false, "requests(com.tonyodev.fetch2.database.DownloadInfo).\n"
                  + " Expected:\n" + _infoRequests + "\n"
                  + " Found:\n" + _existingRequests);
        }
        return new RoomOpenHelper.ValidationResult(true, null);
      }
    }, "460643a974555d792b8f5a6e1a5d323c", "946eca6b182e63ebe50cf82e483715bf");
    final SupportSQLiteOpenHelper.Configuration _sqliteConfig = SupportSQLiteOpenHelper.Configuration.builder(config.context).name(config.name).callback(_openCallback).build();
    final SupportSQLiteOpenHelper _helper = config.sqliteOpenHelperFactory.create(_sqliteConfig);
    return _helper;
  }

  @Override
  @NonNull
  protected InvalidationTracker createInvalidationTracker() {
    final HashMap<String, String> _shadowTablesMap = new HashMap<String, String>(0);
    final HashMap<String, Set<String>> _viewTables = new HashMap<String, Set<String>>(0);
    return new InvalidationTracker(this, _shadowTablesMap, _viewTables, "requests");
  }

  @Override
  public void clearAllTables() {
    super.assertNotMainThread();
    final SupportSQLiteDatabase _db = super.getOpenHelper().getWritableDatabase();
    try {
      super.beginTransaction();
      _db.execSQL("DELETE FROM `requests`");
      super.setTransactionSuccessful();
    } finally {
      super.endTransaction();
      _db.query("PRAGMA wal_checkpoint(FULL)").close();
      if (!_db.inTransaction()) {
        _db.execSQL("VACUUM");
      }
    }
  }

  @Override
  @NonNull
  protected Map<Class<?>, List<Class<?>>> getRequiredTypeConverters() {
    final HashMap<Class<?>, List<Class<?>>> _typeConvertersMap = new HashMap<Class<?>, List<Class<?>>>();
    _typeConvertersMap.put(DownloadDao.class, DownloadDao_Impl.getRequiredConverters());
    return _typeConvertersMap;
  }

  @Override
  @NonNull
  public Set<Class<? extends AutoMigrationSpec>> getRequiredAutoMigrationSpecs() {
    final HashSet<Class<? extends AutoMigrationSpec>> _autoMigrationSpecsSet = new HashSet<Class<? extends AutoMigrationSpec>>();
    return _autoMigrationSpecsSet;
  }

  @Override
  @NonNull
  public List<Migration> getAutoMigrations(
      @NonNull final Map<Class<? extends AutoMigrationSpec>, AutoMigrationSpec> autoMigrationSpecs) {
    final List<Migration> _autoMigrations = new ArrayList<Migration>();
    return _autoMigrations;
  }

  @Override
  public DownloadDao requestDao() {
    if (_downloadDao != null) {
      return _downloadDao;
    } else {
      synchronized(this) {
        if(_downloadDao == null) {
          _downloadDao = new DownloadDao_Impl(this);
        }
        return _downloadDao;
      }
    }
  }
}
