/*
 * Decompiled with CFR 0.152.
 */
package com.tonyodev.fetch2.provider;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkRequest;
import android.os.Build;
import com.tonyodev.fetch2.NetworkType;
import com.tonyodev.fetch2core.FetchAndroidExtensions;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashSet;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u001fB\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0014\u001a\u00020\u0015H\u0002J\u000e\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u000bJ\u000e\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u000bJ\u0006\u0010\u0019\u001a\u00020\u0015J\u000e\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u001cR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u000b0\nj\b\u0012\u0004\u0012\u00020\u000b`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001d\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006 "}, d2={"Lcom/tonyodev/fetch2/provider/NetworkInfoProvider;", "", "context", "Landroid/content/Context;", "internetCheckUrl", "", "<init>", "(Landroid/content/Context;Ljava/lang/String;)V", "lock", "networkChangeListenerSet", "Ljava/util/HashSet;", "Lcom/tonyodev/fetch2/provider/NetworkInfoProvider$NetworkChangeListener;", "Lkotlin/collections/HashSet;", "connectivityManager", "Landroid/net/ConnectivityManager;", "networkChangeBroadcastReceiver", "Landroid/content/BroadcastReceiver;", "broadcastRegistered", "", "networkCallback", "notifyNetworkChangeListeners", "", "registerNetworkChangeListener", "networkChangeListener", "unregisterNetworkChangeListener", "unregisterAllNetworkChangeListeners", "isOnAllowedNetwork", "networkType", "Lcom/tonyodev/fetch2/NetworkType;", "isNetworkAvailable", "()Z", "NetworkChangeListener", "fetch2_release"})
@SourceDebugExtension(value={"SMAP\nNetworkInfoProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NetworkInfoProvider.kt\ncom/tonyodev/fetch2/provider/NetworkInfoProvider\n+ 2 Iterators.kt\nkotlin/collections/CollectionsKt__IteratorsKt\n*L\n1#1,145:1\n32#2,2:146\n*S KotlinDebug\n*F\n+ 1 NetworkInfoProvider.kt\ncom/tonyodev/fetch2/provider/NetworkInfoProvider\n*L\n69#1:146,2\n*E\n"})
public final class NetworkInfoProvider {
    @NotNull
    private final Context context;
    @Nullable
    private final String internetCheckUrl;
    @NotNull
    private final Object lock;
    @NotNull
    private final HashSet<NetworkChangeListener> networkChangeListenerSet;
    @Nullable
    private final ConnectivityManager connectivityManager;
    @NotNull
    private final BroadcastReceiver networkChangeBroadcastReceiver;
    private boolean broadcastRegistered;
    @Nullable
    private Object networkCallback;

    public NetworkInfoProvider(@NotNull Context context, @Nullable String internetCheckUrl) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.internetCheckUrl = internetCheckUrl;
        this.lock = new Object();
        this.networkChangeListenerSet = new HashSet();
        Object object = this.context.getSystemService("connectivity");
        this.connectivityManager = object instanceof ConnectivityManager ? (ConnectivityManager)object : null;
        this.networkChangeBroadcastReceiver = new BroadcastReceiver(this){
            final /* synthetic */ NetworkInfoProvider this$0;
            {
                this.this$0 = $receiver;
            }

            public void onReceive(Context context, Intent intent) {
                NetworkInfoProvider.access$notifyNetworkChangeListeners(this.this$0);
            }
        };
        if (Build.VERSION.SDK_INT >= 21 && this.connectivityManager != null) {
            NetworkRequest networkRequest = new NetworkRequest.Builder().addTransportType(0).addTransportType(1).addTransportType(3).build();
            ConnectivityManager.NetworkCallback networkCallback2 = new ConnectivityManager.NetworkCallback(this){
                final /* synthetic */ NetworkInfoProvider this$0;
                {
                    this.this$0 = $receiver;
                }

                public void onLost(Network network) {
                    Intrinsics.checkNotNullParameter((Object)network, (String)"network");
                    NetworkInfoProvider.access$notifyNetworkChangeListeners(this.this$0);
                }

                public void onAvailable(Network network) {
                    Intrinsics.checkNotNullParameter((Object)network, (String)"network");
                    NetworkInfoProvider.access$notifyNetworkChangeListeners(this.this$0);
                }
            };
            this.networkCallback = networkCallback2;
            this.connectivityManager.registerNetworkCallback(networkRequest, networkCallback2);
        } else {
            try {
                Intent intent = Build.VERSION.SDK_INT >= 33 ? this.context.registerReceiver(this.networkChangeBroadcastReceiver, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"), 2) : this.context.registerReceiver(this.networkChangeBroadcastReceiver, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
                this.broadcastRegistered = true;
            }
            catch (Exception exception) {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void notifyNetworkChangeListeners() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            Iterator<NetworkChangeListener> iterator = this.networkChangeListenerSet.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            Iterator<NetworkChangeListener> $this$forEach$iv = iterator;
            boolean $i$f$forEach = false;
            Iterator<NetworkChangeListener> iterator2 = $this$forEach$iv;
            while (iterator2.hasNext()) {
                NetworkChangeListener element$iv;
                NetworkChangeListener listener = element$iv = iterator2.next();
                boolean bl2 = false;
                listener.onNetworkChanged();
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void registerNetworkChangeListener(@NotNull NetworkChangeListener networkChangeListener2) {
        Intrinsics.checkNotNullParameter((Object)networkChangeListener2, (String)"networkChangeListener");
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            boolean bl2 = this.networkChangeListenerSet.add(networkChangeListener2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unregisterNetworkChangeListener(@NotNull NetworkChangeListener networkChangeListener2) {
        Intrinsics.checkNotNullParameter((Object)networkChangeListener2, (String)"networkChangeListener");
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            boolean bl2 = this.networkChangeListenerSet.remove(networkChangeListener2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unregisterAllNetworkChangeListeners() {
        Object object = this.lock;
        synchronized (object) {
            Object networkCallback2;
            boolean bl = false;
            this.networkChangeListenerSet.clear();
            if (this.broadcastRegistered) {
                try {
                    this.context.unregisterReceiver(this.networkChangeBroadcastReceiver);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (Build.VERSION.SDK_INT >= 21 && this.connectivityManager != null && (networkCallback2 = this.networkCallback) instanceof ConnectivityManager.NetworkCallback) {
                this.connectivityManager.unregisterNetworkCallback((ConnectivityManager.NetworkCallback)networkCallback2);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    public final boolean isOnAllowedNetwork(@NotNull NetworkType networkType) {
        Intrinsics.checkNotNullParameter((Object)((Object)networkType), (String)"networkType");
        if (networkType == NetworkType.WIFI_ONLY && FetchAndroidExtensions.isOnWiFi((Context)this.context)) {
            return true;
        }
        if (networkType == NetworkType.UNMETERED && !FetchAndroidExtensions.isOnMeteredConnection((Context)this.context)) {
            return true;
        }
        return networkType == NetworkType.ALL && FetchAndroidExtensions.isNetworkAvailable((Context)this.context);
    }

    public final boolean isNetworkAvailable() {
        boolean bl;
        String url = this.internetCheckUrl;
        if (url != null) {
            boolean bl2;
            try {
                URL urlConnection = new URL(url);
                URLConnection uRLConnection = urlConnection.openConnection();
                Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
                HttpURLConnection connection = (HttpURLConnection)uRLConnection;
                connection.setConnectTimeout(15000);
                connection.setReadTimeout(20000);
                connection.setInstanceFollowRedirects(true);
                connection.setUseCaches(false);
                connection.setDefaultUseCaches(false);
                connection.connect();
                bl2 = connection.getResponseCode() != -1;
            }
            catch (Exception e) {
                bl2 = false;
            }
            bl = bl2;
        } else {
            bl = FetchAndroidExtensions.isNetworkAvailable((Context)this.context);
        }
        return bl;
    }

    public static final /* synthetic */ void access$notifyNetworkChangeListeners(NetworkInfoProvider $this) {
        $this.notifyNetworkChangeListeners();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00a8\u0006\u0004"}, d2={"Lcom/tonyodev/fetch2/provider/NetworkInfoProvider$NetworkChangeListener;", "", "onNetworkChanged", "", "fetch2_release"})
    public static interface NetworkChangeListener {
        public void onNetworkChanged();
    }
}

