/*
 * Decompiled with CFR 0.152.
 */
package com.tonyodev.fetch2.helper;

import com.tonyodev.fetch2.Download;
import com.tonyodev.fetch2.Error;
import com.tonyodev.fetch2.FetchListener;
import com.tonyodev.fetch2.Status;
import com.tonyodev.fetch2.database.DownloadInfo;
import com.tonyodev.fetch2.downloader.FileDownloader;
import com.tonyodev.fetch2.helper.DownloadInfoUpdater;
import com.tonyodev.fetch2.util.FetchDefaults;
import com.tonyodev.fetch2core.DownloadBlock;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ&\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\tH\u0016J \u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0016J \u0010\u001d\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\tH\u0016J\"\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0016J\u0010\u0010$\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010%\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010&\u001a\u00020'H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u00020\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006("}, d2={"Lcom/tonyodev/fetch2/helper/FileDownloaderDelegate;", "Lcom/tonyodev/fetch2/downloader/FileDownloader$Delegate;", "downloadInfoUpdater", "Lcom/tonyodev/fetch2/helper/DownloadInfoUpdater;", "fetchListener", "Lcom/tonyodev/fetch2/FetchListener;", "retryOnNetworkGain", "", "globalAutoRetryMaxAttempts", "", "<init>", "(Lcom/tonyodev/fetch2/helper/DownloadInfoUpdater;Lcom/tonyodev/fetch2/FetchListener;ZI)V", "interrupted", "getInterrupted", "()Z", "setInterrupted", "(Z)V", "onStarted", "", "download", "Lcom/tonyodev/fetch2/Download;", "downloadBlocks", "", "Lcom/tonyodev/fetch2core/DownloadBlock;", "totalBlocks", "onProgress", "etaInMilliSeconds", "", "downloadedBytesPerSecond", "onDownloadBlockUpdated", "downloadBlock", "onError", "error", "Lcom/tonyodev/fetch2/Error;", "throwable", "", "onComplete", "saveDownloadProgress", "getNewDownloadInfoInstance", "Lcom/tonyodev/fetch2/database/DownloadInfo;", "fetch2_release"})
public final class FileDownloaderDelegate
implements FileDownloader.Delegate {
    @NotNull
    private final DownloadInfoUpdater downloadInfoUpdater;
    @NotNull
    private final FetchListener fetchListener;
    private final boolean retryOnNetworkGain;
    private final int globalAutoRetryMaxAttempts;
    private volatile boolean interrupted;

    public FileDownloaderDelegate(@NotNull DownloadInfoUpdater downloadInfoUpdater, @NotNull FetchListener fetchListener, boolean retryOnNetworkGain, int globalAutoRetryMaxAttempts) {
        Intrinsics.checkNotNullParameter((Object)downloadInfoUpdater, (String)"downloadInfoUpdater");
        Intrinsics.checkNotNullParameter((Object)fetchListener, (String)"fetchListener");
        this.downloadInfoUpdater = downloadInfoUpdater;
        this.fetchListener = fetchListener;
        this.retryOnNetworkGain = retryOnNetworkGain;
        this.globalAutoRetryMaxAttempts = globalAutoRetryMaxAttempts;
    }

    @Override
    public boolean getInterrupted() {
        return this.interrupted;
    }

    public void setInterrupted(boolean bl) {
        this.interrupted = bl;
    }

    @Override
    public void onStarted(@NotNull Download download, @NotNull List<? extends DownloadBlock> downloadBlocks, int totalBlocks) {
        Intrinsics.checkNotNullParameter((Object)download, (String)"download");
        Intrinsics.checkNotNullParameter(downloadBlocks, (String)"downloadBlocks");
        if (!this.getInterrupted()) {
            DownloadInfo downloadInfo = (DownloadInfo)download;
            downloadInfo.setStatus(Status.DOWNLOADING);
            this.downloadInfoUpdater.update(downloadInfo);
            this.fetchListener.onStarted(download, downloadBlocks, totalBlocks);
        }
    }

    @Override
    public void onProgress(@NotNull Download download, long etaInMilliSeconds, long downloadedBytesPerSecond) {
        Intrinsics.checkNotNullParameter((Object)download, (String)"download");
        if (!this.getInterrupted()) {
            this.fetchListener.onProgress(download, etaInMilliSeconds, downloadedBytesPerSecond);
        }
    }

    @Override
    public void onDownloadBlockUpdated(@NotNull Download download, @NotNull DownloadBlock downloadBlock, int totalBlocks) {
        Intrinsics.checkNotNullParameter((Object)download, (String)"download");
        Intrinsics.checkNotNullParameter((Object)downloadBlock, (String)"downloadBlock");
        if (!this.getInterrupted()) {
            this.fetchListener.onDownloadBlockUpdated(download, downloadBlock, totalBlocks);
        }
    }

    @Override
    public void onError(@NotNull Download download, @NotNull Error error, @Nullable Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)download, (String)"download");
        Intrinsics.checkNotNullParameter((Object)((Object)error), (String)"error");
        if (!this.getInterrupted()) {
            int maxAutoRetryAttempts = this.globalAutoRetryMaxAttempts != -1 ? this.globalAutoRetryMaxAttempts : download.getAutoRetryMaxAttempts();
            DownloadInfo downloadInfo = (DownloadInfo)download;
            if (this.retryOnNetworkGain && downloadInfo.getError() == Error.NO_NETWORK_CONNECTION) {
                downloadInfo.setStatus(Status.QUEUED);
                downloadInfo.setError(FetchDefaults.getDefaultNoError());
                this.downloadInfoUpdater.update(downloadInfo);
                this.fetchListener.onQueued(download, true);
            } else if (((DownloadInfo)download).getAutoRetryAttempts() < maxAutoRetryAttempts) {
                DownloadInfo downloadInfo2 = (DownloadInfo)download;
                downloadInfo2.setAutoRetryAttempts(downloadInfo2.getAutoRetryAttempts() + 1);
                downloadInfo.setStatus(Status.QUEUED);
                downloadInfo.setError(FetchDefaults.getDefaultNoError());
                this.downloadInfoUpdater.update(downloadInfo);
                this.fetchListener.onQueued(download, true);
            } else {
                downloadInfo.setStatus(Status.FAILED);
                this.downloadInfoUpdater.update(downloadInfo);
                this.fetchListener.onError(download, error, throwable);
            }
        }
    }

    @Override
    public void onComplete(@NotNull Download download) {
        Intrinsics.checkNotNullParameter((Object)download, (String)"download");
        if (!this.getInterrupted()) {
            DownloadInfo downloadInfo = (DownloadInfo)download;
            downloadInfo.setStatus(Status.COMPLETED);
            this.downloadInfoUpdater.update(downloadInfo);
            this.fetchListener.onCompleted(download);
        }
    }

    @Override
    public void saveDownloadProgress(@NotNull Download download) {
        Intrinsics.checkNotNullParameter((Object)download, (String)"download");
        if (!this.getInterrupted()) {
            DownloadInfo downloadInfo = (DownloadInfo)download;
            downloadInfo.setStatus(Status.DOWNLOADING);
            this.downloadInfoUpdater.updateFileBytesInfoAndStatusOnly(downloadInfo);
        }
    }

    @Override
    @NotNull
    public DownloadInfo getNewDownloadInfoInstance() {
        return this.downloadInfoUpdater.getNewDownloadInfoInstance();
    }
}

