/*
 * Decompiled with CFR 0.152.
 */
package com.tonyodev.fetch2.database;

import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteException;
import androidx.room.Room;
import androidx.room.RoomDatabase;
import androidx.sqlite.db.SupportSQLiteDatabase;
import com.tonyodev.fetch2.PrioritySort;
import com.tonyodev.fetch2.Status;
import com.tonyodev.fetch2.database.DownloadDatabase;
import com.tonyodev.fetch2.database.DownloadInfo;
import com.tonyodev.fetch2.database.FetchDatabaseManager;
import com.tonyodev.fetch2.database.migration.Migration;
import com.tonyodev.fetch2.exception.FetchException;
import com.tonyodev.fetch2.fetch.LiveSettings;
import com.tonyodev.fetch2.util.FetchDefaults;
import com.tonyodev.fetch2core.DefaultStorageResolver;
import com.tonyodev.fetch2core.Extras;
import com.tonyodev.fetch2core.Logger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010!\n\u0002\b\u000b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001BE\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001c\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u000f0$2\u0006\u0010%\u001a\u00020\u0002H\u0016J(\u0010#\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u000f0$0&2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00020&H\u0016J\u0010\u0010(\u001a\u00020)2\u0006\u0010%\u001a\u00020\u0002H\u0016J\u0016\u0010(\u001a\u00020)2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00020&H\u0016J\b\u0010*\u001a\u00020)H\u0016J\u0010\u0010+\u001a\u00020)2\u0006\u0010%\u001a\u00020\u0002H\u0016J\u0016\u0010+\u001a\u00020)2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00020&H\u0016J\u0010\u0010,\u001a\u00020)2\u0006\u0010%\u001a\u00020\u0002H\u0016J\u001a\u0010-\u001a\u0004\u0018\u00010\u00022\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0016J\u000e\u00102\u001a\b\u0012\u0004\u0012\u00020\u00020&H\u0016J\u0012\u00102\u001a\u0004\u0018\u00010\u00022\u0006\u0010.\u001a\u00020/H\u0016J\u001e\u00102\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020&2\f\u00103\u001a\b\u0012\u0004\u0012\u00020/0&H\u0016J\u0012\u00104\u001a\u0004\u0018\u00010\u00022\u0006\u00105\u001a\u00020\u0006H\u0016J\u0016\u00106\u001a\b\u0012\u0004\u0012\u00020\u00020&2\u0006\u00107\u001a\u000208H\u0016J\u001c\u00106\u001a\b\u0012\u0004\u0012\u00020\u00020&2\f\u00109\u001a\b\u0012\u0004\u0012\u0002080&H\u0016J\u0016\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00020&2\u0006\u0010;\u001a\u00020/H\u0016J$\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00020&2\u0006\u0010=\u001a\u00020/2\f\u00109\u001a\b\u0012\u0004\u0012\u0002080&H\u0016J\u0016\u0010>\u001a\b\u0012\u0004\u0012\u00020\u00020&2\u0006\u0010?\u001a\u00020@H\u0016J\u0016\u0010A\u001a\b\u0012\u0004\u0012\u00020\u00020&2\u0006\u0010B\u001a\u00020CH\u0016J\u000e\u0010D\u001a\b\u0012\u0004\u0012\u00020/0&H\u0016J\u0016\u0010E\u001a\b\u0012\u0004\u0012\u00020\u00020&2\u0006\u0010F\u001a\u00020\u0006H\u0016J\u0010\u0010I\u001a\u00020@2\u0006\u0010J\u001a\u00020\u000fH\u0016J\b\u0010K\u001a\u00020)H\u0016J \u0010N\u001a\u00020\u000f2\f\u0010O\u001a\b\u0012\u0004\u0012\u00020\u00020&2\b\b\u0002\u0010P\u001a\u00020\u000fH\u0002J\u0010\u0010Q\u001a\u00020)2\u0006\u0010%\u001a\u00020\u0002H\u0002J\u0018\u0010R\u001a\u00020)2\u0006\u0010%\u001a\u00020\u00022\u0006\u0010P\u001a\u00020\u000fH\u0002J\u0010\u0010S\u001a\u00020)2\u0006\u0010%\u001a\u00020\u0002H\u0002J\u001c\u0010N\u001a\u00020\u000f2\b\u0010%\u001a\u0004\u0018\u00010\u00022\b\b\u0002\u0010T\u001a\u00020\u000fH\u0002J\b\u0010U\u001a\u00020)H\u0016J\b\u0010V\u001a\u00020\u0002H\u0016J\b\u0010W\u001a\u00020)H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\"\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u001aX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010G\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010H\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010L\u001a\b\u0012\u0004\u0012\u00020\u00020MX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006X"}, d2={"Lcom/tonyodev/fetch2/database/FetchDatabaseManagerImpl;", "Lcom/tonyodev/fetch2/database/FetchDatabaseManager;", "Lcom/tonyodev/fetch2/database/DownloadInfo;", "context", "Landroid/content/Context;", "namespace", "", "logger", "Lcom/tonyodev/fetch2core/Logger;", "migrations", "", "Lcom/tonyodev/fetch2/database/migration/Migration;", "liveSettings", "Lcom/tonyodev/fetch2/fetch/LiveSettings;", "fileExistChecksEnabled", "", "defaultStorageResolver", "Lcom/tonyodev/fetch2core/DefaultStorageResolver;", "<init>", "(Landroid/content/Context;Ljava/lang/String;Lcom/tonyodev/fetch2core/Logger;[Lcom/tonyodev/fetch2/database/migration/Migration;Lcom/tonyodev/fetch2/fetch/LiveSettings;ZLcom/tonyodev/fetch2core/DefaultStorageResolver;)V", "getLogger", "()Lcom/tonyodev/fetch2core/Logger;", "closed", "isClosed", "()Z", "delegate", "Lcom/tonyodev/fetch2/database/FetchDatabaseManager$Delegate;", "getDelegate", "()Lcom/tonyodev/fetch2/database/FetchDatabaseManager$Delegate;", "setDelegate", "(Lcom/tonyodev/fetch2/database/FetchDatabaseManager$Delegate;)V", "requestDatabase", "Lcom/tonyodev/fetch2/database/DownloadDatabase;", "database", "Landroidx/sqlite/db/SupportSQLiteDatabase;", "insert", "Lkotlin/Pair;", "downloadInfo", "", "downloadInfoList", "delete", "", "deleteAll", "update", "updateFileBytesInfoAndStatusOnly", "updateExtras", "id", "", "extras", "Lcom/tonyodev/fetch2core/Extras;", "get", "ids", "getByFile", "file", "getByStatus", "status", "Lcom/tonyodev/fetch2/Status;", "statuses", "getByGroup", "group", "getDownloadsInGroupWithStatus", "groupId", "getDownloadsByRequestIdentifier", "identifier", "", "getPendingDownloadsSorted", "prioritySort", "Lcom/tonyodev/fetch2/PrioritySort;", "getAllGroupIds", "getDownloadsByTag", "tag", "pendingCountQuery", "pendingCountIncludeAddedQuery", "getPendingCount", "includeAddedDownloads", "sanitizeOnFirstEntry", "updatedDownloadsList", "", "sanitize", "downloads", "firstEntry", "onPaused", "onDownloading", "onCompleted", "initializing", "close", "getNewDownloadInfoInstance", "throwExceptionIfClosed", "fetch2_release"})
@SourceDebugExtension(value={"SMAP\nFetchDatabaseManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FetchDatabaseManagerImpl.kt\ncom/tonyodev/fetch2/database/FetchDatabaseManagerImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,359:1\n1557#2:360\n1628#2,3:361\n774#2:364\n865#2,2:365\n774#2:367\n865#2,2:368\n774#2:370\n865#2:371\n1755#2,3:372\n866#2:375\n774#2:376\n865#2,2:377\n*S KotlinDebug\n*F\n+ 1 FetchDatabaseManagerImpl.kt\ncom/tonyodev/fetch2/database/FetchDatabaseManagerImpl\n*L\n54#1:360\n54#1:361,3\n160#1:364\n160#1:365,2\n169#1:367\n169#1:368,2\n185#1:370\n185#1:371\n186#1:372,3\n185#1:375\n207#1:376\n207#1:377,2\n*E\n"})
public final class FetchDatabaseManagerImpl
implements FetchDatabaseManager<DownloadInfo> {
    @NotNull
    private final String namespace;
    @NotNull
    private final Logger logger;
    @NotNull
    private final LiveSettings liveSettings;
    private final boolean fileExistChecksEnabled;
    @NotNull
    private final DefaultStorageResolver defaultStorageResolver;
    private volatile boolean closed;
    @Nullable
    private FetchDatabaseManager.Delegate<DownloadInfo> delegate;
    @NotNull
    private final DownloadDatabase requestDatabase;
    @NotNull
    private final SupportSQLiteDatabase database;
    @NotNull
    private final String pendingCountQuery;
    @NotNull
    private final String pendingCountIncludeAddedQuery;
    @NotNull
    private final List<DownloadInfo> updatedDownloadsList;

    public FetchDatabaseManagerImpl(@NotNull Context context, @NotNull String namespace, @NotNull Logger logger, @NotNull Migration[] migrations, @NotNull LiveSettings liveSettings, boolean fileExistChecksEnabled, @NotNull DefaultStorageResolver defaultStorageResolver) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)migrations, (String)"migrations");
        Intrinsics.checkNotNullParameter((Object)liveSettings, (String)"liveSettings");
        Intrinsics.checkNotNullParameter((Object)defaultStorageResolver, (String)"defaultStorageResolver");
        this.namespace = namespace;
        this.logger = logger;
        this.liveSettings = liveSettings;
        this.fileExistChecksEnabled = fileExistChecksEnabled;
        this.defaultStorageResolver = defaultStorageResolver;
        RoomDatabase.Builder builder = Room.databaseBuilder((Context)context, DownloadDatabase.class, (String)(this.namespace + ".db"));
        builder.addMigrations((androidx.room.migration.Migration[])Arrays.copyOf(migrations, migrations.length));
        this.requestDatabase = (DownloadDatabase)builder.build();
        this.database = this.requestDatabase.getOpenHelper().getWritableDatabase();
        this.pendingCountQuery = "SELECT _id FROM requests WHERE _status = '" + Status.QUEUED.getValue() + "' OR _status = '" + Status.DOWNLOADING.getValue() + "'";
        this.pendingCountIncludeAddedQuery = "SELECT _id FROM requests WHERE _status = '" + Status.QUEUED.getValue() + "' OR _status = '" + Status.DOWNLOADING.getValue() + "' OR _status = '" + Status.ADDED.getValue() + "'";
        this.updatedDownloadsList = new ArrayList();
    }

    @Override
    @NotNull
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    @Nullable
    public FetchDatabaseManager.Delegate<DownloadInfo> getDelegate() {
        return this.delegate;
    }

    @Override
    public void setDelegate(@Nullable FetchDatabaseManager.Delegate<DownloadInfo> delegate) {
        this.delegate = delegate;
    }

    @Override
    @NotNull
    public Pair<DownloadInfo, Boolean> insert(@NotNull DownloadInfo downloadInfo) {
        Intrinsics.checkNotNullParameter((Object)downloadInfo, (String)"downloadInfo");
        this.throwExceptionIfClosed();
        long row = this.requestDatabase.requestDao().insert(downloadInfo);
        return new Pair((Object)downloadInfo, (Object)this.requestDatabase.wasRowInserted(row));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Pair<DownloadInfo, Boolean>> insert(@NotNull List<? extends DownloadInfo> downloadInfoList) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(downloadInfoList, (String)"downloadInfoList");
        this.throwExceptionIfClosed();
        List<Long> rowsList = this.requestDatabase.requestDao().insert(downloadInfoList);
        Iterable $this$map$iv = (Iterable)CollectionsKt.getIndices((Collection)rowsList);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Pair((Object)downloadInfoList.get((int)it), (Object)this.requestDatabase.wasRowInserted(((Number)rowsList.get((int)it)).longValue())));
        }
        return (List)destination$iv$iv;
    }

    @Override
    public void delete(@NotNull DownloadInfo downloadInfo) {
        Intrinsics.checkNotNullParameter((Object)downloadInfo, (String)"downloadInfo");
        this.throwExceptionIfClosed();
        this.requestDatabase.requestDao().delete(downloadInfo);
    }

    @Override
    public void delete(@NotNull List<? extends DownloadInfo> downloadInfoList) {
        Intrinsics.checkNotNullParameter(downloadInfoList, (String)"downloadInfoList");
        this.throwExceptionIfClosed();
        this.requestDatabase.requestDao().delete(downloadInfoList);
    }

    @Override
    public void deleteAll() {
        this.throwExceptionIfClosed();
        this.requestDatabase.requestDao().deleteAll();
        this.getLogger().d("Cleared Database " + this.namespace);
    }

    @Override
    public void update(@NotNull DownloadInfo downloadInfo) {
        Intrinsics.checkNotNullParameter((Object)downloadInfo, (String)"downloadInfo");
        this.throwExceptionIfClosed();
        this.requestDatabase.requestDao().update(downloadInfo);
    }

    @Override
    public void update(@NotNull List<? extends DownloadInfo> downloadInfoList) {
        Intrinsics.checkNotNullParameter(downloadInfoList, (String)"downloadInfoList");
        this.throwExceptionIfClosed();
        this.requestDatabase.requestDao().update(downloadInfoList);
    }

    @Override
    public void updateFileBytesInfoAndStatusOnly(@NotNull DownloadInfo downloadInfo) {
        Intrinsics.checkNotNullParameter((Object)downloadInfo, (String)"downloadInfo");
        this.throwExceptionIfClosed();
        try {
            this.database.beginTransaction();
            Object[] objectArray = new Object[]{downloadInfo.getDownloaded(), downloadInfo.getTotal(), downloadInfo.getStatus().getValue(), downloadInfo.getId()};
            this.database.execSQL("UPDATE requests SET _written_bytes = ?, _total_bytes = ?, _status = ? WHERE _id = ?", objectArray);
            this.database.setTransactionSuccessful();
        }
        catch (SQLiteException e) {
            this.getLogger().e("DatabaseManager exception", (Throwable)e);
        }
        try {
            this.database.endTransaction();
        }
        catch (SQLiteException e) {
            this.getLogger().e("DatabaseManager exception", (Throwable)e);
        }
    }

    @Override
    @Nullable
    public DownloadInfo updateExtras(int id, @NotNull Extras extras) {
        Intrinsics.checkNotNullParameter((Object)extras, (String)"extras");
        this.throwExceptionIfClosed();
        this.database.beginTransaction();
        Object[] objectArray = new Object[]{extras.toJSONString(), id};
        this.database.execSQL("UPDATE requests SET _extras = '?' WHERE _id = ?", objectArray);
        this.database.setTransactionSuccessful();
        this.database.endTransaction();
        DownloadInfo download = this.requestDatabase.requestDao().get(id);
        FetchDatabaseManagerImpl.sanitize$default(this, download, false, 2, null);
        return download;
    }

    @Override
    @NotNull
    public List<DownloadInfo> get() {
        this.throwExceptionIfClosed();
        List<DownloadInfo> downloads = this.requestDatabase.requestDao().get();
        FetchDatabaseManagerImpl.sanitize$default(this, downloads, false, 2, null);
        return downloads;
    }

    @Override
    @Nullable
    public DownloadInfo get(int id) {
        this.throwExceptionIfClosed();
        DownloadInfo download = this.requestDatabase.requestDao().get(id);
        FetchDatabaseManagerImpl.sanitize$default(this, download, false, 2, null);
        return download;
    }

    @Override
    @NotNull
    public List<DownloadInfo> get(@NotNull List<Integer> ids) {
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        this.throwExceptionIfClosed();
        List<DownloadInfo> downloads = this.requestDatabase.requestDao().get(ids);
        FetchDatabaseManagerImpl.sanitize$default(this, downloads, false, 2, null);
        return downloads;
    }

    @Override
    @Nullable
    public DownloadInfo getByFile(@NotNull String file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.throwExceptionIfClosed();
        DownloadInfo download = this.requestDatabase.requestDao().getByFile(file);
        FetchDatabaseManagerImpl.sanitize$default(this, download, false, 2, null);
        return download;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<DownloadInfo> getByStatus(@NotNull Status status) {
        Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
        this.throwExceptionIfClosed();
        List downloads = this.requestDatabase.requestDao().getByStatus(status);
        if (FetchDatabaseManagerImpl.sanitize$default(this, downloads, false, 2, null)) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = downloads;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                DownloadInfo it = (DownloadInfo)element$iv$iv;
                boolean bl = false;
                if (!(it.getStatus() == status)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            downloads = (List)destination$iv$iv;
        }
        return downloads;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<DownloadInfo> getByStatus(@NotNull List<? extends Status> statuses) {
        Intrinsics.checkNotNullParameter(statuses, (String)"statuses");
        this.throwExceptionIfClosed();
        List downloads = this.requestDatabase.requestDao().getByStatus(statuses);
        if (FetchDatabaseManagerImpl.sanitize$default(this, downloads, false, 2, null)) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = downloads;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                DownloadInfo it = (DownloadInfo)element$iv$iv;
                boolean bl = false;
                if (!statuses.contains((Object)it.getStatus())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            downloads = (List)destination$iv$iv;
        }
        return downloads;
    }

    @Override
    @NotNull
    public List<DownloadInfo> getByGroup(int group) {
        this.throwExceptionIfClosed();
        List<DownloadInfo> downloads = this.requestDatabase.requestDao().getByGroup(group);
        FetchDatabaseManagerImpl.sanitize$default(this, downloads, false, 2, null);
        return downloads;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<DownloadInfo> getDownloadsInGroupWithStatus(int groupId, @NotNull List<? extends Status> statuses) {
        Intrinsics.checkNotNullParameter(statuses, (String)"statuses");
        this.throwExceptionIfClosed();
        List downloads = this.requestDatabase.requestDao().getByGroupWithStatus(groupId, statuses);
        if (FetchDatabaseManagerImpl.sanitize$default(this, downloads, false, 2, null)) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = downloads;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                boolean bl;
                block5: {
                    DownloadInfo download = (DownloadInfo)element$iv$iv;
                    boolean bl2 = false;
                    Iterable $this$any$iv = statuses;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            Status it = (Status)((Object)element$iv);
                            boolean bl3 = false;
                            if (!(it == download.getStatus())) continue;
                            bl = true;
                            break block5;
                        }
                        bl = false;
                    }
                }
                if (!bl) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            downloads = (List)destination$iv$iv;
        }
        return downloads;
    }

    @Override
    @NotNull
    public List<DownloadInfo> getDownloadsByRequestIdentifier(long identifier) {
        this.throwExceptionIfClosed();
        List<DownloadInfo> downloads = this.requestDatabase.requestDao().getDownloadsByRequestIdentifier(identifier);
        FetchDatabaseManagerImpl.sanitize$default(this, downloads, false, 2, null);
        return downloads;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<DownloadInfo> getPendingDownloadsSorted(@NotNull PrioritySort prioritySort) {
        List<Object> downloads;
        Intrinsics.checkNotNullParameter((Object)((Object)prioritySort), (String)"prioritySort");
        this.throwExceptionIfClosed();
        List<Object> list = downloads = prioritySort == PrioritySort.ASC ? this.requestDatabase.requestDao().getPendingDownloadsSorted(Status.QUEUED) : this.requestDatabase.requestDao().getPendingDownloadsSortedDesc(Status.QUEUED);
        if (FetchDatabaseManagerImpl.sanitize$default(this, downloads, false, 2, null)) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = downloads;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                DownloadInfo it = (DownloadInfo)element$iv$iv;
                boolean bl = false;
                if (!(it.getStatus() == Status.QUEUED)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            downloads = (List<Object>)destination$iv$iv;
        }
        return downloads;
    }

    @Override
    @NotNull
    public List<Integer> getAllGroupIds() {
        this.throwExceptionIfClosed();
        return this.requestDatabase.requestDao().getAllGroupIds();
    }

    @Override
    @NotNull
    public List<DownloadInfo> getDownloadsByTag(@NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        this.throwExceptionIfClosed();
        List<DownloadInfo> downloads = this.requestDatabase.requestDao().getDownloadsByTag(tag);
        FetchDatabaseManagerImpl.sanitize$default(this, downloads, false, 2, null);
        return downloads;
    }

    @Override
    public long getPendingCount(boolean includeAddedDownloads) {
        long l;
        try {
            String query = includeAddedDownloads ? this.pendingCountIncludeAddedQuery : this.pendingCountQuery;
            Cursor cursor = this.database.query(query);
            long count = cursor.getCount();
            cursor.close();
            l = count;
        }
        catch (Exception e) {
            l = -1L;
        }
        return l;
    }

    @Override
    public void sanitizeOnFirstEntry() {
        this.throwExceptionIfClosed();
        this.liveSettings.execute((Function1<? super LiveSettings, Unit>)((Function1)arg_0 -> FetchDatabaseManagerImpl.sanitizeOnFirstEntry$lambda$6(this, arg_0)));
    }

    private final boolean sanitize(List<? extends DownloadInfo> downloads, boolean firstEntry) {
        this.updatedDownloadsList.clear();
        DownloadInfo downloadInfo = null;
        Iterator<? extends DownloadInfo> iterator = downloads.iterator();
        block8: while (iterator.hasNext()) {
            DownloadInfo element;
            downloadInfo = element = iterator.next();
            switch (WhenMappings.$EnumSwitchMapping$0[downloadInfo.getStatus().ordinal()]) {
                case 1: {
                    this.onCompleted(downloadInfo);
                    continue block8;
                }
                case 2: {
                    this.onDownloading(downloadInfo, firstEntry);
                    continue block8;
                }
                case 3: 
                case 4: {
                    this.onPaused(downloadInfo);
                    continue block8;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    continue block8;
                }
            }
            throw new NoWhenBranchMatchedException();
        }
        int updatedCount = this.updatedDownloadsList.size();
        if (updatedCount > 0) {
            try {
                this.update((List<? extends DownloadInfo>)this.updatedDownloadsList);
            }
            catch (Exception e) {
                this.getLogger().e("Failed to update", (Throwable)e);
            }
        }
        this.updatedDownloadsList.clear();
        return updatedCount > 0;
    }

    static /* synthetic */ boolean sanitize$default(FetchDatabaseManagerImpl fetchDatabaseManagerImpl, List list, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return fetchDatabaseManagerImpl.sanitize(list, bl);
    }

    private final void onPaused(DownloadInfo downloadInfo) {
        block1: {
            if (downloadInfo.getDownloaded() <= 0L || !this.fileExistChecksEnabled || this.defaultStorageResolver.fileExists(downloadInfo.getFile())) break block1;
            downloadInfo.setDownloaded(0L);
            downloadInfo.setTotal(-1L);
            downloadInfo.setError(FetchDefaults.getDefaultNoError());
            this.updatedDownloadsList.add(downloadInfo);
            FetchDatabaseManager.Delegate<DownloadInfo> delegate = this.getDelegate();
            if (delegate != null) {
                delegate.deleteTempFilesForDownload(downloadInfo);
            }
        }
    }

    private final void onDownloading(DownloadInfo downloadInfo, boolean firstEntry) {
        if (firstEntry) {
            Status status = downloadInfo.getDownloaded() > 0L && downloadInfo.getTotal() > 0L && downloadInfo.getDownloaded() >= downloadInfo.getTotal() ? Status.COMPLETED : Status.QUEUED;
            downloadInfo.setStatus(status);
            downloadInfo.setError(FetchDefaults.getDefaultNoError());
            this.updatedDownloadsList.add(downloadInfo);
        }
    }

    private final void onCompleted(DownloadInfo downloadInfo) {
        if (downloadInfo.getTotal() < 1L && downloadInfo.getDownloaded() > 0L) {
            downloadInfo.setTotal(downloadInfo.getDownloaded());
            downloadInfo.setError(FetchDefaults.getDefaultNoError());
            this.updatedDownloadsList.add(downloadInfo);
        }
    }

    private final boolean sanitize(DownloadInfo downloadInfo, boolean initializing) {
        return downloadInfo == null ? false : this.sanitize(CollectionsKt.listOf((Object)downloadInfo), initializing);
    }

    static /* synthetic */ boolean sanitize$default(FetchDatabaseManagerImpl fetchDatabaseManagerImpl, DownloadInfo downloadInfo, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return fetchDatabaseManagerImpl.sanitize(downloadInfo, bl);
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            this.database.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.requestDatabase.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.getLogger().d("Database closed");
    }

    @Override
    @NotNull
    public DownloadInfo getNewDownloadInfoInstance() {
        return new DownloadInfo();
    }

    private final void throwExceptionIfClosed() {
        if (this.closed) {
            throw new FetchException(this.namespace + " database is closed");
        }
    }

    private static final Unit sanitizeOnFirstEntry$lambda$6(FetchDatabaseManagerImpl this$0, LiveSettings it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (!it.getDidSanitizeDatabaseOnFirstEntry()) {
            this$0.sanitize(this$0.get(), true);
            it.setDidSanitizeDatabaseOnFirstEntry(true);
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Status.values().length];
            try {
                nArray[Status.COMPLETED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.DOWNLOADING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.QUEUED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.PAUSED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.CANCELLED.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.FAILED.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.ADDED.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.NONE.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.DELETED.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.REMOVED.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

