/*
 * Decompiled with CFR 0.152.
 */
package com.tonyodev.fetch2;

import com.tonyodev.fetch2core.Downloader;
import com.tonyodev.fetch2core.Extras;
import com.tonyodev.fetch2core.FetchCoreUtils;
import com.tonyodev.fetch2core.FileResource;
import com.tonyodev.fetch2core.FileServerDownloader;
import com.tonyodev.fetch2core.InterruptMonitor;
import com.tonyodev.fetch2core.MutableExtras;
import com.tonyodev.fetch2core.server.FetchFileResourceTransporter;
import com.tonyodev.fetch2core.server.FileRequest;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0013\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\bH\u0016J\b\u0010\u0015\u001a\u00020\u0013H\u0016J\u001f\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016\u00a2\u0006\u0002\u0010\u001aJ\u001e\u0010\u001b\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00030\u001dH\u0016J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020!H\u0016J\"\u0010\"\u001a\u00020!2\u0018\u0010#\u001a\u0014\u0012\u0004\u0012\u00020!\u0012\n\u0012\b\u0012\u0004\u0012\u00020!0$0\u0007H\u0016J\u0018\u0010%\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\bH\u0016J\u0010\u0010&\u001a\u00020\u001f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010'\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010(\u001a\u00020\u00192\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0016\u0010)\u001a\b\u0012\u0004\u0012\u00020*0$2\u0006\u0010+\u001a\u00020\u000eH\u0016J\u0016\u0010,\u001a\b\u0012\u0004\u0012\u00020*0$2\u0006\u0010-\u001a\u00020!H\u0002J\u0010\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0002J\u0016\u00102\u001a\b\u0012\u0004\u0012\u00020\u00030\u001d2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/tonyodev/fetch2/FetchFileServerDownloader;", "Lcom/tonyodev/fetch2core/FileServerDownloader;", "fileDownloaderType", "Lcom/tonyodev/fetch2core/Downloader$FileDownloaderType;", "<init>", "(Lcom/tonyodev/fetch2core/Downloader$FileDownloaderType;)V", "connections", "", "Lcom/tonyodev/fetch2core/Downloader$Response;", "Lcom/tonyodev/fetch2core/server/FetchFileResourceTransporter;", "onPreClientExecute", "Lcom/tonyodev/fetch2core/FileServerDownloader$TransporterRequest;", "client", "request", "Lcom/tonyodev/fetch2core/Downloader$ServerRequest;", "execute", "interruptMonitor", "Lcom/tonyodev/fetch2core/InterruptMonitor;", "disconnect", "", "response", "close", "getFileSlicingCount", "", "contentLength", "", "(Lcom/tonyodev/fetch2core/Downloader$ServerRequest;J)Ljava/lang/Integer;", "getRequestFileDownloaderType", "supportedFileDownloaderTypes", "", "verifyContentHash", "", "hash", "", "getContentHash", "responseHeaders", "", "onServerResponse", "getHeadRequestMethodSupported", "getRequestBufferSize", "getRequestContentLength", "getFetchFileServerCatalog", "Lcom/tonyodev/fetch2core/FileResource;", "serverRequest", "parseFileResourceList", "data", "getExtrasFromCatalogItem", "Lcom/tonyodev/fetch2core/Extras;", "catalogItem", "Lorg/json/JSONObject;", "getRequestSupportedFileDownloaderTypes", "fetch2_release"})
@SourceDebugExtension(value={"SMAP\nFetchFileServerDownloader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FetchFileServerDownloader.kt\ncom/tonyodev/fetch2/FetchFileServerDownloader\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 Iterators.kt\nkotlin/collections/CollectionsKt__IteratorsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,248:1\n216#2,2:249\n32#3,2:251\n32#3,2:255\n1863#4,2:253\n*S KotlinDebug\n*F\n+ 1 FetchFileServerDownloader.kt\ncom/tonyodev/fetch2/FetchFileServerDownloader\n*L\n40#1:249,2\n82#1:251,2\n233#1:255,2\n133#1:253,2\n*E\n"})
public class FetchFileServerDownloader
implements FileServerDownloader {
    @NotNull
    private final Downloader.FileDownloaderType fileDownloaderType;
    @NotNull
    private final Map<Downloader.Response, FetchFileResourceTransporter> connections;

    @JvmOverloads
    public FetchFileServerDownloader(@NotNull Downloader.FileDownloaderType fileDownloaderType) {
        Intrinsics.checkNotNullParameter((Object)fileDownloaderType, (String)"fileDownloaderType");
        this.fileDownloaderType = fileDownloaderType;
        Map map = Collections.synchronizedMap(new HashMap());
        Intrinsics.checkNotNullExpressionValue(map, (String)"synchronizedMap(...)");
        this.connections = map;
    }

    public /* synthetic */ FetchFileServerDownloader(Downloader.FileDownloaderType fileDownloaderType, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            fileDownloaderType = Downloader.FileDownloaderType.SEQUENTIAL;
        }
        this(fileDownloaderType);
    }

    @NotNull
    public FileServerDownloader.TransporterRequest onPreClientExecute(@NotNull FetchFileResourceTransporter client, @NotNull Downloader.ServerRequest request) {
        Object object;
        Object object2;
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Map headers = request.getHeaders();
        String string2 = (String)headers.get("Range");
        if (string2 == null) {
            string2 = "bytes=0-";
        }
        Pair range = FetchCoreUtils.getRangeForFetchFileServerRequest((String)string2);
        String string3 = (String)headers.get("Authorization");
        if (string3 == null) {
            string3 = "";
        }
        String authorization = string3;
        int port = FetchCoreUtils.getFetchFileServerPort((String)request.getUrl());
        String address = FetchCoreUtils.getFetchFileServerHostAddress((String)request.getUrl());
        MutableExtras extras = request.getExtras().toMutableExtras();
        Map $this$forEach$iv = request.getHeaders();
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it = element$iv = iterator.next();
            boolean bl = false;
            extras.putString((String)it.getKey(), (String)it.getValue());
        }
        FileServerDownloader.TransporterRequest transporterRequest = new FileServerDownloader.TransporterRequest();
        transporterRequest.setInetSocketAddress(new InetSocketAddress(address, port));
        String string4 = FetchCoreUtils.getFileResourceIdFromUrl((String)request.getUrl());
        long l = ((Number)range.getFirst()).longValue();
        long l2 = ((Number)range.getSecond()).longValue();
        String string5 = (String)headers.get("Client");
        if (string5 == null) {
            String string6 = UUID.randomUUID().toString();
            string5 = string6;
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toString(...)");
        }
        transporterRequest.setFileRequest(new FileRequest(1, string4, l, l2, authorization, string5, (Extras)extras, (object2 = (String)headers.get("Page")) != null && (object2 = StringsKt.toIntOrNull((String)object2)) != null ? (Integer)object2 : 0, (object = (String)headers.get("Size")) != null && (object = StringsKt.toIntOrNull((String)object)) != null ? (Integer)object : 0, false));
        return transporterRequest;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public Downloader.Response execute(@NotNull Downloader.ServerRequest request, @NotNull InterruptMonitor interruptMonitor) {
        block6: {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Intrinsics.checkNotNullParameter((Object)interruptMonitor, (String)"interruptMonitor");
            transporter = new FetchFileResourceTransporter(null, 1, null);
            transporterRequest = this.onPreClientExecute(transporter, request);
            transporter.connect((SocketAddress)transporterRequest.getInetSocketAddress());
            transporter.sendFileRequest(transporterRequest.getFileRequest());
            if (interruptMonitor.isInterrupted()) break block6;
            serverResponse = transporter.receiveFileResponse();
            code = serverResponse.getStatus();
            isSuccessful = serverResponse.getConnection() == 1 && serverResponse.getType() == 1 && serverResponse.getStatus() == 206;
            contentLength = serverResponse.getContentLength();
            inputStream = transporter.getInputStream();
            errorResponse = isSuccessful == false ? FetchCoreUtils.copyStreamToString((InputStream)inputStream, (boolean)false) : null;
            responseHeaders = new LinkedHashMap<K, V>();
            try {
                json = new JSONObject(serverResponse.getToJsonString());
                v0 = json.keys();
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"keys(...)");
                $this$forEach$iv = v0;
                $i$f$forEach = false;
                var16_18 = $this$forEach$iv;
                while (var16_18.hasNext()) {
                    element$iv = var16_18.next();
                    it = (String)element$iv;
                    $i$a$-forEach-FetchFileServerDownloader$execute$1 = false;
                    responseHeaders.put(it, CollectionsKt.listOf((Object)json.get(it).toString()));
                }
            }
            catch (Exception json) {
                // empty catch block
            }
            if (!responseHeaders.containsKey("Content-MD5")) {
                responseHeaders.put("Content-MD5", CollectionsKt.listOf((Object)serverResponse.getMd5()));
            }
            hash = this.getContentHash(responseHeaders);
            if (code == 206) ** GOTO lbl-1000
            v1 = (List)responseHeaders.get("Accept-Ranges");
            if (Intrinsics.areEqual((Object)(v1 != null ? (String)CollectionsKt.firstOrNull((List)v1) : null), (Object)"bytes")) lbl-1000:
            // 2 sources

            {
                v2 = true;
            } else {
                v2 = false;
            }
            acceptsRanges = v2;
            this.onServerResponse(request, new Downloader.Response(code, isSuccessful, contentLength, null, request, hash, responseHeaders, acceptsRanges, errorResponse));
            response = new Downloader.Response(code, isSuccessful, contentLength, inputStream, request, hash, responseHeaders, acceptsRanges, errorResponse);
            this.connections.put(response, transporter);
            return response;
        }
        return null;
    }

    public void disconnect(@NotNull Downloader.Response response2) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
            if (!this.connections.containsKey(response2)) break block1;
            FetchFileResourceTransporter transporter = this.connections.get(response2);
            this.connections.remove(response2);
            FetchFileResourceTransporter fetchFileResourceTransporter = transporter;
            if (fetchFileResourceTransporter != null) {
                fetchFileResourceTransporter.close();
            }
        }
    }

    public void close() {
        try {
            Iterable $this$forEach$iv = this.connections.entrySet();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Map.Entry it = (Map.Entry)element$iv;
                boolean bl = false;
                ((FetchFileResourceTransporter)it.getValue()).close();
            }
            this.connections.clear();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Nullable
    public Integer getFileSlicingCount(@NotNull Downloader.ServerRequest request, long contentLength) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return null;
    }

    @NotNull
    public Downloader.FileDownloaderType getRequestFileDownloaderType(@NotNull Downloader.ServerRequest request, @NotNull Set<? extends Downloader.FileDownloaderType> supportedFileDownloaderTypes) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(supportedFileDownloaderTypes, (String)"supportedFileDownloaderTypes");
        return this.fileDownloaderType;
    }

    public boolean verifyContentHash(@NotNull Downloader.ServerRequest request, @NotNull String hash) {
        String fileMd5;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
        if (((CharSequence)hash).length() == 0) {
            return true;
        }
        String string2 = fileMd5 = FetchCoreUtils.getFileMd5String((String)request.getFile());
        return string2 != null ? string2.contentEquals(hash) : true;
    }

    @NotNull
    public String getContentHash(@NotNull Map<String, List<String>> responseHeaders) {
        Intrinsics.checkNotNullParameter(responseHeaders, (String)"responseHeaders");
        List<String> list = responseHeaders.get("Content-MD5");
        if (list == null || (list = (String)CollectionsKt.firstOrNull(list)) == null) {
            list = "";
        }
        return list;
    }

    public void onServerResponse(@NotNull Downloader.ServerRequest request, @NotNull Downloader.Response response2) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
    }

    public boolean getHeadRequestMethodSupported(@NotNull Downloader.ServerRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return false;
    }

    public int getRequestBufferSize(@NotNull Downloader.ServerRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return 8192;
    }

    public long getRequestContentLength(@NotNull Downloader.ServerRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return FetchCoreUtils.getRequestContentLength((Downloader.ServerRequest)request, (Downloader)((Downloader)this));
    }

    @NotNull
    public List<FileResource> getFetchFileServerCatalog(@NotNull Downloader.ServerRequest serverRequest) {
        Downloader.Response response2;
        Intrinsics.checkNotNullParameter((Object)serverRequest, (String)"serverRequest");
        Downloader.Response response3 = response2 = this.execute(serverRequest, new InterruptMonitor(){

            public boolean isInterrupted() {
                return false;
            }
        });
        if ((response3 != null ? response3.getByteStream() : null) != null) {
            try {
                int type;
                Object object = (List)response2.getResponseHeaders().get("Type");
                int n = object != null && (object = (String)CollectionsKt.firstOrNull((List)object)) != null ? Integer.parseInt((String)object) : (type = -1);
                if (type != 1) {
                    this.disconnect(response2);
                    throw new Exception("fetch_file_server_invalid_response_type");
                }
                int bufferSize = 1024;
                char[] buffer = new char[bufferSize];
                StringBuilder stringBuilder = new StringBuilder();
                InputStreamReader inputReader = new InputStreamReader(response2.getByteStream(), Charsets.UTF_8);
                int read = inputReader.read(buffer, 0, bufferSize);
                while (read != -1) {
                    StringBuilder stringBuilder2 = stringBuilder;
                    int n2 = 0;
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append(buffer, n2, read - n2), (String)"append(...)");
                    read = inputReader.read(buffer, 0, bufferSize);
                }
                inputReader.close();
                String string2 = stringBuilder.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                String data = string2;
                if (((CharSequence)data).length() > 0) {
                    List<FileResource> fileResourceList = this.parseFileResourceList(data);
                    this.disconnect(response2);
                    return fileResourceList;
                }
                throw new Exception("empty_response_body");
            }
            catch (Exception e) {
                this.disconnect(response2);
                throw e;
            }
        }
        throw new Exception("empty_response_body");
    }

    private final List<FileResource> parseFileResourceList(String data) {
        JSONObject json = new JSONObject(data);
        JSONArray catalogArray = new JSONArray(json.getString("catalog"));
        int size = catalogArray.length();
        List fileResourceList = new ArrayList();
        for (int index = 0; index < size; ++index) {
            FileResource fileResource = new FileResource();
            JSONObject catalogItem = catalogArray.getJSONObject(index);
            fileResource.setId(catalogItem.getLong("id"));
            fileResource.setName(catalogItem.getString("name"));
            fileResource.setLength(catalogItem.getLong("length"));
            Intrinsics.checkNotNull((Object)catalogItem);
            fileResource.setExtras(this.getExtrasFromCatalogItem(catalogItem));
            fileResource.setMd5(catalogItem.getString("md5"));
            fileResourceList.add(fileResource);
        }
        return fileResourceList;
    }

    private final Extras getExtrasFromCatalogItem(JSONObject catalogItem) {
        Extras extras;
        try {
            Map map = new LinkedHashMap();
            JSONObject customJson = new JSONObject(catalogItem.getString("extras"));
            Iterator iterator = customJson.keys();
            Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"keys(...)");
            Iterator $this$forEach$iv = iterator;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv;
            while (iterator2.hasNext()) {
                Object element$iv = iterator2.next();
                String it = (String)element$iv;
                boolean bl = false;
                map.put(it, customJson.getString(it));
            }
            extras = new Extras(map);
        }
        catch (Exception e) {
            extras = Extras.CREATOR.getEmptyExtras();
        }
        return extras;
    }

    @NotNull
    public Set<Downloader.FileDownloaderType> getRequestSupportedFileDownloaderTypes(@NotNull Downloader.ServerRequest request) {
        Set set;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        try {
            set = FetchCoreUtils.getRequestSupportedFileDownloaderTypes((Downloader.ServerRequest)request, (Downloader)((Downloader)this));
        }
        catch (Exception e) {
            Object[] objectArray = new Downloader.FileDownloaderType[]{this.fileDownloaderType};
            set = SetsKt.mutableSetOf((Object[])objectArray);
        }
        return set;
    }

    @JvmOverloads
    public FetchFileServerDownloader() {
        this(null, 1, null);
    }
}

