/*
 * Decompiled with CFR 0.152.
 */
package com.tonyodev.fetch2.util;

import android.net.Uri;
import android.os.Looper;
import com.tonyodev.fetch2.Download;
import com.tonyodev.fetch2.Request;
import com.tonyodev.fetch2.Status;
import com.tonyodev.fetch2.exception.FetchException;
import com.tonyodev.fetch2.fetch.FetchHandler;
import com.tonyodev.fetch2core.Downloader;
import com.tonyodev.fetch2core.Extras;
import com.tonyodev.fetch2core.FetchCoreUtils;
import com.tonyodev.fetch2core.FileSliceInfo;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\n\u001a6\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\f2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u001a\u000e\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u000e\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u0016\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\n\u001a\u0016\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\n\u001a\u001e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\n\u001a\u001e\u0010\u001b\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\n\u001a\u0016\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\n\u001a\u001e\u0010\u001e\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\n\u001a\u0016\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020\f\u001a\u0016\u0010#\u001a\u00020\u00192\u0006\u0010$\u001a\u00020\f2\u0006\u0010%\u001a\u00020&\u00a8\u0006'"}, d2={"canPauseDownload", "", "download", "Lcom/tonyodev/fetch2/Download;", "canResumeDownload", "canRetryDownload", "canCancelDownload", "getRequestForDownload", "Lcom/tonyodev/fetch2core/Downloader$ServerRequest;", "requestMethod", "", "rangeStart", "", "rangeEnd", "segment", "", "getServerRequestFromRequest", "request", "Lcom/tonyodev/fetch2/Request;", "getCatalogServerRequestFromRequest", "getPreviousSliceCount", "id", "fileTempDir", "getMetaFilePath", "saveCurrentSliceCount", "", "sliceCount", "getDownloadedInfoFilePath", "position", "deleteAllInFolderForId", "getSavedDownloadedInfo", "getFileSliceInfo", "Lcom/tonyodev/fetch2core/FileSliceInfo;", "fileSliceSize", "totalBytes", "awaitFinishOrTimeout", "allowTimeInMilliseconds", "fetchHandler", "Lcom/tonyodev/fetch2/fetch/FetchHandler;", "fetch2_release"})
@JvmName(name="FetchUtils")
@SourceDebugExtension(value={"SMAP\nFetchUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FetchUtils.kt\ncom/tonyodev/fetch2/util/FetchUtils\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,223:1\n3829#2:224\n4344#2,2:225\n1863#3,2:227\n*S KotlinDebug\n*F\n+ 1 FetchUtils.kt\ncom/tonyodev/fetch2/util/FetchUtils\n*L\n148#1:224\n148#1:225,2\n151#1:227,2\n*E\n"})
public final class FetchUtils {
    public static final boolean canPauseDownload(@NotNull Download download) {
        Intrinsics.checkNotNullParameter((Object)download, (String)"download");
        return switch (WhenMappings.$EnumSwitchMapping$0[download.getStatus().ordinal()]) {
            case 1, 2 -> true;
            default -> false;
        };
    }

    public static final boolean canResumeDownload(@NotNull Download download) {
        Intrinsics.checkNotNullParameter((Object)download, (String)"download");
        return switch (WhenMappings.$EnumSwitchMapping$0[download.getStatus().ordinal()]) {
            case 2, 3, 4 -> true;
            default -> false;
        };
    }

    public static final boolean canRetryDownload(@NotNull Download download) {
        Intrinsics.checkNotNullParameter((Object)download, (String)"download");
        return switch (WhenMappings.$EnumSwitchMapping$0[download.getStatus().ordinal()]) {
            case 3, 5, 6 -> true;
            default -> false;
        };
    }

    public static final boolean canCancelDownload(@NotNull Download download) {
        Intrinsics.checkNotNullParameter((Object)download, (String)"download");
        return switch (WhenMappings.$EnumSwitchMapping$0[download.getStatus().ordinal()]) {
            case 5, 7, 8 -> false;
            default -> true;
        };
    }

    @NotNull
    public static final Downloader.ServerRequest getRequestForDownload(@NotNull Download download, @NotNull String requestMethod) {
        Intrinsics.checkNotNullParameter((Object)download, (String)"download");
        Intrinsics.checkNotNullParameter((Object)requestMethod, (String)"requestMethod");
        return FetchUtils.getRequestForDownload$default(download, -1L, -1L, requestMethod, 0, 16, null);
    }

    public static /* synthetic */ Downloader.ServerRequest getRequestForDownload$default(Download download, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "GET";
        }
        return FetchUtils.getRequestForDownload(download, string2);
    }

    @NotNull
    public static final Downloader.ServerRequest getRequestForDownload(@NotNull Download download, long rangeStart, long rangeEnd, @NotNull String requestMethod, int segment) {
        Intrinsics.checkNotNullParameter((Object)download, (String)"download");
        Intrinsics.checkNotNullParameter((Object)requestMethod, (String)"requestMethod");
        long start = rangeStart == -1L ? 0L : rangeStart;
        String end = rangeEnd == -1L ? "" : String.valueOf(rangeEnd);
        Map headers = MapsKt.toMutableMap(download.getHeaders());
        headers.put("Range", "bytes=" + start + "-" + end);
        return new Downloader.ServerRequest(download.getId(), download.getUrl(), headers, download.getFile(), FetchCoreUtils.getFileUri((String)download.getFile()), download.getTag(), download.getIdentifier(), requestMethod, download.getExtras(), false, "", segment);
    }

    public static /* synthetic */ Downloader.ServerRequest getRequestForDownload$default(Download download, long l, long l2, String string2, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            l = -1L;
        }
        if ((n2 & 4) != 0) {
            l2 = -1L;
        }
        if ((n2 & 8) != 0) {
            string2 = "GET";
        }
        if ((n2 & 0x10) != 0) {
            n = 1;
        }
        return FetchUtils.getRequestForDownload(download, l, l2, string2, n);
    }

    @NotNull
    public static final Downloader.ServerRequest getServerRequestFromRequest(@NotNull Request request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        int n = request.getId();
        String string2 = request.getUrl();
        Map<String, String> map = request.getHeaders();
        String string3 = request.getTag();
        long l = request.getIdentifier();
        String string4 = request.getFile();
        Uri uri = FetchCoreUtils.getFileUri((String)request.getFile());
        Extras extras = request.getExtras();
        return new Downloader.ServerRequest(n, string2, map, string4, uri, string3, l, "GET", extras, false, "", 1);
    }

    @NotNull
    public static final Downloader.ServerRequest getCatalogServerRequestFromRequest(@NotNull Request request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Map headers = MapsKt.toMutableMap(request.getHeaders());
        headers.put("Range", "bytes=0-");
        headers.put("Page", "-1");
        headers.put("Size", "-1");
        headers.put("Type", "1");
        int n = request.getId();
        String string2 = request.getUrl();
        String string3 = request.getTag();
        long l = request.getIdentifier();
        String string4 = request.getFile();
        Uri uri = FetchCoreUtils.getFileUri((String)request.getFile());
        Extras extras = request.getExtras();
        return new Downloader.ServerRequest(n, string2, headers, string4, uri, string3, l, "GET", extras, false, "", 1);
    }

    public static final int getPreviousSliceCount(int id, @NotNull String fileTempDir) {
        Intrinsics.checkNotNullParameter((Object)fileTempDir, (String)"fileTempDir");
        int sliceCount = -1;
        try {
            Long l;
            Long l2 = l = FetchCoreUtils.getLongDataFromFile((String)FetchUtils.getMetaFilePath(id, fileTempDir));
            sliceCount = l2 != null ? (int)l2.longValue() : -1;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sliceCount;
    }

    @NotNull
    public static final String getMetaFilePath(int id, @NotNull String fileTempDir) {
        Intrinsics.checkNotNullParameter((Object)fileTempDir, (String)"fileTempDir");
        return fileTempDir + "/" + id + ".meta.data";
    }

    public static final void saveCurrentSliceCount(int id, int sliceCount, @NotNull String fileTempDir) {
        Intrinsics.checkNotNullParameter((Object)fileTempDir, (String)"fileTempDir");
        try {
            FetchCoreUtils.writeLongToFile((String)FetchUtils.getMetaFilePath(id, fileTempDir), (long)sliceCount);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @NotNull
    public static final String getDownloadedInfoFilePath(int id, int position, @NotNull String fileTempDir) {
        Intrinsics.checkNotNullParameter((Object)fileTempDir, (String)"fileTempDir");
        return fileTempDir + "/" + id + "." + position + ".data";
    }

    /*
     * WARNING - void declaration
     */
    public static final void deleteAllInFolderForId(int id, @NotNull String fileTempDir) {
        Intrinsics.checkNotNullParameter((Object)fileTempDir, (String)"fileTempDir");
        try {
            File[] files;
            File dir = new File(fileTempDir);
            if (dir.exists() && (files = dir.listFiles()) != null) {
                void $this$filterTo$iv$iv;
                File[] $this$filter$iv = files;
                boolean $i$f$filter = false;
                File[] fileArray = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                int n = ((void)$this$filterTo$iv$iv).length;
                for (int i = 0; i < n; ++i) {
                    void element$iv$iv;
                    void file = element$iv$iv = $this$filterTo$iv$iv[i];
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)file);
                    if (!StringsKt.startsWith$default((String)FilesKt.getNameWithoutExtension((File)file), (String)(id + "."), (boolean)false, (int)2, null)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List filteredFilesList = (List)destination$iv$iv;
                Iterable $this$forEach$iv = filteredFilesList;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    File file = (File)element$iv;
                    boolean bl = false;
                    if (!file.exists()) continue;
                    file.delete();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static final long getSavedDownloadedInfo(int id, int position, @NotNull String fileTempDir) {
        Intrinsics.checkNotNullParameter((Object)fileTempDir, (String)"fileTempDir");
        long downloaded = 0L;
        try {
            Long l;
            Long l2 = l = FetchCoreUtils.getLongDataFromFile((String)FetchUtils.getDownloadedInfoFilePath(id, position, fileTempDir));
            downloaded = l2 != null ? l2 : 0L;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return downloaded;
    }

    @NotNull
    public static final FileSliceInfo getFileSliceInfo(int fileSliceSize, long totalBytes) {
        FileSliceInfo fileSliceInfo;
        if (fileSliceSize == -1) {
            float fileSizeInMb = (float)totalBytes / 1024.0f * 1024.0f;
            float fileSizeInGb = (float)totalBytes / 1024.0f * 1024.0f * 1024.0f;
            if (fileSizeInGb >= 1.0f) {
                int slices = 6;
                long bytesPerSlice = (long)Math.ceil((float)totalBytes / (float)slices);
                fileSliceInfo = new FileSliceInfo(slices, bytesPerSlice);
            } else if (fileSizeInMb >= 1.0f) {
                int slices = 4;
                long bytesPerSlice = (long)Math.ceil((float)totalBytes / (float)slices);
                fileSliceInfo = new FileSliceInfo(slices, bytesPerSlice);
            } else {
                fileSliceInfo = new FileSliceInfo(2, totalBytes);
            }
        } else {
            long bytesPerSlice = (long)Math.ceil((float)totalBytes / (float)fileSliceSize);
            return new FileSliceInfo(fileSliceSize, bytesPerSlice);
        }
        return fileSliceInfo;
    }

    public static final void awaitFinishOrTimeout(long allowTimeInMilliseconds, @NotNull FetchHandler fetchHandler) {
        Intrinsics.checkNotNullParameter((Object)fetchHandler, (String)"fetchHandler");
        if (Intrinsics.areEqual((Object)Thread.currentThread(), (Object)Looper.getMainLooper().getThread())) {
            throw new FetchException("await_call_on_ui_thread");
        }
        boolean hasAllowedTimeExpired = false;
        boolean indefinite = allowTimeInMilliseconds == 0L;
        long sleepTime = indefinite ? 5000L : (allowTimeInMilliseconds < 1000L ? allowTimeInMilliseconds : 1000L);
        long timeStarted = System.currentTimeMillis();
        long pendingCount = fetchHandler.getPendingCount();
        while (indefinite || pendingCount > 0L && !hasAllowedTimeExpired) {
            try {
                Thread.sleep(sleepTime);
            }
            catch (Exception exception) {
                // empty catch block
            }
            hasAllowedTimeExpired = allowTimeInMilliseconds == -1L ? false : FetchCoreUtils.hasAllowedTimeExpired((long)timeStarted, (long)System.currentTimeMillis(), (long)allowTimeInMilliseconds);
            pendingCount = fetchHandler.getPendingCount();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Status.values().length];
            try {
                nArray[Status.DOWNLOADING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.QUEUED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.ADDED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.PAUSED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.FAILED.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.CANCELLED.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.COMPLETED.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.NONE.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

