/*
 * Decompiled with CFR 0.152.
 */
package com.tonyodev.fetch2;

import com.tonyodev.fetch2core.Downloader;
import com.tonyodev.fetch2core.FetchCoreUtils;
import com.tonyodev.fetch2core.InterruptMonitor;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\t\b\u0016\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u00013B\u000f\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u001d\b\u0007\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0012\u001a\u00020\u0003H\u0016J\u0010\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u000fH\u0016J\u0012\u0010\u0015\u001a\u00020\u00032\b\u0010\u0016\u001a\u0004\u0018\u00010\u0002H\u0002J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\"\u0010\u001c\u001a\u00020\u001d2\u0018\u0010\u001e\u001a\u0014\u0012\u0004\u0012\u00020\u001d\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\u001f0\u000eH\u0016J\u001f\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020#H\u0016\u00a2\u0006\u0002\u0010$J\u0010\u0010%\u001a\u00020&2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010'\u001a\u00020!2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010(\u001a\u00020#2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u001e\u0010)\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00050+H\u0016J\u0016\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00050+2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010-\u001a\u00020&2\u0006\u0010.\u001a\u00020!H\u0004J\u0018\u0010/\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u00100\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u000fH\u0016J\u0018\u00101\u001a\u00020&2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u00102\u001a\u00020\u001dH\u0016R\u0014\u0010\n\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR \u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00020\u000eX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/tonyodev/fetch2/HttpUrlConnectionDownloader;", "Lcom/tonyodev/fetch2core/Downloader;", "Ljava/net/HttpURLConnection;", "", "fileDownloaderType", "Lcom/tonyodev/fetch2core/Downloader$FileDownloaderType;", "(Lcom/tonyodev/fetch2core/Downloader$FileDownloaderType;)V", "httpUrlConnectionPreferences", "Lcom/tonyodev/fetch2/HttpUrlConnectionDownloader$HttpUrlConnectionPreferences;", "(Lcom/tonyodev/fetch2/HttpUrlConnectionDownloader$HttpUrlConnectionPreferences;Lcom/tonyodev/fetch2core/Downloader$FileDownloaderType;)V", "connectionPrefs", "getConnectionPrefs", "()Lcom/tonyodev/fetch2/HttpUrlConnectionDownloader$HttpUrlConnectionPreferences;", "connections", "", "Lcom/tonyodev/fetch2core/Downloader$Response;", "getConnections", "()Ljava/util/Map;", "close", "disconnect", "response", "disconnectClient", "client", "execute", "request", "Lcom/tonyodev/fetch2core/Downloader$ServerRequest;", "interruptMonitor", "Lcom/tonyodev/fetch2core/InterruptMonitor;", "getContentHash", "", "responseHeaders", "", "getFileSlicingCount", "", "contentLength", "", "(Lcom/tonyodev/fetch2core/Downloader$ServerRequest;J)Ljava/lang/Integer;", "getHeadRequestMethodSupported", "", "getRequestBufferSize", "getRequestContentLength", "getRequestFileDownloaderType", "supportedFileDownloaderTypes", "", "getRequestSupportedFileDownloaderTypes", "isResponseOk", "responseCode", "onPreClientExecute", "onServerResponse", "verifyContentHash", "hash", "HttpUrlConnectionPreferences", "fetch2_release"})
public class HttpUrlConnectionDownloader
implements Downloader<HttpURLConnection, Unit> {
    @NotNull
    private final HttpUrlConnectionPreferences connectionPrefs;
    @NotNull
    private final Map<Downloader.Response, HttpURLConnection> connections;
    private final Downloader.FileDownloaderType fileDownloaderType;

    @NotNull
    protected final HttpUrlConnectionPreferences getConnectionPrefs() {
        return this.connectionPrefs;
    }

    @NotNull
    protected final Map<Downloader.Response, HttpURLConnection> getConnections() {
        return this.connections;
    }

    public void onPreClientExecute(@NotNull HttpURLConnection client, @NotNull Downloader.ServerRequest request) {
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        client.setRequestMethod(request.getRequestMethod());
        client.setReadTimeout(this.connectionPrefs.getReadTimeout());
        client.setConnectTimeout(this.connectionPrefs.getConnectTimeout());
        client.setUseCaches(this.connectionPrefs.getUsesCache());
        client.setDefaultUseCaches(this.connectionPrefs.getUsesDefaultCache());
        client.setInstanceFollowRedirects(this.connectionPrefs.getFollowsRedirect());
        client.setDoInput(true);
        Iterable $receiver$iv = request.getHeaders().entrySet();
        for (Object element$iv : $receiver$iv) {
            Map.Entry it = (Map.Entry)element$iv;
            client.addRequestProperty((String)it.getKey(), (String)it.getValue());
        }
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public Downloader.Response execute(@NotNull Downloader.ServerRequest request, @NotNull InterruptMonitor interruptMonitor) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)interruptMonitor, (String)"interruptMonitor");
        httpUrl = new URL(request.getUrl());
        v0 = httpUrl.openConnection();
        if (v0 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.net.HttpURLConnection");
        }
        client = (HttpURLConnection)v0;
        this.onPreClientExecute(client, request);
        client.connect();
        code = client.getResponseCode();
        success = false;
        contentLength = -1L;
        byteStream = null;
        responseHeaders = client.getHeaderFields();
        hash = "";
        if (this.isResponseOk(code)) {
            success = true;
            v1 = client.getHeaderField("Content-Length");
            if (v1 != null) {
                var12_11 = v1;
                v2 = Long.parseLong(var12_11);
            } else {
                v2 = -1L;
            }
            contentLength = v2;
            byteStream = client.getInputStream();
            v3 = responseHeaders;
            Intrinsics.checkExpressionValueIsNotNull(v3, (String)"responseHeaders");
            hash = this.getContentHash(v3);
        }
        if (code == 206) ** GOTO lbl-1000
        v4 = responseHeaders.get("Accept-Ranges");
        if (Intrinsics.areEqual((Object)(v4 != null ? (String)CollectionsKt.firstOrNull(v4) : null), (Object)"bytes")) lbl-1000:
        // 2 sources

        {
            v5 = true;
        } else {
            v5 = false;
        }
        acceptsRanges = v5;
        v6 = responseHeaders;
        Intrinsics.checkExpressionValueIsNotNull(v6, (String)"responseHeaders");
        this.onServerResponse(request, new Downloader.Response(code, success, contentLength, null, request, hash, v6, acceptsRanges));
        response = new Downloader.Response(code, success, contentLength, byteStream, request, hash, responseHeaders, acceptsRanges);
        var14_14 = this.connections;
        var15_15 = client;
        var14_14.put(response, var15_15);
        return response;
    }

    protected final boolean isResponseOk(int responseCode) {
        int n = responseCode;
        return 200 <= n && 299 >= n;
    }

    public void disconnect(@NotNull Downloader.Response response2) {
        Map<Downloader.Response, HttpURLConnection> map;
        Intrinsics.checkParameterIsNotNull((Object)response2, (String)"response");
        Map<Downloader.Response, HttpURLConnection> map2 = map = this.connections;
        if (map2.containsKey(response2)) {
            HttpURLConnection client = this.connections.get(response2);
            this.connections.remove(response2);
            this.disconnectClient(client);
        }
    }

    @NotNull
    public String getContentHash(@NotNull Map<String, List<String>> responseHeaders) {
        Intrinsics.checkParameterIsNotNull(responseHeaders, (String)"responseHeaders");
        List<String> list = responseHeaders.get("Content-MD5");
        if (list == null || (list = (String)CollectionsKt.firstOrNull(list)) == null) {
            list = "";
        }
        return list;
    }

    public void close() {
        Iterable $receiver$iv = this.connections.entrySet();
        for (Object element$iv : $receiver$iv) {
            Map.Entry it = (Map.Entry)element$iv;
            this.disconnectClient((HttpURLConnection)it.getValue());
        }
        this.connections.clear();
    }

    private final void disconnectClient(HttpURLConnection client) {
        try {
            HttpURLConnection httpURLConnection = client;
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Nullable
    public Integer getFileSlicingCount(@NotNull Downloader.ServerRequest request, long contentLength) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        return null;
    }

    @NotNull
    public Downloader.FileDownloaderType getRequestFileDownloaderType(@NotNull Downloader.ServerRequest request, @NotNull Set<? extends Downloader.FileDownloaderType> supportedFileDownloaderTypes) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull(supportedFileDownloaderTypes, (String)"supportedFileDownloaderTypes");
        return this.fileDownloaderType;
    }

    public boolean verifyContentHash(@NotNull Downloader.ServerRequest request, @NotNull String hash) {
        boolean bl;
        String fileHash;
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)hash, (String)"hash");
        CharSequence charSequence = hash;
        if (charSequence.length() == 0) {
            return true;
        }
        String string2 = fileHash = FetchCoreUtils.getFileMd5String((String)request.getFile());
        if (string2 != null) {
            String string3;
            String string4 = string3 = string2;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            bl = string4.contentEquals(hash);
        } else {
            bl = true;
        }
        return bl;
    }

    public void onServerResponse(@NotNull Downloader.ServerRequest request, @NotNull Downloader.Response response2) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)response2, (String)"response");
    }

    public boolean getHeadRequestMethodSupported(@NotNull Downloader.ServerRequest request) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        return false;
    }

    public int getRequestBufferSize(@NotNull Downloader.ServerRequest request) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        return 8192;
    }

    public long getRequestContentLength(@NotNull Downloader.ServerRequest request) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        return FetchCoreUtils.getRequestContentLength((Downloader.ServerRequest)request, (Downloader)this);
    }

    @NotNull
    public Set<Downloader.FileDownloaderType> getRequestSupportedFileDownloaderTypes(@NotNull Downloader.ServerRequest request) {
        Set set;
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        try {
            set = FetchCoreUtils.getRequestSupportedFileDownloaderTypes((Downloader.ServerRequest)request, (Downloader)this);
        }
        catch (Exception e) {
            set = SetsKt.mutableSetOf((Object[])new Downloader.FileDownloaderType[]{this.fileDownloaderType});
        }
        return set;
    }

    @JvmOverloads
    public HttpUrlConnectionDownloader(@Nullable HttpUrlConnectionPreferences httpUrlConnectionPreferences, @NotNull Downloader.FileDownloaderType fileDownloaderType) {
        Intrinsics.checkParameterIsNotNull((Object)fileDownloaderType, (String)"fileDownloaderType");
        this.fileDownloaderType = fileDownloaderType;
        HttpUrlConnectionPreferences httpUrlConnectionPreferences2 = httpUrlConnectionPreferences;
        if (httpUrlConnectionPreferences2 == null) {
            httpUrlConnectionPreferences2 = new HttpUrlConnectionPreferences();
        }
        this.connectionPrefs = httpUrlConnectionPreferences2;
        Map map = Collections.synchronizedMap(new HashMap());
        Intrinsics.checkExpressionValueIsNotNull(map, (String)"Collections.synchronized\u2026se, HttpURLConnection>())");
        this.connections = map;
    }

    @JvmOverloads
    public /* synthetic */ HttpUrlConnectionDownloader(HttpUrlConnectionPreferences httpUrlConnectionPreferences, Downloader.FileDownloaderType fileDownloaderType, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            httpUrlConnectionPreferences = null;
        }
        if ((n & 2) != 0) {
            fileDownloaderType = Downloader.FileDownloaderType.SEQUENTIAL;
        }
        this(httpUrlConnectionPreferences, fileDownloaderType);
    }

    @JvmOverloads
    public HttpUrlConnectionDownloader(@Nullable HttpUrlConnectionPreferences httpUrlConnectionPreferences) {
        this(httpUrlConnectionPreferences, null, 2, null);
    }

    @JvmOverloads
    public HttpUrlConnectionDownloader() {
        this(null, null, 3, null);
    }

    public HttpUrlConnectionDownloader(@NotNull Downloader.FileDownloaderType fileDownloaderType) {
        Intrinsics.checkParameterIsNotNull((Object)fileDownloaderType, (String)"fileDownloaderType");
        this(null, fileDownloaderType);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u000e\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0006\"\u0004\b\u0011\u0010\bR\u001a\u0010\u0012\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\f\"\u0004\b\u0014\u0010\u000eR\u001a\u0010\u0015\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\f\"\u0004\b\u0017\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lcom/tonyodev/fetch2/HttpUrlConnectionDownloader$HttpUrlConnectionPreferences;", "", "()V", "connectTimeout", "", "getConnectTimeout", "()I", "setConnectTimeout", "(I)V", "followsRedirect", "", "getFollowsRedirect", "()Z", "setFollowsRedirect", "(Z)V", "readTimeout", "getReadTimeout", "setReadTimeout", "usesCache", "getUsesCache", "setUsesCache", "usesDefaultCache", "getUsesDefaultCache", "setUsesDefaultCache", "fetch2_release"})
    public static class HttpUrlConnectionPreferences {
        private int readTimeout = 20000;
        private int connectTimeout = 15000;
        private boolean usesCache;
        private boolean usesDefaultCache;
        private boolean followsRedirect = true;

        public final int getReadTimeout() {
            return this.readTimeout;
        }

        public final void setReadTimeout(int n) {
            this.readTimeout = n;
        }

        public final int getConnectTimeout() {
            return this.connectTimeout;
        }

        public final void setConnectTimeout(int n) {
            this.connectTimeout = n;
        }

        public final boolean getUsesCache() {
            return this.usesCache;
        }

        public final void setUsesCache(boolean bl) {
            this.usesCache = bl;
        }

        public final boolean getUsesDefaultCache() {
            return this.usesDefaultCache;
        }

        public final void setUsesDefaultCache(boolean bl) {
            this.usesDefaultCache = bl;
        }

        public final boolean getFollowsRedirect() {
            return this.followsRedirect;
        }

        public final void setFollowsRedirect(boolean bl) {
            this.followsRedirect = bl;
        }
    }
}

