/*
 * Decompiled with CFR 0.152.
 */
package com.tonyodev.fetch2.fetch;

import android.os.Handler;
import android.os.Looper;
import com.tonyodev.fetch2.Download;
import com.tonyodev.fetch2.FetchConfiguration;
import com.tonyodev.fetch2.FetchNotificationManager;
import com.tonyodev.fetch2.database.DatabaseManager;
import com.tonyodev.fetch2.database.DatabaseManagerImpl;
import com.tonyodev.fetch2.database.DownloadDatabase;
import com.tonyodev.fetch2.database.DownloadInfo;
import com.tonyodev.fetch2.downloader.DownloadManager;
import com.tonyodev.fetch2.downloader.DownloadManagerCoordinator;
import com.tonyodev.fetch2.downloader.DownloadManagerImpl;
import com.tonyodev.fetch2.fetch.FetchHandler;
import com.tonyodev.fetch2.fetch.FetchHandlerImpl;
import com.tonyodev.fetch2.fetch.ListenerCoordinator;
import com.tonyodev.fetch2.fetch.LiveSettings;
import com.tonyodev.fetch2.helper.DownloadInfoUpdater;
import com.tonyodev.fetch2.helper.PriorityListProcessor;
import com.tonyodev.fetch2.helper.PriorityListProcessorImpl;
import com.tonyodev.fetch2.provider.DownloadProvider;
import com.tonyodev.fetch2.provider.NetworkInfoProvider;
import com.tonyodev.fetch2.util.FetchUtils;
import com.tonyodev.fetch2core.HandlerWrapper;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u000f\u0010B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/tonyodev/fetch2/fetch/FetchModulesBuilder;", "", "()V", "holderMap", "", "", "Lcom/tonyodev/fetch2/fetch/FetchModulesBuilder$Holder;", "lock", "buildModulesFromPrefs", "Lcom/tonyodev/fetch2/fetch/FetchModulesBuilder$Modules;", "fetchConfiguration", "Lcom/tonyodev/fetch2/FetchConfiguration;", "removeNamespaceInstanceReference", "", "namespace", "Holder", "Modules", "fetch2_release"})
public final class FetchModulesBuilder {
    private static final Object lock;
    private static final Map<String, Holder> holderMap;
    public static final FetchModulesBuilder INSTANCE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Modules buildModulesFromPrefs(@NotNull FetchConfiguration fetchConfiguration) {
        Modules modules;
        Intrinsics.checkParameterIsNotNull((Object)fetchConfiguration, (String)"fetchConfiguration");
        Object object = lock;
        synchronized (object) {
            Modules modules2;
            Holder holder = holderMap.get(fetchConfiguration.getNamespace());
            if (holder != null) {
                modules2 = new Modules(fetchConfiguration, holder.getHandlerWrapper(), holder.getDatabaseManager(), holder.getDownloadManagerCoordinator(), holder.getListenerCoordinator());
            } else {
                HandlerWrapper newHandlerWrapper = new HandlerWrapper(fetchConfiguration.getNamespace());
                LiveSettings liveSettings = new LiveSettings(fetchConfiguration.getNamespace());
                DatabaseManagerImpl newDatabaseManager = new DatabaseManagerImpl(fetchConfiguration.getAppContext(), fetchConfiguration.getNamespace(), DownloadDatabase.Companion.getMigrations(), liveSettings, fetchConfiguration.getFileExistChecksEnabled());
                DownloadManagerCoordinator downloadManagerCoordinator = new DownloadManagerCoordinator(fetchConfiguration.getNamespace());
                ListenerCoordinator listenerCoordinator = new ListenerCoordinator(fetchConfiguration.getNamespace());
                Modules newModules = new Modules(fetchConfiguration, newHandlerWrapper, newDatabaseManager, downloadManagerCoordinator, listenerCoordinator);
                Map<String, Holder> map = holderMap;
                String string2 = fetchConfiguration.getNamespace();
                Holder holder2 = new Holder(newHandlerWrapper, newDatabaseManager, downloadManagerCoordinator, listenerCoordinator, newModules.getNetworkInfoProvider());
                map.put(string2, holder2);
                modules2 = newModules;
            }
            Modules modules3 = modules2;
            modules3.getHandlerWrapper().incrementUsageCounter();
            modules = modules3;
        }
        return modules;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeNamespaceInstanceReference(@NotNull String namespace) {
        Intrinsics.checkParameterIsNotNull((Object)namespace, (String)"namespace");
        Object object = lock;
        synchronized (object) {
            Holder holder = holderMap.get(namespace);
            if (holder != null) {
                holder.getHandlerWrapper().decrementUsageCounter();
                if (holder.getHandlerWrapper().usageCount() == 0) {
                    holder.getHandlerWrapper().close();
                    holder.getListenerCoordinator().clearAll();
                    holder.getDatabaseManager().close();
                    holder.getDownloadManagerCoordinator().clearAll();
                    holder.getNetworkInfoProvider().unregisterAllNetworkChangeListeners();
                    holderMap.remove(namespace);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private FetchModulesBuilder() {
    }

    static {
        FetchModulesBuilder fetchModulesBuilder;
        INSTANCE = fetchModulesBuilder = new FetchModulesBuilder();
        lock = new Object();
        holderMap = new LinkedHashMap();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\tH\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u000bH\u00c6\u0003J;\u0010\u001c\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u00c6\u0001J\u0013\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010 \u001a\u00020!H\u00d6\u0001J\t\u0010\"\u001a\u00020#H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006$"}, d2={"Lcom/tonyodev/fetch2/fetch/FetchModulesBuilder$Holder;", "", "handlerWrapper", "Lcom/tonyodev/fetch2core/HandlerWrapper;", "databaseManager", "Lcom/tonyodev/fetch2/database/DatabaseManager;", "downloadManagerCoordinator", "Lcom/tonyodev/fetch2/downloader/DownloadManagerCoordinator;", "listenerCoordinator", "Lcom/tonyodev/fetch2/fetch/ListenerCoordinator;", "networkInfoProvider", "Lcom/tonyodev/fetch2/provider/NetworkInfoProvider;", "(Lcom/tonyodev/fetch2core/HandlerWrapper;Lcom/tonyodev/fetch2/database/DatabaseManager;Lcom/tonyodev/fetch2/downloader/DownloadManagerCoordinator;Lcom/tonyodev/fetch2/fetch/ListenerCoordinator;Lcom/tonyodev/fetch2/provider/NetworkInfoProvider;)V", "getDatabaseManager", "()Lcom/tonyodev/fetch2/database/DatabaseManager;", "getDownloadManagerCoordinator", "()Lcom/tonyodev/fetch2/downloader/DownloadManagerCoordinator;", "getHandlerWrapper", "()Lcom/tonyodev/fetch2core/HandlerWrapper;", "getListenerCoordinator", "()Lcom/tonyodev/fetch2/fetch/ListenerCoordinator;", "getNetworkInfoProvider", "()Lcom/tonyodev/fetch2/provider/NetworkInfoProvider;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "toString", "", "fetch2_release"})
    public static final class Holder {
        @NotNull
        private final HandlerWrapper handlerWrapper;
        @NotNull
        private final DatabaseManager databaseManager;
        @NotNull
        private final DownloadManagerCoordinator downloadManagerCoordinator;
        @NotNull
        private final ListenerCoordinator listenerCoordinator;
        @NotNull
        private final NetworkInfoProvider networkInfoProvider;

        @NotNull
        public final HandlerWrapper getHandlerWrapper() {
            return this.handlerWrapper;
        }

        @NotNull
        public final DatabaseManager getDatabaseManager() {
            return this.databaseManager;
        }

        @NotNull
        public final DownloadManagerCoordinator getDownloadManagerCoordinator() {
            return this.downloadManagerCoordinator;
        }

        @NotNull
        public final ListenerCoordinator getListenerCoordinator() {
            return this.listenerCoordinator;
        }

        @NotNull
        public final NetworkInfoProvider getNetworkInfoProvider() {
            return this.networkInfoProvider;
        }

        public Holder(@NotNull HandlerWrapper handlerWrapper, @NotNull DatabaseManager databaseManager, @NotNull DownloadManagerCoordinator downloadManagerCoordinator, @NotNull ListenerCoordinator listenerCoordinator, @NotNull NetworkInfoProvider networkInfoProvider) {
            Intrinsics.checkParameterIsNotNull((Object)handlerWrapper, (String)"handlerWrapper");
            Intrinsics.checkParameterIsNotNull((Object)databaseManager, (String)"databaseManager");
            Intrinsics.checkParameterIsNotNull((Object)downloadManagerCoordinator, (String)"downloadManagerCoordinator");
            Intrinsics.checkParameterIsNotNull((Object)listenerCoordinator, (String)"listenerCoordinator");
            Intrinsics.checkParameterIsNotNull((Object)networkInfoProvider, (String)"networkInfoProvider");
            this.handlerWrapper = handlerWrapper;
            this.databaseManager = databaseManager;
            this.downloadManagerCoordinator = downloadManagerCoordinator;
            this.listenerCoordinator = listenerCoordinator;
            this.networkInfoProvider = networkInfoProvider;
        }

        @NotNull
        public final HandlerWrapper component1() {
            return this.handlerWrapper;
        }

        @NotNull
        public final DatabaseManager component2() {
            return this.databaseManager;
        }

        @NotNull
        public final DownloadManagerCoordinator component3() {
            return this.downloadManagerCoordinator;
        }

        @NotNull
        public final ListenerCoordinator component4() {
            return this.listenerCoordinator;
        }

        @NotNull
        public final NetworkInfoProvider component5() {
            return this.networkInfoProvider;
        }

        @NotNull
        public final Holder copy(@NotNull HandlerWrapper handlerWrapper, @NotNull DatabaseManager databaseManager, @NotNull DownloadManagerCoordinator downloadManagerCoordinator, @NotNull ListenerCoordinator listenerCoordinator, @NotNull NetworkInfoProvider networkInfoProvider) {
            Intrinsics.checkParameterIsNotNull((Object)handlerWrapper, (String)"handlerWrapper");
            Intrinsics.checkParameterIsNotNull((Object)databaseManager, (String)"databaseManager");
            Intrinsics.checkParameterIsNotNull((Object)downloadManagerCoordinator, (String)"downloadManagerCoordinator");
            Intrinsics.checkParameterIsNotNull((Object)listenerCoordinator, (String)"listenerCoordinator");
            Intrinsics.checkParameterIsNotNull((Object)networkInfoProvider, (String)"networkInfoProvider");
            return new Holder(handlerWrapper, databaseManager, downloadManagerCoordinator, listenerCoordinator, networkInfoProvider);
        }

        @NotNull
        public static /* synthetic */ Holder copy$default(Holder holder, HandlerWrapper handlerWrapper, DatabaseManager databaseManager, DownloadManagerCoordinator downloadManagerCoordinator, ListenerCoordinator listenerCoordinator, NetworkInfoProvider networkInfoProvider, int n, Object object) {
            if ((n & 1) != 0) {
                handlerWrapper = holder.handlerWrapper;
            }
            if ((n & 2) != 0) {
                databaseManager = holder.databaseManager;
            }
            if ((n & 4) != 0) {
                downloadManagerCoordinator = holder.downloadManagerCoordinator;
            }
            if ((n & 8) != 0) {
                listenerCoordinator = holder.listenerCoordinator;
            }
            if ((n & 0x10) != 0) {
                networkInfoProvider = holder.networkInfoProvider;
            }
            return holder.copy(handlerWrapper, databaseManager, downloadManagerCoordinator, listenerCoordinator, networkInfoProvider);
        }

        @NotNull
        public String toString() {
            return "Holder(handlerWrapper=" + this.handlerWrapper + ", databaseManager=" + this.databaseManager + ", downloadManagerCoordinator=" + this.downloadManagerCoordinator + ", listenerCoordinator=" + this.listenerCoordinator + ", networkInfoProvider=" + this.networkInfoProvider + ")";
        }

        public int hashCode() {
            HandlerWrapper handlerWrapper = this.handlerWrapper;
            DatabaseManager databaseManager = this.databaseManager;
            DownloadManagerCoordinator downloadManagerCoordinator = this.downloadManagerCoordinator;
            ListenerCoordinator listenerCoordinator = this.listenerCoordinator;
            NetworkInfoProvider networkInfoProvider = this.networkInfoProvider;
            return ((((handlerWrapper != null ? handlerWrapper.hashCode() : 0) * 31 + (databaseManager != null ? databaseManager.hashCode() : 0)) * 31 + (downloadManagerCoordinator != null ? downloadManagerCoordinator.hashCode() : 0)) * 31 + (listenerCoordinator != null ? listenerCoordinator.hashCode() : 0)) * 31 + (networkInfoProvider != null ? networkInfoProvider.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Holder)) break block3;
                    Holder holder = (Holder)object;
                    if (!Intrinsics.areEqual((Object)this.handlerWrapper, (Object)holder.handlerWrapper) || !Intrinsics.areEqual((Object)this.databaseManager, (Object)holder.databaseManager) || !Intrinsics.areEqual((Object)this.downloadManagerCoordinator, (Object)holder.downloadManagerCoordinator) || !Intrinsics.areEqual((Object)this.listenerCoordinator, (Object)holder.listenerCoordinator) || !Intrinsics.areEqual((Object)this.networkInfoProvider, (Object)holder.networkInfoProvider)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0011\u0010#\u001a\u00020$\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0017\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u0011\u0010,\u001a\u00020-\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/\u00a8\u00060"}, d2={"Lcom/tonyodev/fetch2/fetch/FetchModulesBuilder$Modules;", "", "fetchConfiguration", "Lcom/tonyodev/fetch2/FetchConfiguration;", "handlerWrapper", "Lcom/tonyodev/fetch2core/HandlerWrapper;", "databaseManager", "Lcom/tonyodev/fetch2/database/DatabaseManager;", "downloadManagerCoordinator", "Lcom/tonyodev/fetch2/downloader/DownloadManagerCoordinator;", "listenerCoordinator", "Lcom/tonyodev/fetch2/fetch/ListenerCoordinator;", "(Lcom/tonyodev/fetch2/FetchConfiguration;Lcom/tonyodev/fetch2core/HandlerWrapper;Lcom/tonyodev/fetch2/database/DatabaseManager;Lcom/tonyodev/fetch2/downloader/DownloadManagerCoordinator;Lcom/tonyodev/fetch2/fetch/ListenerCoordinator;)V", "downloadInfoUpdater", "Lcom/tonyodev/fetch2/helper/DownloadInfoUpdater;", "getDownloadInfoUpdater", "()Lcom/tonyodev/fetch2/helper/DownloadInfoUpdater;", "downloadManager", "Lcom/tonyodev/fetch2/downloader/DownloadManager;", "getDownloadManager", "()Lcom/tonyodev/fetch2/downloader/DownloadManager;", "downloadProvider", "Lcom/tonyodev/fetch2/provider/DownloadProvider;", "getDownloadProvider", "()Lcom/tonyodev/fetch2/provider/DownloadProvider;", "getFetchConfiguration", "()Lcom/tonyodev/fetch2/FetchConfiguration;", "fetchHandler", "Lcom/tonyodev/fetch2/fetch/FetchHandler;", "getFetchHandler", "()Lcom/tonyodev/fetch2/fetch/FetchHandler;", "getHandlerWrapper", "()Lcom/tonyodev/fetch2core/HandlerWrapper;", "getListenerCoordinator", "()Lcom/tonyodev/fetch2/fetch/ListenerCoordinator;", "networkInfoProvider", "Lcom/tonyodev/fetch2/provider/NetworkInfoProvider;", "getNetworkInfoProvider", "()Lcom/tonyodev/fetch2/provider/NetworkInfoProvider;", "priorityListProcessor", "Lcom/tonyodev/fetch2/helper/PriorityListProcessor;", "Lcom/tonyodev/fetch2/Download;", "getPriorityListProcessor", "()Lcom/tonyodev/fetch2/helper/PriorityListProcessor;", "uiHandler", "Landroid/os/Handler;", "getUiHandler", "()Landroid/os/Handler;", "fetch2_release"})
    public static final class Modules {
        @NotNull
        private final DownloadManager downloadManager;
        @NotNull
        private final PriorityListProcessor<Download> priorityListProcessor;
        @NotNull
        private final DownloadProvider downloadProvider;
        @NotNull
        private final DownloadInfoUpdater downloadInfoUpdater;
        @NotNull
        private final NetworkInfoProvider networkInfoProvider;
        @NotNull
        private final FetchHandler fetchHandler;
        @NotNull
        private final Handler uiHandler;
        @NotNull
        private final FetchConfiguration fetchConfiguration;
        @NotNull
        private final HandlerWrapper handlerWrapper;
        @NotNull
        private final ListenerCoordinator listenerCoordinator;

        @NotNull
        public final DownloadManager getDownloadManager() {
            return this.downloadManager;
        }

        @NotNull
        public final PriorityListProcessor<Download> getPriorityListProcessor() {
            return this.priorityListProcessor;
        }

        @NotNull
        public final DownloadProvider getDownloadProvider() {
            return this.downloadProvider;
        }

        @NotNull
        public final DownloadInfoUpdater getDownloadInfoUpdater() {
            return this.downloadInfoUpdater;
        }

        @NotNull
        public final NetworkInfoProvider getNetworkInfoProvider() {
            return this.networkInfoProvider;
        }

        @NotNull
        public final FetchHandler getFetchHandler() {
            return this.fetchHandler;
        }

        @NotNull
        public final Handler getUiHandler() {
            return this.uiHandler;
        }

        @NotNull
        public final FetchConfiguration getFetchConfiguration() {
            return this.fetchConfiguration;
        }

        @NotNull
        public final HandlerWrapper getHandlerWrapper() {
            return this.handlerWrapper;
        }

        @NotNull
        public final ListenerCoordinator getListenerCoordinator() {
            return this.listenerCoordinator;
        }

        public Modules(@NotNull FetchConfiguration fetchConfiguration, @NotNull HandlerWrapper handlerWrapper, @NotNull DatabaseManager databaseManager, @NotNull DownloadManagerCoordinator downloadManagerCoordinator, @NotNull ListenerCoordinator listenerCoordinator) {
            block0: {
                Intrinsics.checkParameterIsNotNull((Object)fetchConfiguration, (String)"fetchConfiguration");
                Intrinsics.checkParameterIsNotNull((Object)handlerWrapper, (String)"handlerWrapper");
                Intrinsics.checkParameterIsNotNull((Object)databaseManager, (String)"databaseManager");
                Intrinsics.checkParameterIsNotNull((Object)downloadManagerCoordinator, (String)"downloadManagerCoordinator");
                Intrinsics.checkParameterIsNotNull((Object)listenerCoordinator, (String)"listenerCoordinator");
                this.fetchConfiguration = fetchConfiguration;
                this.handlerWrapper = handlerWrapper;
                this.listenerCoordinator = listenerCoordinator;
                this.downloadProvider = new DownloadProvider(databaseManager);
                this.downloadInfoUpdater = new DownloadInfoUpdater(databaseManager);
                this.networkInfoProvider = new NetworkInfoProvider(this.fetchConfiguration.getAppContext());
                this.uiHandler = new Handler(Looper.getMainLooper());
                this.downloadManager = new DownloadManagerImpl(this.fetchConfiguration.getHttpDownloader(), this.fetchConfiguration.getConcurrentLimit(), this.fetchConfiguration.getProgressReportingIntervalMillis(), this.fetchConfiguration.getLogger(), this.networkInfoProvider, this.fetchConfiguration.getRetryOnNetworkGain(), this.downloadInfoUpdater, downloadManagerCoordinator, this.listenerCoordinator, this.fetchConfiguration.getFileServerDownloader(), this.fetchConfiguration.getHashCheckingEnabled(), this.uiHandler, this.fetchConfiguration.getStorageResolver());
                this.priorityListProcessor = new PriorityListProcessorImpl(this.handlerWrapper, this.downloadProvider, this.downloadManager, this.networkInfoProvider, this.fetchConfiguration.getLogger(), this.listenerCoordinator, this.fetchConfiguration.getConcurrentLimit(), this.fetchConfiguration.getAppContext(), this.fetchConfiguration.getNamespace());
                this.priorityListProcessor.setGlobalNetworkType(this.fetchConfiguration.getGlobalNetworkType());
                this.fetchHandler = new FetchHandlerImpl(this.fetchConfiguration.getNamespace(), databaseManager, this.downloadManager, this.priorityListProcessor, this.fetchConfiguration.getLogger(), this.fetchConfiguration.getAutoStart(), this.fetchConfiguration.getHttpDownloader(), this.fetchConfiguration.getFileServerDownloader(), this.listenerCoordinator, this.uiHandler, this.fetchConfiguration.getStorageResolver(), this.fetchConfiguration.getFetchNotificationManager());
                databaseManager.setDelegate(new DatabaseManager.Delegate(){

                    @Override
                    public void deleteTempFilesForDownload(@NotNull DownloadInfo downloadInfo) {
                        Intrinsics.checkParameterIsNotNull((Object)downloadInfo, (String)"downloadInfo");
                        String tempDir = this.getFetchConfiguration().getStorageResolver().getDirectoryForFileDownloaderTypeParallel(FetchUtils.getRequestForDownload$default(downloadInfo, null, 2, null));
                        FetchUtils.deleteAllInFolderForId(downloadInfo.getId(), tempDir);
                    }
                });
                FetchNotificationManager fetchNotificationManager = this.fetchConfiguration.getFetchNotificationManager();
                if (fetchNotificationManager == null) break block0;
                fetchNotificationManager.setProgressReportingIntervalInMillis(this.fetchConfiguration.getProgressReportingIntervalMillis());
            }
        }
    }
}

