/*
 * Decompiled with CFR 0.152.
 */
package com.tonyodev.fetch2.downloader;

import com.tonyodev.fetch2.Download;
import com.tonyodev.fetch2.Error;
import com.tonyodev.fetch2.FetchErrorUtils;
import com.tonyodev.fetch2.database.DownloadInfo;
import com.tonyodev.fetch2.downloader.FileDownloader;
import com.tonyodev.fetch2.downloader.ParallelFileDownloaderImpl;
import com.tonyodev.fetch2.exception.FetchException;
import com.tonyodev.fetch2.helper.FileDownloaderDelegate;
import com.tonyodev.fetch2.provider.NetworkInfoProvider;
import com.tonyodev.fetch2.util.FetchTypeConverterExtensions;
import com.tonyodev.fetch2.util.FetchUtils;
import com.tonyodev.fetch2core.AverageCalculator;
import com.tonyodev.fetch2core.DownloadBlock;
import com.tonyodev.fetch2core.DownloadBlockInfo;
import com.tonyodev.fetch2core.Downloader;
import com.tonyodev.fetch2core.FetchCoreUtils;
import com.tonyodev.fetch2core.FileSlice;
import com.tonyodev.fetch2core.FileSliceInfo;
import com.tonyodev.fetch2core.InterruptMonitor;
import com.tonyodev.fetch2core.Logger;
import com.tonyodev.fetch2core.OutputResourceWrapper;
import java.io.File;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u00a1\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007*\u0001/\u0018\u00002\u00020\u0001BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\r\u00a2\u0006\u0002\u0010\u0011J\b\u0010B\u001a\u00020CH\u0002J\u001e\u0010D\u001a\u00020C2\u0006\u0010E\u001a\u00020F2\f\u0010G\u001a\b\u0012\u0004\u0012\u00020-0,H\u0002J\b\u0010H\u001a\u00020\u0007H\u0002J\u0010\u0010I\u001a\u00020J2\u0006\u0010E\u001a\u00020FH\u0002J\u001e\u0010K\u001a\b\u0012\u0004\u0012\u00020-0,2\u0006\u0010L\u001a\u00020\r2\u0006\u0010E\u001a\u00020FH\u0002J\b\u0010M\u001a\u00020CH\u0002J\b\u0010N\u001a\u00020CH\u0016J\b\u0010O\u001a\u00020CH\u0002J\b\u0010P\u001a\u00020CH\u0002R\u0012\u0010\u0012\u001a\u00020\u00138\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0017\u001a\u00020\r8\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001c\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u0014\u0010\"\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010'\u001a\u00020\u00078\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010)\u001a\u0004\u0018\u00010*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010+\u001a\b\u0012\u0004\u0012\u00020-0,X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010.\u001a\u00020/X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u00100R&\u00102\u001a\u00020\r2\u0006\u00101\u001a\u00020\r8\u0016@VX\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u0010\u0019\"\u0004\b4\u0010\u001bR\u000e\u00105\u001a\u000206X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00107\u001a\u000208X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00109\u001a\u0004\u0018\u00010:X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010;\u001a\u00020\r2\u0006\u00101\u001a\u00020\r8\u0016@VX\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u0010\u0019\"\u0004\b=\u0010\u001bR\u0014\u0010>\u001a\u0004\u0018\u00010?8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010@\u001a\u00020\u00078\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010A\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006Q"}, d2={"Lcom/tonyodev/fetch2/downloader/ParallelFileDownloaderImpl;", "Lcom/tonyodev/fetch2/downloader/FileDownloader;", "initialDownload", "Lcom/tonyodev/fetch2/Download;", "downloader", "Lcom/tonyodev/fetch2core/Downloader;", "progressReportingIntervalMillis", "", "logger", "Lcom/tonyodev/fetch2core/Logger;", "networkInfoProvider", "Lcom/tonyodev/fetch2/provider/NetworkInfoProvider;", "retryOnNetworkGain", "", "fileTempDir", "", "md5CheckingEnabled", "(Lcom/tonyodev/fetch2/Download;Lcom/tonyodev/fetch2core/Downloader;JLcom/tonyodev/fetch2core/Logger;Lcom/tonyodev/fetch2/provider/NetworkInfoProvider;ZLjava/lang/String;Z)V", "actionsCounter", "", "actionsTotal", "averageDownloadedBytesPerSecond", "", "completedDownload", "getCompletedDownload", "()Z", "setCompletedDownload", "(Z)V", "delegate", "Lcom/tonyodev/fetch2/downloader/FileDownloader$Delegate;", "getDelegate", "()Lcom/tonyodev/fetch2/downloader/FileDownloader$Delegate;", "setDelegate", "(Lcom/tonyodev/fetch2/downloader/FileDownloader$Delegate;)V", "download", "getDownload", "()Lcom/tonyodev/fetch2/Download;", "downloadInfo", "Lcom/tonyodev/fetch2/database/DownloadInfo;", "downloaded", "estimatedTimeRemainingInMilliseconds", "executorService", "Ljava/util/concurrent/ExecutorService;", "fileSlices", "", "Lcom/tonyodev/fetch2core/FileSlice;", "interruptMonitor", "com/tonyodev/fetch2/downloader/ParallelFileDownloaderImpl$interruptMonitor$1", "Lcom/tonyodev/fetch2/downloader/ParallelFileDownloaderImpl$interruptMonitor$1;", "value", "interrupted", "getInterrupted", "setInterrupted", "lock", "Ljava/lang/Object;", "movingAverageCalculator", "Lcom/tonyodev/fetch2core/AverageCalculator;", "outputResourceWrapper", "Lcom/tonyodev/fetch2core/OutputResourceWrapper;", "terminated", "getTerminated", "setTerminated", "throwable", "", "total", "totalDownloadBlocks", "deleteAllTempFiles", "", "downloadSliceFiles", "request", "Lcom/tonyodev/fetch2core/Downloader$ServerRequest;", "fileSlicesDownloadsList", "getAverageDownloadedBytesPerSecond", "getChuckInfo", "Lcom/tonyodev/fetch2core/FileSliceInfo;", "getFileSliceList", "acceptsRanges", "incrementActionCompletedCount", "run", "throwExceptionIfFound", "waitAndPerformProgressReporting", "fetch2_release"})
public final class ParallelFileDownloaderImpl
implements FileDownloader {
    private volatile boolean interrupted;
    private volatile boolean terminated;
    private volatile boolean completedDownload;
    @Nullable
    private FileDownloader.Delegate delegate;
    private final DownloadInfo downloadInfo;
    private volatile long downloaded;
    private volatile long total;
    private double averageDownloadedBytesPerSecond;
    private final AverageCalculator movingAverageCalculator;
    private long estimatedTimeRemainingInMilliseconds;
    private ExecutorService executorService;
    private volatile int actionsCounter;
    private int actionsTotal;
    private final Object lock;
    private volatile Throwable throwable;
    private List<FileSlice> fileSlices;
    private OutputResourceWrapper outputResourceWrapper;
    private int totalDownloadBlocks;
    private final interruptMonitor.1 interruptMonitor;
    private final Download initialDownload;
    private final Downloader downloader;
    private final long progressReportingIntervalMillis;
    private final Logger logger;
    private final NetworkInfoProvider networkInfoProvider;
    private final boolean retryOnNetworkGain;
    private final String fileTempDir;
    private final boolean md5CheckingEnabled;

    @Override
    public boolean getInterrupted() {
        return this.interrupted;
    }

    @Override
    public void setInterrupted(boolean value) {
        FileDownloader.Delegate delegate = this.getDelegate();
        if (!(delegate instanceof FileDownloaderDelegate)) {
            delegate = null;
        }
        FileDownloaderDelegate fileDownloaderDelegate = (FileDownloaderDelegate)delegate;
        if (fileDownloaderDelegate != null) {
            fileDownloaderDelegate.setInterrupted(value);
        }
        this.interrupted = value;
    }

    @Override
    public boolean getTerminated() {
        return this.terminated;
    }

    @Override
    public void setTerminated(boolean value) {
        FileDownloader.Delegate delegate = this.getDelegate();
        if (!(delegate instanceof FileDownloaderDelegate)) {
            delegate = null;
        }
        FileDownloaderDelegate fileDownloaderDelegate = (FileDownloaderDelegate)delegate;
        if (fileDownloaderDelegate != null) {
            fileDownloaderDelegate.setInterrupted(value);
        }
        this.terminated = value;
    }

    @Override
    public boolean getCompletedDownload() {
        return this.completedDownload;
    }

    @Override
    public void setCompletedDownload(boolean bl) {
        this.completedDownload = bl;
    }

    @Override
    @Nullable
    public FileDownloader.Delegate getDelegate() {
        return this.delegate;
    }

    @Override
    public void setDelegate(@Nullable FileDownloader.Delegate delegate) {
        this.delegate = delegate;
    }

    @Override
    @NotNull
    public Download getDownload() {
        this.downloadInfo.setDownloaded(this.downloaded);
        this.downloadInfo.setTotal(this.total);
        return this.downloadInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        Downloader.Response openingResponse = null;
        try {
            Downloader.ServerRequest openingRequest = this.downloader.getHeadRequestMethodSupported(FetchUtils.getRequestForDownload$default(this.initialDownload, null, 2, null)) ? FetchUtils.getRequestForDownload(this.initialDownload, "HEAD") : FetchUtils.getRequestForDownload$default(this.initialDownload, null, 2, null);
            openingResponse = this.downloader.execute(openingRequest, (InterruptMonitor)this.interruptMonitor);
            if (!this.getInterrupted() && !this.getTerminated()) {
                Downloader.Response response2 = openingResponse;
                if (response2 != null) {
                    if (response2.isSuccessful()) {
                        Iterable $receiver$iv;
                        FileSlice it;
                        void $receiver$iv$iv;
                        Iterable $receiver$iv2;
                        this.total = openingResponse.getContentLength();
                        if (this.total <= 0L) throw (Throwable)new FetchException("empty_response_body");
                        this.fileSlices = this.getFileSliceList(openingResponse.getAcceptsRanges(), openingRequest);
                        this.totalDownloadBlocks = this.fileSlices.size();
                        try {
                            this.downloader.disconnect(openingResponse);
                        }
                        catch (Exception e) {
                            this.logger.e("FileDownloader", (Throwable)e);
                        }
                        Iterable iterable = $receiver$iv2 = (Iterable)this.fileSlices;
                        Collection collection = new ArrayList();
                        for (Object t : $receiver$iv$iv) {
                            it = (FileSlice)t;
                            if (!(!it.isDownloaded())) continue;
                            collection.add(t);
                        }
                        List sliceFileDownloadsList = (List)collection;
                        if (this.getInterrupted() || this.getTerminated()) return;
                        this.downloadInfo.setDownloaded(this.downloaded);
                        this.downloadInfo.setTotal(this.total);
                        Iterable iterable2 = $receiver$iv = (Iterable)this.fileSlices;
                        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                        for (Object item$iv$iv : iterable2) {
                            void it2;
                            FileSlice $i$a$1$filter = (FileSlice)item$iv$iv;
                            Collection collection2 = destination$iv$iv;
                            DownloadBlockInfo downloadBlock2 = new DownloadBlockInfo();
                            downloadBlock2.setDownloadId(it2.getId());
                            downloadBlock2.setBlockPosition(it2.getPosition());
                            downloadBlock2.setDownloadedBytes(it2.getDownloaded());
                            downloadBlock2.setStartByte(it2.getStartBytes());
                            downloadBlock2.setEndByte(it2.getEndBytes());
                            DownloadBlockInfo downloadBlockInfo = downloadBlock2;
                            collection2.add(downloadBlockInfo);
                        }
                        List downloadBlocks = (List)destination$iv$iv;
                        FileDownloader.Delegate delegate = this.getDelegate();
                        if (delegate != null) {
                            delegate.onStarted(this.downloadInfo, downloadBlocks, this.totalDownloadBlocks);
                        }
                        $receiver$iv = downloadBlocks;
                        for (Object element$iv : $receiver$iv) {
                            DownloadBlockInfo downloadBlockInfo = (DownloadBlockInfo)element$iv;
                            FileDownloader.Delegate delegate2 = this.getDelegate();
                            if (delegate2 == null) continue;
                            delegate2.onDownloadBlockUpdated(this.downloadInfo, (DownloadBlock)downloadBlockInfo, this.totalDownloadBlocks);
                        }
                        $receiver$iv = sliceFileDownloadsList;
                        if (!$receiver$iv.isEmpty()) {
                            this.executorService = Executors.newFixedThreadPool(sliceFileDownloadsList.size());
                        }
                        this.downloadSliceFiles(openingRequest, sliceFileDownloadsList);
                        this.waitAndPerformProgressReporting();
                        this.downloadInfo.setDownloaded(this.downloaded);
                        this.downloadInfo.setTotal(this.total);
                        if (!this.getInterrupted() && !this.getTerminated()) {
                            long fileSlicesTotal = 0L;
                            Iterable iterable3 = this.fileSlices;
                            for (Object e : iterable3) {
                                it = (FileSlice)e;
                                fileSlicesTotal += it.getDownloaded();
                            }
                            if (fileSlicesTotal != this.total) {
                                this.throwable = new FetchException("download_incomplete");
                            }
                            this.throwExceptionIfFound();
                            this.setCompletedDownload(true);
                            if (this.md5CheckingEnabled) {
                                if (!this.downloader.verifyContentMD5(openingResponse.getRequest(), openingResponse.getMd5())) throw (Throwable)new FetchException("invalid content md5");
                                if (!this.getInterrupted() && !this.getTerminated()) {
                                    FileDownloader.Delegate delegate3 = this.getDelegate();
                                    if (delegate3 != null) {
                                        delegate3.onProgress(this.downloadInfo, this.estimatedTimeRemainingInMilliseconds, this.getAverageDownloadedBytesPerSecond());
                                    }
                                    FileDownloader.Delegate delegate4 = this.getDelegate();
                                    if (delegate4 != null) {
                                        delegate4.onComplete(this.downloadInfo);
                                    }
                                }
                            } else if (!this.getInterrupted() && !this.getTerminated()) {
                                FileDownloader.Delegate delegate5 = this.getDelegate();
                                if (delegate5 != null) {
                                    delegate5.onProgress(this.downloadInfo, this.estimatedTimeRemainingInMilliseconds, this.getAverageDownloadedBytesPerSecond());
                                }
                                FileDownloader.Delegate delegate6 = this.getDelegate();
                                if (delegate6 != null) {
                                    delegate6.onComplete(this.downloadInfo);
                                }
                            }
                        }
                        if (this.getCompletedDownload() || this.getTerminated() || this.getInterrupted()) return;
                        this.downloadInfo.setDownloaded(this.downloaded);
                        this.downloadInfo.setTotal(this.total);
                        FileDownloader.Delegate delegate7 = this.getDelegate();
                        if (delegate7 != null) {
                            delegate7.saveDownloadProgress(this.downloadInfo);
                        }
                        FileDownloader.Delegate delegate8 = this.getDelegate();
                        if (delegate8 == null) return;
                        delegate8.onProgress(this.downloadInfo, this.estimatedTimeRemainingInMilliseconds, this.getAverageDownloadedBytesPerSecond());
                        return;
                    }
                }
            }
            if (openingResponse == null && !this.getInterrupted() && !this.getTerminated()) {
                throw (Throwable)new FetchException("empty_response_body");
            }
            Downloader.Response response3 = openingResponse;
            if (response3 != null) {
                if (!response3.isSuccessful()) {
                    if (!this.getInterrupted() && !this.getTerminated()) {
                        throw (Throwable)new FetchException("request_not_successful");
                    }
                }
            }
            if (this.getInterrupted() || this.getTerminated()) return;
            throw (Throwable)new FetchException("unknown");
        }
        catch (Exception e) {
            if (this.getInterrupted() || this.getTerminated()) return;
            this.logger.e("FileDownloader", (Throwable)e);
            Error error = FetchErrorUtils.getErrorFromThrowable(e);
            error.setThrowable(e);
            if (this.retryOnNetworkGain) {
                boolean disconnectDetected = !this.networkInfoProvider.isNetworkAvailable();
                int $receiver$iv = 1;
                int n = 10;
                while ($receiver$iv <= n) {
                    void i;
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e2) {
                        this.logger.e("FileDownloader", (Throwable)e2);
                        break;
                    }
                    if (!this.networkInfoProvider.isNetworkAvailable()) {
                        disconnectDetected = true;
                        break;
                    }
                    ++i;
                }
                if (disconnectDetected) {
                    error = Error.NO_NETWORK_CONNECTION;
                }
            }
            this.downloadInfo.setDownloaded(this.downloaded);
            this.downloadInfo.setTotal(this.total);
            this.downloadInfo.setError(error);
            if (this.getTerminated() || this.getInterrupted()) return;
            FileDownloader.Delegate delegate = this.getDelegate();
            if (delegate == null) return;
            delegate.onError(this.downloadInfo, error, e);
            return;
        }
        finally {
            try {
                ExecutorService executorService = this.executorService;
                if (executorService != null) {
                    executorService.shutdown();
                }
            }
            catch (Exception e) {
                this.logger.e("FileDownloader", (Throwable)e);
            }
            try {
                OutputResourceWrapper outputResourceWrapper = this.outputResourceWrapper;
                if (outputResourceWrapper != null) {
                    outputResourceWrapper.close();
                }
            }
            catch (Exception e) {
                this.logger.e("FileDownloader", (Throwable)e);
            }
            if (openingResponse != null) {
                try {
                    this.downloader.disconnect(openingResponse);
                }
                catch (Exception e) {
                    this.logger.e("FileDownloader", (Throwable)e);
                }
            }
            this.setTerminated(true);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<FileSlice> getFileSliceList(boolean acceptsRanges, Downloader.ServerRequest request) {
        List list;
        File file = FetchCoreUtils.getFile((String)this.downloadInfo.getFile());
        if (!file.exists()) {
            this.deleteAllTempFiles();
        }
        int previousSliceSize = FetchUtils.getPreviousSliceCount(this.downloadInfo.getId(), this.fileTempDir);
        if (acceptsRanges) {
            FileSliceInfo fileSliceInfo = this.getChuckInfo(request);
            if (previousSliceSize != fileSliceInfo.getSlicingCount()) {
                this.deleteAllTempFiles();
            }
            FetchUtils.saveCurrentSliceCount(this.downloadInfo.getId(), fileSliceInfo.getSlicingCount(), this.fileTempDir);
            long counterBytes = 0L;
            List fileSlices = new ArrayList();
            int n = 1;
            int n2 = fileSliceInfo.getSlicingCount();
            if (n <= n2) {
                while (!this.getInterrupted() && !this.getTerminated()) {
                    void position;
                    long endBytes;
                    long startBytes = counterBytes;
                    counterBytes = endBytes = fileSliceInfo.getSlicingCount() == position ? this.total : counterBytes + fileSliceInfo.getBytesPerFileSlice();
                    FileSlice fileSlice = new FileSlice(this.downloadInfo.getId(), (int)position, startBytes, endBytes, FetchUtils.getSavedDownloadedInfo(this.downloadInfo.getId(), (int)position, this.fileTempDir));
                    this.downloaded += fileSlice.getDownloaded();
                    fileSlices.add(fileSlice);
                    if (position == n2) break;
                    ++position;
                }
            }
            list = fileSlices;
        } else {
            if (previousSliceSize != 1) {
                this.deleteAllTempFiles();
            }
            FetchUtils.saveCurrentSliceCount(this.downloadInfo.getId(), 1, this.fileTempDir);
            FileSlice fileSlice = new FileSlice(this.downloadInfo.getId(), 1, 0L, this.total, FetchUtils.getSavedDownloadedInfo(this.downloadInfo.getId(), 1, this.fileTempDir));
            this.downloaded += fileSlice.getDownloaded();
            list = CollectionsKt.listOf((Object)fileSlice);
        }
        return list;
    }

    private final FileSliceInfo getChuckInfo(Downloader.ServerRequest request) {
        Integer n = this.downloader.getFileSlicingCount(request, this.total);
        int fileSliceSize = n != null ? n : -1;
        return FetchUtils.getFileSliceInfo(fileSliceSize, this.total);
    }

    private final long getAverageDownloadedBytesPerSecond() {
        if (this.averageDownloadedBytesPerSecond < 1.0) {
            return 0L;
        }
        double d = this.averageDownloadedBytesPerSecond;
        return (long)Math.ceil(d);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void waitAndPerformProgressReporting() {
        long downloadedBytesPerSecond = this.downloaded;
        long reportingStartTime = System.nanoTime();
        long downloadSpeedStartTime = System.nanoTime();
        while (this.actionsCounter != this.actionsTotal && !this.getInterrupted() && !this.getTerminated()) {
            long reportingStopTime;
            boolean hasReportingTimeElapsed;
            this.downloadInfo.setDownloaded(this.downloaded);
            this.downloadInfo.setTotal(this.total);
            long downloadSpeedStopTime = System.nanoTime();
            boolean downloadSpeedCheckTimeElapsed = FetchCoreUtils.hasIntervalTimeElapsed((long)downloadSpeedStartTime, (long)downloadSpeedStopTime, (long)1000L);
            if (downloadSpeedCheckTimeElapsed) {
                downloadedBytesPerSecond = this.downloaded - downloadedBytesPerSecond;
                this.movingAverageCalculator.add((double)downloadedBytesPerSecond);
                this.averageDownloadedBytesPerSecond = AverageCalculator.getMovingAverageWithWeightOnRecentValues$default((AverageCalculator)this.movingAverageCalculator, (int)0, (int)1, null);
                this.estimatedTimeRemainingInMilliseconds = FetchCoreUtils.calculateEstimatedTimeRemainingInMilliseconds((long)this.downloaded, (long)this.total, (long)this.getAverageDownloadedBytesPerSecond());
                downloadedBytesPerSecond = this.downloaded;
            }
            if (hasReportingTimeElapsed = FetchCoreUtils.hasIntervalTimeElapsed((long)reportingStartTime, (long)(reportingStopTime = System.nanoTime()), (long)this.progressReportingIntervalMillis)) {
                Object object = this.lock;
                synchronized (object) {
                    if (!this.getInterrupted() && !this.getTerminated()) {
                        this.downloadInfo.setDownloaded(this.downloaded);
                        this.downloadInfo.setTotal(this.total);
                        FileDownloader.Delegate delegate = this.getDelegate();
                        if (delegate != null) {
                            delegate.saveDownloadProgress(this.downloadInfo);
                        }
                        FileDownloader.Delegate delegate2 = this.getDelegate();
                        if (delegate2 != null) {
                            delegate2.onProgress(this.downloadInfo, this.estimatedTimeRemainingInMilliseconds, this.getAverageDownloadedBytesPerSecond());
                        }
                    }
                    Unit unit = Unit.INSTANCE;
                }
                reportingStartTime = System.nanoTime();
            }
            if (!downloadSpeedCheckTimeElapsed) continue;
            downloadSpeedStartTime = System.nanoTime();
        }
    }

    private final void downloadSliceFiles(Downloader.ServerRequest request, List<FileSlice> fileSlicesDownloadsList) {
        this.actionsCounter = 0;
        this.actionsTotal = fileSlicesDownloadsList.size();
        this.outputResourceWrapper = this.downloader.getRequestOutputResourceWrapper(request);
        if (this.outputResourceWrapper == null) {
            this.outputResourceWrapper = new OutputResourceWrapper(this){
                private final RandomAccessFile randomAccessFile;
                final /* synthetic */ ParallelFileDownloaderImpl this$0;

                public void write(@NotNull byte[] byteArray, int offSet, int length) {
                    Intrinsics.checkParameterIsNotNull((Object)byteArray, (String)"byteArray");
                    this.randomAccessFile.write(byteArray, offSet, length);
                }

                public void setWriteOffset(long offset) {
                    this.randomAccessFile.seek(offset);
                }

                public void flush() {
                }

                public void close() {
                    this.randomAccessFile.close();
                }
                {
                    this.this$0 = $outer;
                    this.randomAccessFile = new RandomAccessFile(ParallelFileDownloaderImpl.access$getDownloadInfo$p($outer).getFile(), "rw");
                    this.randomAccessFile.seek(0L);
                }
            };
        }
        for (FileSlice fileSlice : fileSlicesDownloadsList) {
            if (this.getInterrupted() || this.getTerminated()) break;
            ExecutorService executorService = this.executorService;
            if (executorService == null) continue;
            executorService.execute(new Runnable(this, fileSlice){
                final /* synthetic */ ParallelFileDownloaderImpl this$0;
                final /* synthetic */ FileSlice $fileSlice;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void run() {
                    block34: {
                        DownloadBlockInfo downloadBlock2 = new DownloadBlockInfo();
                        downloadBlock2.setDownloadId(this.$fileSlice.getId());
                        downloadBlock2.setBlockPosition(this.$fileSlice.getPosition());
                        downloadBlock2.setDownloadedBytes(this.$fileSlice.getDownloaded());
                        downloadBlock2.setStartByte(this.$fileSlice.getStartBytes());
                        downloadBlock2.setEndByte(this.$fileSlice.getEndBytes());
                        Downloader.ServerRequest downloadRequest = FetchUtils.getRequestForDownload$default(ParallelFileDownloaderImpl.access$getDownloadInfo$p(this.this$0), this.$fileSlice.getStartBytes() + this.$fileSlice.getDownloaded(), 0L, null, 12, null);
                        Downloader.Response downloadResponse = null;
                        try {
                            downloadResponse = ParallelFileDownloaderImpl.access$getDownloader$p(this.this$0).execute(downloadRequest, (InterruptMonitor)ParallelFileDownloaderImpl.access$getInterruptMonitor$p(this.this$0));
                            if (!this.this$0.getTerminated() && !this.this$0.getInterrupted()) {
                                Downloader.Response response2 = downloadResponse;
                                if (response2 != null) {
                                    if (response2.isSuccessful()) {
                                        Ref.LongRef longRef = new Ref.LongRef();
                                        int bufferSize = ParallelFileDownloaderImpl.access$getDownloader$p(this.this$0).getRequestBufferSize(downloadRequest);
                                        byte[] buffer = new byte[bufferSize];
                                        InputStream inputStream = downloadResponse.getByteStream();
                                        int read = inputStream != null ? inputStream.read(buffer, 0, bufferSize) : -1;
                                        long remainderBytes = this.$fileSlice.getEndBytes() - (this.$fileSlice.getStartBytes() + this.$fileSlice.getDownloaded());
                                        long reportingStartTime = System.nanoTime();
                                        Ref.IntRef streamBytes = new Ref.IntRef();
                                        Ref.LongRef longRef2 = new Ref.LongRef();
                                        while (remainderBytes > 0L && read != -1 && !this.this$0.getInterrupted() && !this.this$0.getTerminated()) {
                                            int n;
                                            if ((long)read <= remainderBytes) {
                                                n = read;
                                            } else {
                                                read = -1;
                                                n = (int)remainderBytes;
                                            }
                                            streamBytes.element = n;
                                            longRef2.element = this.$fileSlice.getStartBytes() + this.$fileSlice.getDownloaded();
                                            Object object = ParallelFileDownloaderImpl.access$getLock$p(this.this$0);
                                            synchronized (object) {
                                                if (!this.this$0.getInterrupted() && !this.this$0.getTerminated()) {
                                                    OutputResourceWrapper outputResourceWrapper = ParallelFileDownloaderImpl.access$getOutputResourceWrapper$p(this.this$0);
                                                    if (outputResourceWrapper != null) {
                                                        outputResourceWrapper.setWriteOffset(longRef2.element);
                                                    }
                                                    OutputResourceWrapper outputResourceWrapper2 = ParallelFileDownloaderImpl.access$getOutputResourceWrapper$p(this.this$0);
                                                    if (outputResourceWrapper2 != null) {
                                                        outputResourceWrapper2.write(buffer, 0, streamBytes.element);
                                                    }
                                                    if (!this.this$0.getInterrupted() && !this.this$0.getTerminated()) {
                                                        FileSlice fileSlice = this.$fileSlice;
                                                        fileSlice.setDownloaded(fileSlice.getDownloaded() + (long)streamBytes.element);
                                                        FetchUtils.saveDownloadedInfo(this.$fileSlice.getId(), this.$fileSlice.getPosition(), this.$fileSlice.getDownloaded(), ParallelFileDownloaderImpl.access$getFileTempDir$p(this.this$0));
                                                        ParallelFileDownloaderImpl parallelFileDownloaderImpl = this.this$0;
                                                        ParallelFileDownloaderImpl.access$setDownloaded$p(parallelFileDownloaderImpl, ParallelFileDownloaderImpl.access$getDownloaded$p(parallelFileDownloaderImpl) + (long)streamBytes.element);
                                                    }
                                                    longRef.element = System.nanoTime();
                                                    boolean hasReportingTimeElapsed = FetchCoreUtils.hasIntervalTimeElapsed((long)reportingStartTime, (long)longRef.element, (long)ParallelFileDownloaderImpl.access$getProgressReportingIntervalMillis$p(this.this$0));
                                                    if (hasReportingTimeElapsed) {
                                                        if (!this.this$0.getInterrupted() && !this.this$0.getTerminated()) {
                                                            downloadBlock2.setDownloadedBytes(this.$fileSlice.getDownloaded());
                                                            FileDownloader.Delegate delegate = this.this$0.getDelegate();
                                                            if (delegate != null) {
                                                                delegate.onDownloadBlockUpdated(ParallelFileDownloaderImpl.access$getDownloadInfo$p(this.this$0), (DownloadBlock)downloadBlock2, ParallelFileDownloaderImpl.access$getTotalDownloadBlocks$p(this.this$0));
                                                            }
                                                        }
                                                        reportingStartTime = System.nanoTime();
                                                    }
                                                }
                                                Unit unit = Unit.INSTANCE;
                                            }
                                            if (this.this$0.getInterrupted() || this.this$0.getTerminated() || read == -1) continue;
                                            InputStream inputStream2 = downloadResponse.getByteStream();
                                            read = inputStream2 != null ? inputStream2.read(buffer, 0, bufferSize) : -1;
                                            remainderBytes = this.$fileSlice.getEndBytes() - (this.$fileSlice.getStartBytes() + this.$fileSlice.getDownloaded());
                                        }
                                        break block34;
                                    }
                                }
                            }
                            if (downloadResponse == null && !this.this$0.getInterrupted() && !this.this$0.getTerminated()) {
                                throw (Throwable)new FetchException("empty_response_body");
                            }
                            Downloader.Response response3 = downloadResponse;
                            if (response3 != null) {
                                if (!response3.isSuccessful()) {
                                    if (!this.this$0.getInterrupted() && !this.this$0.getTerminated()) {
                                        throw (Throwable)new FetchException("request_not_successful");
                                    }
                                }
                            }
                            if (!this.this$0.getInterrupted() && !this.this$0.getTerminated()) {
                                throw (Throwable)new FetchException("unknown");
                            }
                        }
                        catch (Exception e) {
                            ParallelFileDownloaderImpl.access$setThrowable$p(this.this$0, e);
                        }
                        finally {
                            try {
                                if (downloadResponse != null) {
                                    ParallelFileDownloaderImpl.access$getDownloader$p(this.this$0).disconnect(downloadResponse);
                                }
                            }
                            catch (Exception e) {
                                ParallelFileDownloaderImpl.access$getLogger$p(this.this$0).e("FileDownloader", (Throwable)e);
                            }
                            ParallelFileDownloaderImpl.access$incrementActionCompletedCount(this.this$0);
                        }
                    }
                }
                {
                    this.this$0 = parallelFileDownloaderImpl;
                    this.$fileSlice = fileSlice;
                }
            });
        }
    }

    private final void deleteAllTempFiles() {
        try {
            for (FileSlice fileSlice : this.fileSlices) {
                FetchUtils.deleteTempFile(fileSlice.getId(), fileSlice.getPosition(), this.fileTempDir);
            }
            FetchUtils.deleteMetaFile(this.downloadInfo.getId(), this.fileTempDir);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void incrementActionCompletedCount() {
        Object object = this.lock;
        synchronized (object) {
            ++this.actionsCounter;
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void throwExceptionIfFound() {
        Throwable exception = this.throwable;
        if (exception != null) {
            throw exception;
        }
    }

    public ParallelFileDownloaderImpl(@NotNull Download initialDownload, @NotNull Downloader downloader, long progressReportingIntervalMillis, @NotNull Logger logger, @NotNull NetworkInfoProvider networkInfoProvider, boolean retryOnNetworkGain, @NotNull String fileTempDir, boolean md5CheckingEnabled) {
        Intrinsics.checkParameterIsNotNull((Object)initialDownload, (String)"initialDownload");
        Intrinsics.checkParameterIsNotNull((Object)downloader, (String)"downloader");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        Intrinsics.checkParameterIsNotNull((Object)networkInfoProvider, (String)"networkInfoProvider");
        Intrinsics.checkParameterIsNotNull((Object)fileTempDir, (String)"fileTempDir");
        this.initialDownload = initialDownload;
        this.downloader = downloader;
        this.progressReportingIntervalMillis = progressReportingIntervalMillis;
        this.logger = logger;
        this.networkInfoProvider = networkInfoProvider;
        this.retryOnNetworkGain = retryOnNetworkGain;
        this.fileTempDir = fileTempDir;
        this.md5CheckingEnabled = md5CheckingEnabled;
        this.downloadInfo = FetchTypeConverterExtensions.toDownloadInfo(this.initialDownload);
        this.total = -1L;
        this.movingAverageCalculator = new AverageCalculator(5);
        this.estimatedTimeRemainingInMilliseconds = -1L;
        this.lock = new Object();
        this.fileSlices = CollectionsKt.emptyList();
        this.interruptMonitor = new InterruptMonitor(this){
            final /* synthetic */ ParallelFileDownloaderImpl this$0;

            public boolean isInterrupted() {
                return this.this$0.getInterrupted();
            }
            {
                this.this$0 = $outer;
            }
        };
    }

    @NotNull
    public static final /* synthetic */ DownloadInfo access$getDownloadInfo$p(ParallelFileDownloaderImpl $this) {
        return $this.downloadInfo;
    }

    @NotNull
    public static final /* synthetic */ Downloader access$getDownloader$p(ParallelFileDownloaderImpl $this) {
        return $this.downloader;
    }

    @NotNull
    public static final /* synthetic */ interruptMonitor.1 access$getInterruptMonitor$p(ParallelFileDownloaderImpl $this) {
        return $this.interruptMonitor;
    }

    @NotNull
    public static final /* synthetic */ Object access$getLock$p(ParallelFileDownloaderImpl $this) {
        return $this.lock;
    }

    @Nullable
    public static final /* synthetic */ OutputResourceWrapper access$getOutputResourceWrapper$p(ParallelFileDownloaderImpl $this) {
        return $this.outputResourceWrapper;
    }

    public static final /* synthetic */ void access$setOutputResourceWrapper$p(ParallelFileDownloaderImpl $this, @Nullable OutputResourceWrapper outputResourceWrapper) {
        $this.outputResourceWrapper = outputResourceWrapper;
    }

    @NotNull
    public static final /* synthetic */ String access$getFileTempDir$p(ParallelFileDownloaderImpl $this) {
        return $this.fileTempDir;
    }

    public static final /* synthetic */ long access$getDownloaded$p(ParallelFileDownloaderImpl $this) {
        return $this.downloaded;
    }

    public static final /* synthetic */ void access$setDownloaded$p(ParallelFileDownloaderImpl $this, long l) {
        $this.downloaded = l;
    }

    public static final /* synthetic */ long access$getProgressReportingIntervalMillis$p(ParallelFileDownloaderImpl $this) {
        return $this.progressReportingIntervalMillis;
    }

    public static final /* synthetic */ int access$getTotalDownloadBlocks$p(ParallelFileDownloaderImpl $this) {
        return $this.totalDownloadBlocks;
    }

    public static final /* synthetic */ void access$setTotalDownloadBlocks$p(ParallelFileDownloaderImpl $this, int n) {
        $this.totalDownloadBlocks = n;
    }

    @NotNull
    public static final /* synthetic */ Logger access$getLogger$p(ParallelFileDownloaderImpl $this) {
        return $this.logger;
    }

    public static final /* synthetic */ void access$incrementActionCompletedCount(ParallelFileDownloaderImpl $this) {
        $this.incrementActionCompletedCount();
    }

    @Nullable
    public static final /* synthetic */ Throwable access$getThrowable$p(ParallelFileDownloaderImpl $this) {
        return $this.throwable;
    }

    public static final /* synthetic */ void access$setThrowable$p(ParallelFileDownloaderImpl $this, @Nullable Throwable throwable) {
        $this.throwable = throwable;
    }
}

