/*
 * Decompiled with CFR 0.152.
 */
package com.tonyodev.fetch2.provider;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import com.tonyodev.fetch2.NetworkType;
import com.tonyodev.fetch2core.FetchAndroidExtensions;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0007J\u0006\u0010\u0012\u001a\u00020\u0010J\u000e\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0007R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\nR\u000e\u0010\u000b\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/tonyodev/fetch2/provider/NetworkInfoProvider;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "broadcastReceiverSet", "", "Landroid/content/BroadcastReceiver;", "isNetworkAvailable", "", "()Z", "lock", "isOnAllowedNetwork", "networkType", "Lcom/tonyodev/fetch2/NetworkType;", "registerNetworkBroadcastReceiver", "", "broadcastReceiver", "unregisterAllNetworkBroadcastReceivers", "unregisterNetworkBroadcastReceiver", "fetch2_release"})
public final class NetworkInfoProvider {
    private final Object lock;
    private final Set<BroadcastReceiver> broadcastReceiverSet;
    private final Context context;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void registerNetworkBroadcastReceiver(@NotNull BroadcastReceiver broadcastReceiver) {
        Intrinsics.checkParameterIsNotNull((Object)broadcastReceiver, (String)"broadcastReceiver");
        Object object = this.lock;
        synchronized (object) {
            Unit unit;
            IntentFilter intentFilter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
            try {
                this.broadcastReceiverSet.add(broadcastReceiver);
                unit = this.context.registerReceiver(broadcastReceiver, intentFilter);
            }
            catch (Exception e) {
                unit = Unit.INSTANCE;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unregisterNetworkBroadcastReceiver(@NotNull BroadcastReceiver broadcastReceiver) {
        Intrinsics.checkParameterIsNotNull((Object)broadcastReceiver, (String)"broadcastReceiver");
        Object object = this.lock;
        synchronized (object) {
            try {
                this.broadcastReceiverSet.remove(broadcastReceiver);
                this.context.unregisterReceiver(broadcastReceiver);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unregisterAllNetworkBroadcastReceivers() {
        Object object = this.lock;
        synchronized (object) {
            List broadcastReceivers = CollectionsKt.toList((Iterable)this.broadcastReceiverSet);
            Iterable $receiver$iv = broadcastReceivers;
            for (Object element$iv : $receiver$iv) {
                BroadcastReceiver broadcastReceiver = (BroadcastReceiver)element$iv;
                try {
                    this.broadcastReceiverSet.remove(broadcastReceiver);
                    this.context.unregisterReceiver(broadcastReceiver);
                }
                catch (Exception exception) {
                }
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    public final boolean isOnAllowedNetwork(@NotNull NetworkType networkType) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)networkType), (String)"networkType");
        if (networkType == NetworkType.WIFI_ONLY && FetchAndroidExtensions.isOnWiFi((Context)this.context)) {
            return true;
        }
        return networkType == NetworkType.ALL && FetchAndroidExtensions.isNetworkAvailable((Context)this.context);
    }

    public final boolean isNetworkAvailable() {
        return FetchAndroidExtensions.isNetworkAvailable((Context)this.context);
    }

    public NetworkInfoProvider(@NotNull Context context) {
        Set set;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
        this.lock = new Object();
        NetworkInfoProvider networkInfoProvider = this;
        networkInfoProvider.broadcastReceiverSet = set = (Set)new LinkedHashSet();
    }
}

