/*
 * Decompiled with CFR 0.152.
 */
package com.tonyodev.fetch2.downloader;

import com.tonyodev.fetch2.Download;
import com.tonyodev.fetch2.Error;
import com.tonyodev.fetch2.FetchErrorUtils;
import com.tonyodev.fetch2.database.DownloadInfo;
import com.tonyodev.fetch2.downloader.FileDownloader;
import com.tonyodev.fetch2.downloader.SequentialFileDownloaderImpl;
import com.tonyodev.fetch2.exception.FetchException;
import com.tonyodev.fetch2.helper.FileDownloaderDelegate;
import com.tonyodev.fetch2.provider.NetworkInfoProvider;
import com.tonyodev.fetch2.util.FetchTypeConverterExtensions;
import com.tonyodev.fetch2core.AverageCalculator;
import com.tonyodev.fetch2core.DownloadBlock;
import com.tonyodev.fetch2core.DownloadBlockInfo;
import com.tonyodev.fetch2core.Downloader;
import com.tonyodev.fetch2core.FetchCoreUtils;
import com.tonyodev.fetch2core.InterruptMonitor;
import com.tonyodev.fetch2core.Logger;
import com.tonyodev.fetch2core.OutputResourceWrapper;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.RandomAccessFile;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u008d\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0001'\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000fJ\b\u00105\u001a\u00020\u0007H\u0002J\b\u00106\u001a\u000207H\u0002J\b\u00108\u001a\u000209H\u0002J\b\u0010:\u001a\u00020;H\u0016J*\u0010<\u001a\u00020;2\u0006\u0010=\u001a\u00020>2\b\u0010?\u001a\u0004\u0018\u00010@2\u0006\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u000204H\u0002R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0012\u001a\u00020\r8\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010$\u001a\u00020\u00078\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010(R&\u0010*\u001a\u00020\r2\u0006\u0010)\u001a\u00020\r8\u0016@VX\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010\u0014\"\u0004\b,\u0010\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010/\u001a\u00020\r2\u0006\u0010)\u001a\u00020\r8\u0016@VX\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u0010\u0014\"\u0004\b1\u0010\u0016R\u0012\u00102\u001a\u00020\u00078\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u000204X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006D"}, d2={"Lcom/tonyodev/fetch2/downloader/SequentialFileDownloaderImpl;", "Lcom/tonyodev/fetch2/downloader/FileDownloader;", "initialDownload", "Lcom/tonyodev/fetch2/Download;", "downloader", "Lcom/tonyodev/fetch2core/Downloader;", "progressReportingIntervalMillis", "", "logger", "Lcom/tonyodev/fetch2core/Logger;", "networkInfoProvider", "Lcom/tonyodev/fetch2/provider/NetworkInfoProvider;", "retryOnNetworkGain", "", "md5CheckingEnabled", "(Lcom/tonyodev/fetch2/Download;Lcom/tonyodev/fetch2core/Downloader;JLcom/tonyodev/fetch2core/Logger;Lcom/tonyodev/fetch2/provider/NetworkInfoProvider;ZZ)V", "averageDownloadedBytesPerSecond", "", "completedDownload", "getCompletedDownload", "()Z", "setCompletedDownload", "(Z)V", "delegate", "Lcom/tonyodev/fetch2/downloader/FileDownloader$Delegate;", "getDelegate", "()Lcom/tonyodev/fetch2/downloader/FileDownloader$Delegate;", "setDelegate", "(Lcom/tonyodev/fetch2/downloader/FileDownloader$Delegate;)V", "download", "getDownload", "()Lcom/tonyodev/fetch2/Download;", "downloadBlock", "Lcom/tonyodev/fetch2core/DownloadBlockInfo;", "downloadInfo", "Lcom/tonyodev/fetch2/database/DownloadInfo;", "downloaded", "estimatedTimeRemainingInMilliseconds", "interruptMonitor", "com/tonyodev/fetch2/downloader/SequentialFileDownloaderImpl$interruptMonitor$1", "Lcom/tonyodev/fetch2/downloader/SequentialFileDownloaderImpl$interruptMonitor$1;", "value", "interrupted", "getInterrupted", "setInterrupted", "movingAverageCalculator", "Lcom/tonyodev/fetch2core/AverageCalculator;", "terminated", "getTerminated", "setTerminated", "total", "totalDownloadBlocks", "", "getAverageDownloadedBytesPerSecond", "getFile", "Ljava/io/File;", "getRequest", "Lcom/tonyodev/fetch2core/Downloader$ServerRequest;", "run", "", "writeToOutput", "input", "Ljava/io/BufferedInputStream;", "outputResourceWrapper", "Lcom/tonyodev/fetch2core/OutputResourceWrapper;", "response", "Lcom/tonyodev/fetch2core/Downloader$Response;", "bufferSize", "fetch2_release"})
public final class SequentialFileDownloaderImpl
implements FileDownloader {
    private volatile boolean interrupted;
    private volatile boolean terminated;
    private volatile boolean completedDownload;
    @Nullable
    private FileDownloader.Delegate delegate;
    private volatile long total;
    private volatile long downloaded;
    private long estimatedTimeRemainingInMilliseconds;
    private final DownloadInfo downloadInfo;
    private double averageDownloadedBytesPerSecond;
    private final AverageCalculator movingAverageCalculator;
    private final DownloadBlockInfo downloadBlock;
    private final int totalDownloadBlocks = 1;
    private final interruptMonitor.1 interruptMonitor;
    private final Download initialDownload;
    private final Downloader downloader;
    private final long progressReportingIntervalMillis;
    private final Logger logger;
    private final NetworkInfoProvider networkInfoProvider;
    private final boolean retryOnNetworkGain;
    private final boolean md5CheckingEnabled;

    @Override
    public boolean getInterrupted() {
        return this.interrupted;
    }

    @Override
    public void setInterrupted(boolean value) {
        FileDownloader.Delegate delegate = this.getDelegate();
        if (!(delegate instanceof FileDownloaderDelegate)) {
            delegate = null;
        }
        FileDownloaderDelegate fileDownloaderDelegate = (FileDownloaderDelegate)delegate;
        if (fileDownloaderDelegate != null) {
            fileDownloaderDelegate.setInterrupted(value);
        }
        this.interrupted = value;
    }

    @Override
    public boolean getTerminated() {
        return this.terminated;
    }

    @Override
    public void setTerminated(boolean value) {
        FileDownloader.Delegate delegate = this.getDelegate();
        if (!(delegate instanceof FileDownloaderDelegate)) {
            delegate = null;
        }
        FileDownloaderDelegate fileDownloaderDelegate = (FileDownloaderDelegate)delegate;
        if (fileDownloaderDelegate != null) {
            fileDownloaderDelegate.setInterrupted(value);
        }
        this.terminated = value;
    }

    @Override
    public boolean getCompletedDownload() {
        return this.completedDownload;
    }

    public void setCompletedDownload(boolean bl) {
        this.completedDownload = bl;
    }

    @Override
    @Nullable
    public FileDownloader.Delegate getDelegate() {
        return this.delegate;
    }

    @Override
    public void setDelegate(@Nullable FileDownloader.Delegate delegate) {
        this.delegate = delegate;
    }

    @Override
    @NotNull
    public Download getDownload() {
        this.downloadInfo.setDownloaded(this.downloaded);
        this.downloadInfo.setTotal(this.total);
        return this.downloadInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void run() {
        block50: {
            OutputResourceWrapper outputResourceWrapper = null;
            BufferedInputStream input = null;
            Downloader.Response response2 = null;
            try {
                File file = this.getFile();
                this.downloaded = this.initialDownload.getDownloaded();
                if (!this.getInterrupted() && !this.getTerminated()) {
                    boolean isResponseSuccessful;
                    Downloader.ServerRequest request = this.getRequest();
                    Downloader.Response response3 = response2 = this.downloader.execute(request, (InterruptMonitor)this.interruptMonitor);
                    boolean bl = isResponseSuccessful = response3 != null ? response3.isSuccessful() : false;
                    if (!this.getInterrupted() && !this.getTerminated() && response2 != null && isResponseSuccessful) {
                        long l;
                        this.downloaded = response2.getCode() == 206 || response2.getAcceptsRanges() ? this.initialDownload.getDownloaded() : 0L;
                        long l2 = this.total = response2.getContentLength() == -1L ? -1L : this.downloaded + response2.getContentLength();
                        if (response2.getCode() == 206) {
                            this.logger.d("FileDownloader resuming Download " + this.getDownload());
                            l = this.downloaded;
                        } else {
                            this.logger.d("FileDownloader starting Download " + this.getDownload());
                            l = 0L;
                        }
                        long seekPosition = l;
                        outputResourceWrapper = this.downloader.getRequestOutputResourceWrapper(request);
                        if (outputResourceWrapper == null) {
                            outputResourceWrapper = new OutputResourceWrapper(file, seekPosition){
                                private final RandomAccessFile randomAccessFile;
                                final /* synthetic */ File $file;
                                final /* synthetic */ long $seekPosition;

                                public void write(@NotNull byte[] byteArray, int offSet, int length) {
                                    Intrinsics.checkParameterIsNotNull((Object)byteArray, (String)"byteArray");
                                    this.randomAccessFile.write(byteArray, offSet, length);
                                }

                                public void setWriteOffset(long offset) {
                                    this.randomAccessFile.seek(offset);
                                }

                                public void flush() {
                                }

                                public void close() {
                                    this.randomAccessFile.close();
                                }
                                {
                                    this.$file = $captured_local_variable$0;
                                    this.$seekPosition = $captured_local_variable$1;
                                    this.randomAccessFile = new RandomAccessFile($captured_local_variable$0, "rw");
                                    this.randomAccessFile.seek($captured_local_variable$1);
                                }
                            };
                        }
                        outputResourceWrapper.setWriteOffset(seekPosition);
                        if (!this.getInterrupted() && !this.getTerminated()) {
                            int bufferSize = this.downloader.getRequestBufferSize(request);
                            input = new BufferedInputStream(response2.getByteStream(), bufferSize);
                            this.downloadInfo.setDownloaded(this.downloaded);
                            this.downloadInfo.setTotal(this.total);
                            this.downloadBlock.setDownloadedBytes(this.downloaded);
                            this.downloadBlock.setStartByte(seekPosition);
                            this.downloadBlock.setEndByte(this.total);
                            if (!this.getTerminated() && !this.getInterrupted()) {
                                FileDownloader.Delegate delegate = this.getDelegate();
                                if (delegate != null) {
                                    delegate.onStarted(this.downloadInfo, CollectionsKt.listOf((Object)this.downloadBlock), this.totalDownloadBlocks);
                                }
                                FileDownloader.Delegate delegate2 = this.getDelegate();
                                if (delegate2 != null) {
                                    delegate2.onDownloadBlockUpdated(this.downloadInfo, (DownloadBlock)this.downloadBlock, this.totalDownloadBlocks);
                                }
                            }
                            this.writeToOutput(input, outputResourceWrapper, response2, bufferSize);
                        }
                    } else {
                        if (response2 == null && !this.getInterrupted() && !this.getTerminated()) {
                            throw (Throwable)new FetchException("empty_response_body");
                        }
                        if (!(isResponseSuccessful || this.getInterrupted() || this.getTerminated())) {
                            throw (Throwable)new FetchException("request_not_successful");
                        }
                        if (!this.getInterrupted() && !this.getTerminated()) {
                            throw (Throwable)new FetchException("unknown");
                        }
                    }
                }
                if (!(this.getCompletedDownload() || this.getTerminated() || this.getInterrupted())) {
                    this.downloadInfo.setDownloaded(this.downloaded);
                    this.downloadInfo.setTotal(this.total);
                    this.downloadBlock.setDownloadedBytes(this.downloaded);
                    this.downloadBlock.setEndByte(this.total);
                    FileDownloader.Delegate delegate = this.getDelegate();
                    if (delegate != null) {
                        delegate.saveDownloadProgress(this.downloadInfo);
                    }
                    FileDownloader.Delegate delegate3 = this.getDelegate();
                    if (delegate3 != null) {
                        delegate3.onDownloadBlockUpdated(this.downloadInfo, (DownloadBlock)this.downloadBlock, this.totalDownloadBlocks);
                    }
                    FileDownloader.Delegate delegate4 = this.getDelegate();
                    if (delegate4 != null) {
                        delegate4.onProgress(this.downloadInfo, this.estimatedTimeRemainingInMilliseconds, this.getAverageDownloadedBytesPerSecond());
                    }
                }
            }
            catch (Exception e) {
                if (this.getInterrupted() || this.getTerminated()) break block50;
                this.logger.e("FileDownloader download:" + this.getDownload(), (Throwable)e);
                Error error = FetchErrorUtils.getErrorFromThrowable(e);
                error.setThrowable(e);
                if (this.retryOnNetworkGain) {
                    boolean disconnectDetected = !this.networkInfoProvider.isNetworkAvailable();
                    int seekPosition = 1;
                    int n = 10;
                    while (seekPosition <= n) {
                        void i;
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException e2) {
                            this.logger.e("FileDownloader", (Throwable)e2);
                            break;
                        }
                        if (!this.networkInfoProvider.isNetworkAvailable()) {
                            disconnectDetected = true;
                            break;
                        }
                        ++i;
                    }
                    if (disconnectDetected) {
                        error = Error.NO_NETWORK_CONNECTION;
                    }
                }
                this.downloadInfo.setDownloaded(this.downloaded);
                this.downloadInfo.setTotal(this.total);
                this.downloadInfo.setError(error);
                this.downloadBlock.setDownloadedBytes(this.downloaded);
                this.downloadBlock.setEndByte(this.total);
                FileDownloader.Delegate delegate = this.getDelegate();
                if (delegate != null) {
                    delegate.onError(this.downloadInfo, error, e);
                }
            }
            finally {
                try {
                    BufferedInputStream bufferedInputStream = input;
                    if (bufferedInputStream != null) {
                        bufferedInputStream.close();
                    }
                }
                catch (Exception e) {
                    this.logger.e("FileDownloader", (Throwable)e);
                }
                if (response2 != null) {
                    try {
                        this.downloader.disconnect(response2);
                    }
                    catch (Exception e) {
                        this.logger.e("FileDownloader", (Throwable)e);
                    }
                }
                try {
                    OutputResourceWrapper outputResourceWrapper2 = outputResourceWrapper;
                    if (outputResourceWrapper2 != null) {
                        outputResourceWrapper2.close();
                    }
                }
                catch (Exception e) {
                    this.logger.e("FileDownloader", (Throwable)e);
                }
                this.setTerminated(true);
            }
        }
    }

    private final void writeToOutput(BufferedInputStream input, OutputResourceWrapper outputResourceWrapper, Downloader.Response response2, int bufferSize) {
        block17: {
            block18: {
                block19: {
                    long downloadedBytesPerSecond = this.downloaded;
                    byte[] buffer = new byte[bufferSize];
                    long reportingStartTime = System.nanoTime();
                    long downloadSpeedStartTime = System.nanoTime();
                    int read = input.read(buffer, 0, bufferSize);
                    while (!this.getInterrupted() && !this.getTerminated() && read != -1) {
                        long reportingStopTime;
                        boolean hasReportingTimeElapsed;
                        OutputResourceWrapper outputResourceWrapper2 = outputResourceWrapper;
                        if (outputResourceWrapper2 != null) {
                            outputResourceWrapper2.write(buffer, 0, read);
                        }
                        if (this.getTerminated() || this.getInterrupted()) continue;
                        this.downloaded += (long)read;
                        this.downloadInfo.setDownloaded(this.downloaded);
                        this.downloadInfo.setTotal(this.total);
                        this.downloadBlock.setDownloadedBytes(this.downloaded);
                        this.downloadBlock.setEndByte(this.total);
                        long downloadSpeedStopTime = System.nanoTime();
                        boolean downloadSpeedCheckTimeElapsed = FetchCoreUtils.hasIntervalTimeElapsed((long)downloadSpeedStartTime, (long)downloadSpeedStopTime, (long)1000L);
                        if (downloadSpeedCheckTimeElapsed) {
                            downloadedBytesPerSecond = this.downloaded - downloadedBytesPerSecond;
                            this.movingAverageCalculator.add((double)downloadedBytesPerSecond);
                            this.averageDownloadedBytesPerSecond = AverageCalculator.getMovingAverageWithWeightOnRecentValues$default((AverageCalculator)this.movingAverageCalculator, (int)0, (int)1, null);
                            this.estimatedTimeRemainingInMilliseconds = FetchCoreUtils.calculateEstimatedTimeRemainingInMilliseconds((long)this.downloaded, (long)this.total, (long)this.getAverageDownloadedBytesPerSecond());
                            downloadedBytesPerSecond = this.downloaded;
                        }
                        if (hasReportingTimeElapsed = FetchCoreUtils.hasIntervalTimeElapsed((long)reportingStartTime, (long)(reportingStopTime = System.nanoTime()), (long)this.progressReportingIntervalMillis)) {
                            if (!this.getTerminated() && !this.getInterrupted()) {
                                this.downloadBlock.setDownloadedBytes(this.downloaded);
                                FileDownloader.Delegate delegate = this.getDelegate();
                                if (delegate != null) {
                                    delegate.saveDownloadProgress(this.downloadInfo);
                                }
                                FileDownloader.Delegate delegate2 = this.getDelegate();
                                if (delegate2 != null) {
                                    delegate2.onDownloadBlockUpdated(this.downloadInfo, (DownloadBlock)this.downloadBlock, this.totalDownloadBlocks);
                                }
                                FileDownloader.Delegate delegate3 = this.getDelegate();
                                if (delegate3 != null) {
                                    delegate3.onProgress(this.downloadInfo, this.estimatedTimeRemainingInMilliseconds, this.getAverageDownloadedBytesPerSecond());
                                }
                            }
                            reportingStartTime = System.nanoTime();
                        }
                        if (downloadSpeedCheckTimeElapsed) {
                            downloadSpeedStartTime = System.nanoTime();
                        }
                        read = input.read(buffer, 0, bufferSize);
                    }
                    OutputResourceWrapper outputResourceWrapper3 = outputResourceWrapper;
                    if (outputResourceWrapper3 != null) {
                        outputResourceWrapper3.flush();
                    }
                    if (read != -1 || this.getInterrupted() || this.getTerminated()) break block17;
                    this.total = this.downloaded;
                    this.setCompletedDownload(true);
                    this.downloadInfo.setDownloaded(this.downloaded);
                    this.downloadInfo.setTotal(this.total);
                    this.downloadBlock.setDownloadedBytes(this.downloaded);
                    this.downloadBlock.setEndByte(this.total);
                    if (this.getTerminated() || this.getInterrupted()) break block17;
                    if (!this.md5CheckingEnabled) break block18;
                    if (!this.downloader.verifyContentMD5(response2.getRequest(), response2.getMd5())) break block19;
                    if (this.getTerminated() || this.getInterrupted()) break block17;
                    FileDownloader.Delegate delegate = this.getDelegate();
                    if (delegate != null) {
                        delegate.saveDownloadProgress(this.downloadInfo);
                    }
                    FileDownloader.Delegate delegate4 = this.getDelegate();
                    if (delegate4 != null) {
                        delegate4.onDownloadBlockUpdated(this.downloadInfo, (DownloadBlock)this.downloadBlock, this.totalDownloadBlocks);
                    }
                    FileDownloader.Delegate delegate5 = this.getDelegate();
                    if (delegate5 != null) {
                        delegate5.onProgress(this.downloadInfo, this.estimatedTimeRemainingInMilliseconds, this.getAverageDownloadedBytesPerSecond());
                    }
                    FileDownloader.Delegate delegate6 = this.getDelegate();
                    if (delegate6 != null) {
                        delegate6.onComplete(this.downloadInfo);
                    }
                    break block17;
                }
                throw (Throwable)new FetchException("invalid content md5");
            }
            FileDownloader.Delegate delegate = this.getDelegate();
            if (delegate != null) {
                delegate.saveDownloadProgress(this.downloadInfo);
            }
            FileDownloader.Delegate delegate7 = this.getDelegate();
            if (delegate7 != null) {
                delegate7.onDownloadBlockUpdated(this.downloadInfo, (DownloadBlock)this.downloadBlock, this.totalDownloadBlocks);
            }
            FileDownloader.Delegate delegate8 = this.getDelegate();
            if (delegate8 != null) {
                delegate8.onProgress(this.downloadInfo, this.estimatedTimeRemainingInMilliseconds, this.getAverageDownloadedBytesPerSecond());
            }
            FileDownloader.Delegate delegate9 = this.getDelegate();
            if (delegate9 == null) break block17;
            delegate9.onComplete(this.downloadInfo);
        }
    }

    private final File getFile() {
        File file = new File(this.initialDownload.getFile());
        if (!file.exists()) {
            if (file.getParentFile() != null && !file.getParentFile().exists()) {
                if (file.getParentFile().mkdirs()) {
                    file.createNewFile();
                    this.logger.d("FileDownloader download file " + file.getAbsolutePath() + " created");
                }
            } else {
                file.createNewFile();
                this.logger.d("FileDownloader download file " + file.getAbsolutePath() + " created");
            }
        }
        return file;
    }

    private final Downloader.ServerRequest getRequest() {
        Map headers;
        Map map = headers = MapsKt.toMutableMap(this.initialDownload.getHeaders());
        String string = "Range";
        String string2 = "bytes=" + this.downloaded + '-';
        map.put(string, string2);
        return new Downloader.ServerRequest(this.initialDownload.getId(), this.initialDownload.getUrl(), headers, this.initialDownload.getFile(), this.initialDownload.getTag(), this.initialDownload.getIdentifier(), "GET", this.initialDownload.getExtras());
    }

    private final long getAverageDownloadedBytesPerSecond() {
        if (this.averageDownloadedBytesPerSecond < 1.0) {
            return 0L;
        }
        double d = this.averageDownloadedBytesPerSecond;
        return (long)Math.ceil(d);
    }

    public SequentialFileDownloaderImpl(@NotNull Download initialDownload, @NotNull Downloader downloader, long progressReportingIntervalMillis, @NotNull Logger logger, @NotNull NetworkInfoProvider networkInfoProvider, boolean retryOnNetworkGain, boolean md5CheckingEnabled) {
        Intrinsics.checkParameterIsNotNull((Object)initialDownload, (String)"initialDownload");
        Intrinsics.checkParameterIsNotNull((Object)downloader, (String)"downloader");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        Intrinsics.checkParameterIsNotNull((Object)networkInfoProvider, (String)"networkInfoProvider");
        this.initialDownload = initialDownload;
        this.downloader = downloader;
        this.progressReportingIntervalMillis = progressReportingIntervalMillis;
        this.logger = logger;
        this.networkInfoProvider = networkInfoProvider;
        this.retryOnNetworkGain = retryOnNetworkGain;
        this.md5CheckingEnabled = md5CheckingEnabled;
        this.total = -1L;
        this.estimatedTimeRemainingInMilliseconds = -1L;
        this.downloadInfo = FetchTypeConverterExtensions.toDownloadInfo(this.initialDownload);
        this.movingAverageCalculator = new AverageCalculator(5);
        this.downloadBlock = (DownloadBlockInfo)((Function0)new Function0<DownloadBlockInfo>(this){
            final /* synthetic */ SequentialFileDownloaderImpl this$0;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final DownloadBlockInfo invoke() {
                void var1_1;
                DownloadBlockInfo downloadBlock2 = new DownloadBlockInfo();
                downloadBlock2.setBlockPosition(1);
                downloadBlock2.setDownloadId(SequentialFileDownloaderImpl.access$getInitialDownload$p(this.this$0).getId());
                return var1_1;
            }
            {
                this.this$0 = sequentialFileDownloaderImpl;
                super(0);
            }
        }).invoke();
        this.totalDownloadBlocks = 1;
        this.interruptMonitor = new InterruptMonitor(this){
            final /* synthetic */ SequentialFileDownloaderImpl this$0;

            public boolean isInterrupted() {
                return this.this$0.getInterrupted();
            }
            {
                this.this$0 = $outer;
            }
        };
    }

    @NotNull
    public static final /* synthetic */ Download access$getInitialDownload$p(SequentialFileDownloaderImpl $this) {
        return $this.initialDownload;
    }
}

