/*
 * Decompiled with CFR 0.152.
 */
package com.tonyodev.fetch2.helper;

import com.tonyodev.fetch2.Download;
import com.tonyodev.fetch2.NetworkType;
import com.tonyodev.fetch2.downloader.DownloadManager;
import com.tonyodev.fetch2.fetch.ListenerCoordinator;
import com.tonyodev.fetch2.helper.PriorityListProcessor;
import com.tonyodev.fetch2.provider.DownloadProvider;
import com.tonyodev.fetch2.provider.NetworkInfoProvider;
import com.tonyodev.fetch2core.FetchCoreUtils;
import com.tonyodev.fetch2core.HandlerWrapper;
import com.tonyodev.fetch2core.Logger;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B=\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\b\u0010,\u001a\u00020#H\u0002J\u000e\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00020.H\u0016J\b\u0010/\u001a\u000200H\u0016J\b\u00101\u001a\u000200H\u0002J\b\u00102\u001a\u000200H\u0016J\b\u00103\u001a\u000200H\u0016J\b\u00104\u001a\u000200H\u0016J\b\u00105\u001a\u000200H\u0002R\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001e\u0010\u000f\u001a\u00020\u00108\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001c\u001a\u00020\u001d8\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\"\u001a\u00020#8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010$R\u0014\u0010%\u001a\u00020#8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010$R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010(\u001a\u00020#8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020*X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010+\u001a\u00020#8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lcom/tonyodev/fetch2/helper/PriorityListProcessorImpl;", "Lcom/tonyodev/fetch2/helper/PriorityListProcessor;", "Lcom/tonyodev/fetch2/Download;", "handlerWrapper", "Lcom/tonyodev/fetch2core/HandlerWrapper;", "downloadProvider", "Lcom/tonyodev/fetch2/provider/DownloadProvider;", "downloadManager", "Lcom/tonyodev/fetch2/downloader/DownloadManager;", "networkInfoProvider", "Lcom/tonyodev/fetch2/provider/NetworkInfoProvider;", "logger", "Lcom/tonyodev/fetch2core/Logger;", "listenerCoordinator", "Lcom/tonyodev/fetch2/fetch/ListenerCoordinator;", "downloadConcurrentLimit", "", "(Lcom/tonyodev/fetch2core/HandlerWrapper;Lcom/tonyodev/fetch2/provider/DownloadProvider;Lcom/tonyodev/fetch2/downloader/DownloadManager;Lcom/tonyodev/fetch2/provider/NetworkInfoProvider;Lcom/tonyodev/fetch2core/Logger;Lcom/tonyodev/fetch2/fetch/ListenerCoordinator;I)V", "delegate", "Lcom/tonyodev/fetch2/helper/PriorityListProcessor$Delegate;", "getDelegate", "()Lcom/tonyodev/fetch2/helper/PriorityListProcessor$Delegate;", "setDelegate", "(Lcom/tonyodev/fetch2/helper/PriorityListProcessor$Delegate;)V", "getDownloadConcurrentLimit", "()I", "setDownloadConcurrentLimit", "(I)V", "globalNetworkType", "Lcom/tonyodev/fetch2/NetworkType;", "getGlobalNetworkType", "()Lcom/tonyodev/fetch2/NetworkType;", "setGlobalNetworkType", "(Lcom/tonyodev/fetch2/NetworkType;)V", "isPaused", "", "()Z", "isStopped", "lock", "", "paused", "priorityIteratorRunnable", "Ljava/lang/Runnable;", "stopped", "canContinueToProcess", "getPriorityList", "", "pause", "", "registerPriorityIterator", "resume", "start", "stop", "unregisterPriorityIterator", "fetch2_release"})
public final class PriorityListProcessorImpl
implements PriorityListProcessor<Download> {
    private final Object lock;
    @Nullable
    private PriorityListProcessor.Delegate delegate;
    @NotNull
    private volatile NetworkType globalNetworkType;
    private volatile boolean paused;
    private volatile boolean stopped;
    private final Runnable priorityIteratorRunnable;
    private final HandlerWrapper handlerWrapper;
    private final DownloadProvider downloadProvider;
    private final DownloadManager downloadManager;
    private final NetworkInfoProvider networkInfoProvider;
    private final Logger logger;
    private final ListenerCoordinator listenerCoordinator;
    private volatile int downloadConcurrentLimit;

    @Override
    @Nullable
    public PriorityListProcessor.Delegate getDelegate() {
        return this.delegate;
    }

    @Override
    public void setDelegate(@Nullable PriorityListProcessor.Delegate delegate) {
        this.delegate = delegate;
    }

    @Override
    @NotNull
    public NetworkType getGlobalNetworkType() {
        return this.globalNetworkType;
    }

    @Override
    public void setGlobalNetworkType(@NotNull NetworkType networkType) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)networkType), (String)"<set-?>");
        this.globalNetworkType = networkType;
    }

    @Override
    public boolean isPaused() {
        return this.paused;
    }

    @Override
    public boolean isStopped() {
        return this.stopped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        Object object = this.lock;
        synchronized (object) {
            this.stopped = false;
            this.paused = false;
            PriorityListProcessor.Delegate delegate = this.getDelegate();
            if (delegate != null) {
                delegate.onHasActiveDownloads(true);
            }
            this.registerPriorityIterator();
            this.logger.d("PriorityIterator started");
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            this.unregisterPriorityIterator();
            PriorityListProcessor.Delegate delegate = this.getDelegate();
            if (delegate != null) {
                delegate.onHasActiveDownloads(false);
            }
            this.paused = false;
            this.stopped = true;
            this.downloadManager.cancelAll();
            this.logger.d("PriorityIterator stop");
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pause() {
        Object object = this.lock;
        synchronized (object) {
            this.unregisterPriorityIterator();
            this.paused = true;
            this.stopped = false;
            this.downloadManager.cancelAll();
            this.logger.d("PriorityIterator paused");
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resume() {
        Object object = this.lock;
        synchronized (object) {
            this.paused = false;
            this.stopped = false;
            this.registerPriorityIterator();
            this.logger.d("PriorityIterator resumed");
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<Download> getPriorityList() {
        Object object = this.lock;
        synchronized (object) {
            List list;
            try {
                list = this.downloadProvider.getPendingDownloadsSorted();
            }
            catch (Exception e) {
                this.logger.d("PriorityIterator failed access database", (Throwable)e);
                list = CollectionsKt.emptyList();
            }
            List list2 = list;
            return list2;
        }
    }

    private final void registerPriorityIterator() {
        if (this.getDownloadConcurrentLimit() > 0) {
            this.handlerWrapper.postDelayed(this.priorityIteratorRunnable, 500L);
        }
    }

    private final void unregisterPriorityIterator() {
        if (this.getDownloadConcurrentLimit() > 0) {
            this.handlerWrapper.removeCallbacks(this.priorityIteratorRunnable);
        }
    }

    private final boolean canContinueToProcess() {
        return !this.stopped && !this.paused;
    }

    @Override
    public int getDownloadConcurrentLimit() {
        return this.downloadConcurrentLimit;
    }

    @Override
    public void setDownloadConcurrentLimit(int n) {
        this.downloadConcurrentLimit = n;
    }

    public PriorityListProcessorImpl(@NotNull HandlerWrapper handlerWrapper, @NotNull DownloadProvider downloadProvider, @NotNull DownloadManager downloadManager, @NotNull NetworkInfoProvider networkInfoProvider, @NotNull Logger logger, @NotNull ListenerCoordinator listenerCoordinator, int downloadConcurrentLimit) {
        Intrinsics.checkParameterIsNotNull((Object)handlerWrapper, (String)"handlerWrapper");
        Intrinsics.checkParameterIsNotNull((Object)downloadProvider, (String)"downloadProvider");
        Intrinsics.checkParameterIsNotNull((Object)downloadManager, (String)"downloadManager");
        Intrinsics.checkParameterIsNotNull((Object)networkInfoProvider, (String)"networkInfoProvider");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        Intrinsics.checkParameterIsNotNull((Object)listenerCoordinator, (String)"listenerCoordinator");
        this.handlerWrapper = handlerWrapper;
        this.downloadProvider = downloadProvider;
        this.downloadManager = downloadManager;
        this.networkInfoProvider = networkInfoProvider;
        this.logger = logger;
        this.listenerCoordinator = listenerCoordinator;
        this.downloadConcurrentLimit = downloadConcurrentLimit;
        this.lock = new Object();
        this.globalNetworkType = NetworkType.GLOBAL_OFF;
        this.stopped = true;
        this.priorityIteratorRunnable = new Runnable(this){
            final /* synthetic */ PriorityListProcessorImpl this$0;

            /*
             * WARNING - void declaration
             */
            public final void run() {
                if (PriorityListProcessorImpl.access$canContinueToProcess(this.this$0)) {
                    if (PriorityListProcessorImpl.access$getDownloadManager$p(this.this$0).canAccommodateNewDownload() && PriorityListProcessorImpl.access$canContinueToProcess(this.this$0)) {
                        List<Download> priorityList = this.this$0.getPriorityList();
                        PriorityListProcessor.Delegate delegate = this.this$0.getDelegate();
                        if (delegate != null) {
                            Collection collection = priorityList;
                            PriorityListProcessor.Delegate delegate2 = delegate;
                            boolean bl = !collection.isEmpty();
                            delegate2.onHasActiveDownloads(bl);
                        }
                        int n = 0;
                        int n2 = CollectionsKt.getLastIndex(priorityList);
                        if (n <= n2) {
                            void index;
                            Download download;
                            boolean isFetchServerRequest;
                            while (PriorityListProcessorImpl.access$getDownloadManager$p(this.this$0).canAccommodateNewDownload() && PriorityListProcessorImpl.access$canContinueToProcess(this.this$0) && ((isFetchServerRequest = FetchCoreUtils.isFetchFileServerUrl((String)(download = priorityList.get((int)index)).getUrl())) || PriorityListProcessorImpl.access$getNetworkInfoProvider$p(this.this$0).isNetworkAvailable()) && PriorityListProcessorImpl.access$canContinueToProcess(this.this$0)) {
                                NetworkType networkType = this.this$0.getGlobalNetworkType() != NetworkType.GLOBAL_OFF ? this.this$0.getGlobalNetworkType() : (download.getNetworkType() == NetworkType.GLOBAL_OFF ? NetworkType.ALL : download.getNetworkType());
                                boolean properNetworkConditions = PriorityListProcessorImpl.access$getNetworkInfoProvider$p(this.this$0).isOnAllowedNetwork(networkType);
                                if (!properNetworkConditions) {
                                    PriorityListProcessorImpl.access$getListenerCoordinator$p(this.this$0).getMainListener().onWaitingNetwork(download);
                                }
                                if ((isFetchServerRequest || properNetworkConditions) && !PriorityListProcessorImpl.access$getDownloadManager$p(this.this$0).contains(download.getId()) && PriorityListProcessorImpl.access$canContinueToProcess(this.this$0)) {
                                    PriorityListProcessorImpl.access$getDownloadManager$p(this.this$0).start(download);
                                }
                                if (index == n2) break;
                                ++index;
                            }
                        }
                    }
                    PriorityListProcessorImpl.access$registerPriorityIterator(this.this$0);
                }
            }
            {
                this.this$0 = priorityListProcessorImpl;
            }
        };
    }

    public static final /* synthetic */ boolean access$canContinueToProcess(PriorityListProcessorImpl $this) {
        return $this.canContinueToProcess();
    }

    @NotNull
    public static final /* synthetic */ DownloadManager access$getDownloadManager$p(PriorityListProcessorImpl $this) {
        return $this.downloadManager;
    }

    @NotNull
    public static final /* synthetic */ NetworkInfoProvider access$getNetworkInfoProvider$p(PriorityListProcessorImpl $this) {
        return $this.networkInfoProvider;
    }

    @NotNull
    public static final /* synthetic */ ListenerCoordinator access$getListenerCoordinator$p(PriorityListProcessorImpl $this) {
        return $this.listenerCoordinator;
    }

    public static final /* synthetic */ void access$registerPriorityIterator(PriorityListProcessorImpl $this) {
        $this.registerPriorityIterator();
    }
}

