/*
 * Decompiled with CFR 0.152.
 */
package com.tonyodev.fetch2.downloader;

import android.os.Handler;
import com.tonyodev.fetch2.Download;
import com.tonyodev.fetch2.downloader.DownloadManager;
import com.tonyodev.fetch2.downloader.DownloadManagerCoordinator;
import com.tonyodev.fetch2.downloader.FileDownloader;
import com.tonyodev.fetch2.downloader.ParallelFileDownloaderImpl;
import com.tonyodev.fetch2.downloader.SequentialFileDownloaderImpl;
import com.tonyodev.fetch2.exception.FetchException;
import com.tonyodev.fetch2.fetch.ListenerCoordinator;
import com.tonyodev.fetch2.helper.DownloadInfoUpdater;
import com.tonyodev.fetch2.helper.FileDownloaderDelegate;
import com.tonyodev.fetch2.provider.NetworkInfoProvider;
import com.tonyodev.fetch2.util.FetchUtils;
import com.tonyodev.fetch2core.Downloader;
import com.tonyodev.fetch2core.FetchCoreUtils;
import com.tonyodev.fetch2core.FileServerDownloader;
import com.tonyodev.fetch2core.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001Bm\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u0012\u0006\u0010\u001a\u001a\u00020\r\u00a2\u0006\u0002\u0010\u001bJ\b\u0010)\u001a\u00020\rH\u0016J\u0010\u0010*\u001a\u00020\r2\u0006\u0010+\u001a\u00020\u0005H\u0016J\b\u0010,\u001a\u00020-H\u0016J\b\u0010.\u001a\u00020-H\u0002J\b\u0010/\u001a\u00020-H\u0016J\u0010\u00100\u001a\u00020\r2\u0006\u0010+\u001a\u00020\u0005H\u0016J\b\u00101\u001a\u00020\u0005H\u0016J\u000e\u00102\u001a\b\u0012\u0004\u0012\u00020403H\u0016J\u0010\u00105\u001a\u00020\u00132\u0006\u00106\u001a\u000204H\u0016J\u0018\u00107\u001a\u00020\u001f2\u0006\u00106\u001a\u0002042\u0006\u00108\u001a\u00020\u0003H\u0002J\b\u00109\u001a\u00020:H\u0016J\u0010\u0010;\u001a\u00020\u001f2\u0006\u00106\u001a\u000204H\u0016J\u0010\u0010<\u001a\u00020\r2\u0006\u00106\u001a\u000204H\u0016J\b\u0010=\u001a\u00020-H\u0002J\b\u0010>\u001a\u00020-H\u0002R\u0012\u0010\u001c\u001a\u00020\r8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R.\u0010\u001d\u001a\"\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u001f0\u001ej\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u001f` X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010!\u001a\u00020\u00058\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\"\u001a\n $*\u0004\u0018\u00010#0#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010%\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lcom/tonyodev/fetch2/downloader/DownloadManagerImpl;", "Lcom/tonyodev/fetch2/downloader/DownloadManager;", "httpDownloader", "Lcom/tonyodev/fetch2core/Downloader;", "concurrentLimit", "", "progressReportingIntervalMillis", "", "logger", "Lcom/tonyodev/fetch2core/Logger;", "networkInfoProvider", "Lcom/tonyodev/fetch2/provider/NetworkInfoProvider;", "retryOnNetworkGain", "", "uiHandler", "Landroid/os/Handler;", "downloadInfoUpdater", "Lcom/tonyodev/fetch2/helper/DownloadInfoUpdater;", "fileTempDir", "", "downloadManagerCoordinator", "Lcom/tonyodev/fetch2/downloader/DownloadManagerCoordinator;", "listenerCoordinator", "Lcom/tonyodev/fetch2/fetch/ListenerCoordinator;", "fileServerDownloader", "Lcom/tonyodev/fetch2core/FileServerDownloader;", "md5CheckingEnabled", "(Lcom/tonyodev/fetch2core/Downloader;IJLcom/tonyodev/fetch2core/Logger;Lcom/tonyodev/fetch2/provider/NetworkInfoProvider;ZLandroid/os/Handler;Lcom/tonyodev/fetch2/helper/DownloadInfoUpdater;Ljava/lang/String;Lcom/tonyodev/fetch2/downloader/DownloadManagerCoordinator;Lcom/tonyodev/fetch2/fetch/ListenerCoordinator;Lcom/tonyodev/fetch2core/FileServerDownloader;Z)V", "closed", "currentDownloadsMap", "Ljava/util/HashMap;", "Lcom/tonyodev/fetch2/downloader/FileDownloader;", "Lkotlin/collections/HashMap;", "downloadCounter", "executor", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "isClosed", "()Z", "lock", "", "canAccommodateNewDownload", "cancel", "downloadId", "cancelAll", "", "cancelAllDownloads", "close", "contains", "getActiveDownloadCount", "getActiveDownloads", "", "Lcom/tonyodev/fetch2/Download;", "getDownloadFileTempDir", "download", "getFileDownloader", "downloader", "getFileDownloaderDelegate", "Lcom/tonyodev/fetch2/downloader/FileDownloader$Delegate;", "getNewFileDownloaderForDownload", "start", "terminateAllDownloads", "throwExceptionIfClosed", "fetch2_release"})
public final class DownloadManagerImpl
implements DownloadManager {
    private final Object lock;
    private final ExecutorService executor;
    private final HashMap<Integer, FileDownloader> currentDownloadsMap;
    private volatile int downloadCounter;
    private volatile boolean closed;
    private final Downloader httpDownloader;
    private final int concurrentLimit;
    private final long progressReportingIntervalMillis;
    private final Logger logger;
    private final NetworkInfoProvider networkInfoProvider;
    private final boolean retryOnNetworkGain;
    private final Handler uiHandler;
    private final DownloadInfoUpdater downloadInfoUpdater;
    private final String fileTempDir;
    private final DownloadManagerCoordinator downloadManagerCoordinator;
    private final ListenerCoordinator listenerCoordinator;
    private final FileServerDownloader fileServerDownloader;
    private final boolean md5CheckingEnabled;

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean start(@NotNull Download download) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)download, (String)"download");
        Object object = this.lock;
        synchronized (object) {
            boolean bl2;
            block8: {
                block7: {
                    this.throwExceptionIfClosed();
                    if (!this.currentDownloadsMap.containsKey(download.getId())) break block7;
                    this.logger.d("DownloadManager already running download " + download);
                    boolean bl3 = false;
                    return bl3;
                }
                if (this.downloadCounter < this.concurrentLimit) break block8;
                this.logger.d("DownloadManager cannot init download " + download + " because " + "the download queue is full");
                boolean bl4 = false;
                return bl4;
            }
            ++this.downloadCounter;
            Map map = this.currentDownloadsMap;
            Integer n = download.getId();
            Object v = null;
            map.put(n, v);
            this.downloadManagerCoordinator.addFileDownloader(download.getId(), null);
            ExecutorService executorService = this.executor;
            Intrinsics.checkExpressionValueIsNotNull((Object)executorService, (String)"executor");
            if (!executorService.isShutdown()) {
                this.executor.execute(new Runnable(this, download){
                    final /* synthetic */ DownloadManagerImpl this$0;
                    final /* synthetic */ Download $download$inlined;
                    {
                        this.this$0 = downloadManagerImpl;
                        this.$download$inlined = download;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public final void run() {
                        boolean bl;
                        FileDownloader fileDownloader = this.this$0.getNewFileDownloaderForDownload(this.$download$inlined);
                        Object object = DownloadManagerImpl.access$getLock$p(this.this$0);
                        synchronized (object) {
                            boolean bl2;
                            if (DownloadManagerImpl.access$getCurrentDownloadsMap$p(this.this$0).containsKey(this.$download$inlined.getId())) {
                                fileDownloader.setDelegate(this.this$0.getFileDownloaderDelegate());
                                Map map = DownloadManagerImpl.access$getCurrentDownloadsMap$p(this.this$0);
                                Integer n = this.$download$inlined.getId();
                                FileDownloader fileDownloader2 = fileDownloader;
                                map.put(n, fileDownloader2);
                                DownloadManagerImpl.access$getDownloadManagerCoordinator$p(this.this$0).addFileDownloader(this.$download$inlined.getId(), fileDownloader);
                                DownloadManagerImpl.access$getLogger$p(this.this$0).d("DownloadManager starting download " + this.$download$inlined);
                                bl2 = true;
                            } else {
                                bl2 = false;
                            }
                            bl = bl2;
                        }
                        boolean runDownload = bl;
                        if (runDownload) {
                            fileDownloader.run();
                        }
                        object = DownloadManagerImpl.access$getLock$p(this.this$0);
                        synchronized (object) {
                            if (DownloadManagerImpl.access$getCurrentDownloadsMap$p(this.this$0).containsKey(this.$download$inlined.getId())) {
                                DownloadManagerImpl.access$getCurrentDownloadsMap$p(this.this$0).remove(this.$download$inlined.getId());
                                DownloadManagerImpl downloadManagerImpl = this.this$0;
                                DownloadManagerImpl.access$setDownloadCounter$p(downloadManagerImpl, DownloadManagerImpl.access$getDownloadCounter$p(downloadManagerImpl) - 1);
                            }
                            DownloadManagerImpl.access$getDownloadManagerCoordinator$p(this.this$0).removeFileDownloader(this.$download$inlined.getId());
                            Unit unit = Unit.INSTANCE;
                        }
                    }
                });
                bl2 = true;
            } else {
                bl2 = false;
            }
            bl = bl2;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(int downloadId) {
        Object object = this.lock;
        synchronized (object) {
            boolean bl;
            this.throwExceptionIfClosed();
            if (this.currentDownloadsMap.containsKey(downloadId)) {
                FileDownloader fileDownloader;
                FileDownloader fileDownloader2 = fileDownloader = this.currentDownloadsMap.get(downloadId);
                if (fileDownloader2 != null) {
                    fileDownloader2.setInterrupted(true);
                }
                this.currentDownloadsMap.remove(downloadId);
                --this.downloadCounter;
                this.downloadManagerCoordinator.removeFileDownloader(downloadId);
                if (fileDownloader != null) {
                    this.logger.d("DownloadManager cancelled download " + fileDownloader.getDownload());
                }
                bl = true;
            } else {
                this.downloadManagerCoordinator.interruptDownload(downloadId);
                bl = false;
            }
            boolean bl2 = bl;
            return bl2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelAll() {
        Object object = this.lock;
        synchronized (object) {
            this.throwExceptionIfClosed();
            this.cancelAllDownloads();
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void cancelAllDownloads() {
        Iterator<FileDownloader> $receiver$iv;
        Iterator<FileDownloader> iterator;
        Iterator<FileDownloader> iterator2 = iterator = ($receiver$iv = this.downloadManagerCoordinator.getFileDownloaderList().iterator());
        while (iterator2.hasNext()) {
            FileDownloader element$iv = iterator2.next();
            FileDownloader it = element$iv;
            FileDownloader fileDownloader = it;
            if (fileDownloader == null) continue;
            fileDownloader.setInterrupted(true);
            this.downloadManagerCoordinator.removeFileDownloader(fileDownloader.getDownload().getId());
            this.logger.d("DownloadManager cancelled download " + fileDownloader.getDownload());
        }
        this.currentDownloadsMap.clear();
        this.downloadCounter = 0;
    }

    private final void terminateAllDownloads() {
        Iterator iterator;
        Map map = this.currentDownloadsMap;
        Iterator $receiver$iv = map.entrySet().iterator();
        Iterator iterator2 = iterator = $receiver$iv;
        while (iterator2.hasNext()) {
            Map.Entry element$iv = iterator2.next();
            Map.Entry it = element$iv;
            FileDownloader fileDownloader = (FileDownloader)it.getValue();
            if (fileDownloader == null) continue;
            fileDownloader.setTerminated(true);
            this.logger.d("DownloadManager terminated download " + fileDownloader.getDownload());
            this.downloadManagerCoordinator.removeFileDownloader(((Number)it.getKey()).intValue());
        }
        this.currentDownloadsMap.clear();
        this.downloadCounter = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.terminateAllDownloads();
            this.logger.d("DownloadManager closing download manager");
            this.executor.shutdown();
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(int downloadId) {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = !this.isClosed() && this.downloadManagerCoordinator.containsFileDownloader(downloadId);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canAccommodateNewDownload() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = !this.closed && this.downloadCounter < this.concurrentLimit;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getActiveDownloadCount() {
        Object object = this.lock;
        synchronized (object) {
            this.throwExceptionIfClosed();
            int n = this.downloadCounter;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Download> getActiveDownloads() {
        Object object = this.lock;
        synchronized (object) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            this.throwExceptionIfClosed();
            Collection<FileDownloader> collection = this.currentDownloadsMap.values();
            Intrinsics.checkExpressionValueIsNotNull(collection, (String)"currentDownloadsMap.values");
            Iterable iterable = $receiver$iv = (Iterable)CollectionsKt.filterNotNull((Iterable)collection);
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                FileDownloader fileDownloader = (FileDownloader)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                Download download = it.getDownload();
                collection2.add(download);
            }
            List list = (List)destination$iv$iv;
            return list;
        }
    }

    private final void throwExceptionIfClosed() {
        if (this.closed) {
            throw (Throwable)new FetchException("DownloadManager is already shutdown.");
        }
    }

    @Override
    @NotNull
    public FileDownloader getNewFileDownloaderForDownload(@NotNull Download download) {
        Intrinsics.checkParameterIsNotNull((Object)download, (String)"download");
        return !FetchCoreUtils.isFetchFileServerUrl((String)download.getUrl()) ? this.getFileDownloader(download, this.httpDownloader) : this.getFileDownloader(download, (Downloader)this.fileServerDownloader);
    }

    private final FileDownloader getFileDownloader(Download download, Downloader downloader) {
        FileDownloader fileDownloader;
        Set supportedDownloadTypes;
        Downloader.ServerRequest request = FetchUtils.getRequestForDownload$default(download, null, 2, null);
        if (downloader.getRequestFileDownloaderType(request, supportedDownloadTypes = downloader.getRequestSupportedFileDownloaderTypes(request)) == Downloader.FileDownloaderType.SEQUENTIAL) {
            fileDownloader = new SequentialFileDownloaderImpl(download, downloader, this.progressReportingIntervalMillis, this.logger, this.networkInfoProvider, this.retryOnNetworkGain, this.md5CheckingEnabled);
        } else {
            String string = downloader.getDirectoryForFileDownloaderTypeParallel(request);
            if (string == null) {
                string = this.fileTempDir;
            }
            String tempDir = string;
            fileDownloader = new ParallelFileDownloaderImpl(download, downloader, this.progressReportingIntervalMillis, this.logger, this.networkInfoProvider, this.retryOnNetworkGain, tempDir, this.md5CheckingEnabled);
        }
        return fileDownloader;
    }

    @Override
    @NotNull
    public FileDownloader.Delegate getFileDownloaderDelegate() {
        return new FileDownloaderDelegate(this.downloadInfoUpdater, this.uiHandler, this.listenerCoordinator.getMainListener(), this.logger, this.retryOnNetworkGain);
    }

    @Override
    @NotNull
    public String getDownloadFileTempDir(@NotNull Download download) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)download, (String)"download");
        Downloader.ServerRequest request = FetchUtils.getRequestForDownload$default(download, null, 2, null);
        if (FetchCoreUtils.isFetchFileServerUrl((String)request.getUrl())) {
            string = this.fileServerDownloader.getDirectoryForFileDownloaderTypeParallel(request);
            if (string == null) {
                string = this.fileTempDir;
            }
        } else {
            string = this.httpDownloader.getDirectoryForFileDownloaderTypeParallel(request);
            if (string == null) {
                string = this.fileTempDir;
            }
        }
        return string;
    }

    public DownloadManagerImpl(@NotNull Downloader httpDownloader, int concurrentLimit, long progressReportingIntervalMillis, @NotNull Logger logger, @NotNull NetworkInfoProvider networkInfoProvider, boolean retryOnNetworkGain, @NotNull Handler uiHandler, @NotNull DownloadInfoUpdater downloadInfoUpdater, @NotNull String fileTempDir, @NotNull DownloadManagerCoordinator downloadManagerCoordinator, @NotNull ListenerCoordinator listenerCoordinator, @NotNull FileServerDownloader fileServerDownloader, boolean md5CheckingEnabled) {
        Intrinsics.checkParameterIsNotNull((Object)httpDownloader, (String)"httpDownloader");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        Intrinsics.checkParameterIsNotNull((Object)networkInfoProvider, (String)"networkInfoProvider");
        Intrinsics.checkParameterIsNotNull((Object)uiHandler, (String)"uiHandler");
        Intrinsics.checkParameterIsNotNull((Object)downloadInfoUpdater, (String)"downloadInfoUpdater");
        Intrinsics.checkParameterIsNotNull((Object)fileTempDir, (String)"fileTempDir");
        Intrinsics.checkParameterIsNotNull((Object)downloadManagerCoordinator, (String)"downloadManagerCoordinator");
        Intrinsics.checkParameterIsNotNull((Object)listenerCoordinator, (String)"listenerCoordinator");
        Intrinsics.checkParameterIsNotNull((Object)fileServerDownloader, (String)"fileServerDownloader");
        this.httpDownloader = httpDownloader;
        this.concurrentLimit = concurrentLimit;
        this.progressReportingIntervalMillis = progressReportingIntervalMillis;
        this.logger = logger;
        this.networkInfoProvider = networkInfoProvider;
        this.retryOnNetworkGain = retryOnNetworkGain;
        this.uiHandler = uiHandler;
        this.downloadInfoUpdater = downloadInfoUpdater;
        this.fileTempDir = fileTempDir;
        this.downloadManagerCoordinator = downloadManagerCoordinator;
        this.listenerCoordinator = listenerCoordinator;
        this.fileServerDownloader = fileServerDownloader;
        this.md5CheckingEnabled = md5CheckingEnabled;
        this.lock = new Object();
        this.executor = Executors.newFixedThreadPool(this.concurrentLimit);
        DownloadManagerImpl downloadManagerImpl = this;
        HashMap hashMap = new HashMap();
        downloadManagerImpl.currentDownloadsMap = hashMap;
    }

    @NotNull
    public static final /* synthetic */ Object access$getLock$p(DownloadManagerImpl $this) {
        return $this.lock;
    }

    @NotNull
    public static final /* synthetic */ HashMap access$getCurrentDownloadsMap$p(DownloadManagerImpl $this) {
        return $this.currentDownloadsMap;
    }

    @NotNull
    public static final /* synthetic */ DownloadManagerCoordinator access$getDownloadManagerCoordinator$p(DownloadManagerImpl $this) {
        return $this.downloadManagerCoordinator;
    }

    @NotNull
    public static final /* synthetic */ Logger access$getLogger$p(DownloadManagerImpl $this) {
        return $this.logger;
    }

    public static final /* synthetic */ int access$getDownloadCounter$p(DownloadManagerImpl $this) {
        return $this.downloadCounter;
    }

    public static final /* synthetic */ void access$setDownloadCounter$p(DownloadManagerImpl $this, int n) {
        $this.downloadCounter = n;
    }
}

