/*
 * Decompiled with CFR 0.152.
 */
package com.tonyodev.fetch2.util;

import com.tonyodev.fetch2.Download;
import com.tonyodev.fetch2.FetchConfiguration;
import com.tonyodev.fetch2.util.FetchUtils$WhenMappings;
import com.tonyodev.fetch2core.Downloader;
import com.tonyodev.fetch2core.FetchCoreUtils;
import java.io.File;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000:\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b\u001a\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0002\u001a\u00020\u0003\u001a\"\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u0014\u00a8\u0006\u0016"}, d2={"canCancelDownload", "", "download", "Lcom/tonyodev/fetch2/Download;", "canPauseDownload", "canResumeDownload", "canRetryDownload", "createConfigWithNewNamespace", "Lcom/tonyodev/fetch2/FetchConfiguration;", "fetchConfiguration", "namespace", "", "deleteRequestTempFiles", "", "fileTempDir", "downloader", "Lcom/tonyodev/fetch2core/Downloader;", "getRequestForDownload", "Lcom/tonyodev/fetch2core/Downloader$ServerRequest;", "rangeStart", "", "rangeEnd", "fetch2_release"})
@JvmName(name="FetchUtils")
public final class FetchUtils {
    public static final boolean canPauseDownload(@NotNull Download download) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)download, (String)"download");
        switch (FetchUtils$WhenMappings.$EnumSwitchMapping$0[download.getStatus().ordinal()]) {
            case 1: 
            case 2: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    public static final boolean canResumeDownload(@NotNull Download download) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)download, (String)"download");
        switch (FetchUtils$WhenMappings.$EnumSwitchMapping$1[download.getStatus().ordinal()]) {
            case 1: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    public static final boolean canRetryDownload(@NotNull Download download) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)download, (String)"download");
        switch (FetchUtils$WhenMappings.$EnumSwitchMapping$2[download.getStatus().ordinal()]) {
            case 1: 
            case 2: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    public static final boolean canCancelDownload(@NotNull Download download) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)download, (String)"download");
        switch (FetchUtils$WhenMappings.$EnumSwitchMapping$3[download.getStatus().ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                bl = false;
                break;
            }
            default: {
                bl = true;
            }
        }
        return bl;
    }

    @NotNull
    public static final Downloader.ServerRequest getRequestForDownload(@NotNull Download download, long rangeStart, long rangeEnd) {
        Map headers;
        Intrinsics.checkParameterIsNotNull((Object)download, (String)"download");
        long start = rangeStart == -1L ? 0L : rangeStart;
        String end = rangeEnd == -1L ? "" : String.valueOf(rangeEnd);
        Map map = headers = MapsKt.toMutableMap(download.getHeaders());
        String string = "Range";
        String string2 = "bytes=" + start + '-' + end;
        map.put(string, string2);
        return new Downloader.ServerRequest(download.getId(), download.getUrl(), headers, download.getFile(), download.getTag(), download.getIdentifier());
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Downloader.ServerRequest getRequestForDownload$default(Download download, long l, long l2, int n, Object object) {
        if ((n & 2) != 0) {
            l = -1L;
        }
        if ((n & 4) != 0) {
            l2 = -1L;
        }
        return FetchUtils.getRequestForDownload(download, l, l2);
    }

    public static final void deleteRequestTempFiles(@NotNull String fileTempDir, @NotNull Downloader downloader, @NotNull Download download) {
        Intrinsics.checkParameterIsNotNull((Object)fileTempDir, (String)"fileTempDir");
        Intrinsics.checkParameterIsNotNull((Object)downloader, (String)"downloader");
        Intrinsics.checkParameterIsNotNull((Object)download, (String)"download");
        try {
            Downloader.ServerRequest request = FetchUtils.getRequestForDownload$default(download, 0L, 0L, 6, null);
            String string = downloader.getDirectoryForFileDownloaderTypeParallel(request);
            if (string == null) {
                string = fileTempDir;
            }
            String tempDirPath = string;
            File tempDir = FetchCoreUtils.getFile((String)tempDirPath);
            if (tempDir.exists()) {
                File[] tempFiles = tempDir.listFiles();
                int n = tempFiles.length;
                for (int i = 0; i < n; ++i) {
                    File tempFile;
                    File file = tempFile = tempFiles[i];
                    Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"tempFile");
                    String string2 = file.getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"tempFile.name");
                    boolean match = StringsKt.startsWith$default((String)string2, (String)("" + download.getId() + '.'), (boolean)false, (int)2, null);
                    if (!match || !tempFile.exists()) continue;
                    try {
                        tempFile.delete();
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @NotNull
    public static final FetchConfiguration createConfigWithNewNamespace(@NotNull FetchConfiguration fetchConfiguration, @NotNull String namespace) {
        Intrinsics.checkParameterIsNotNull((Object)fetchConfiguration, (String)"fetchConfiguration");
        Intrinsics.checkParameterIsNotNull((Object)namespace, (String)"namespace");
        return new FetchConfiguration.Builder(fetchConfiguration.getAppContext()).setNamespace(namespace).enableAutoStart(fetchConfiguration.getAutoStart()).enableLogging(fetchConfiguration.getLoggingEnabled()).enableRetryOnNetworkGain(fetchConfiguration.getRetryOnNetworkGain()).setDownloadBufferSize(fetchConfiguration.getDownloadBufferSizeBytes()).setHttpDownloader(fetchConfiguration.getHttpDownloader()).setDownloadConcurrentLimit(fetchConfiguration.getConcurrentLimit()).setProgressReportingInterval(fetchConfiguration.getProgressReportingIntervalMillis()).setGlobalNetworkType(fetchConfiguration.getGlobalNetworkType()).setLogger(fetchConfiguration.getLogger()).build();
    }
}

