/*
 * Decompiled with CFR 0.152.
 */
package com.tonyodev.fetch2.downloader;

import com.tonyodev.fetch2.Download;
import com.tonyodev.fetch2.Error;
import com.tonyodev.fetch2.FetchErrorUtils;
import com.tonyodev.fetch2.database.DownloadInfo;
import com.tonyodev.fetch2.downloader.FileDownloader;
import com.tonyodev.fetch2.downloader.ParallelFileDownloaderImpl;
import com.tonyodev.fetch2.exception.FetchException;
import com.tonyodev.fetch2.provider.NetworkInfoProvider;
import com.tonyodev.fetch2.util.FetchTypeConverterExtensions;
import com.tonyodev.fetch2.util.FetchUtils;
import com.tonyodev.fetch2core.AverageCalculator;
import com.tonyodev.fetch2core.DownloadBlock;
import com.tonyodev.fetch2core.DownloadBlockInfo;
import com.tonyodev.fetch2core.Downloader;
import com.tonyodev.fetch2core.FetchCoreUtils;
import com.tonyodev.fetch2core.FileSlice;
import com.tonyodev.fetch2core.FileSliceInfo;
import com.tonyodev.fetch2core.InterruptMonitor;
import com.tonyodev.fetch2core.Logger;
import com.tonyodev.fetch2core.OutputResourceWrapper;
import java.io.File;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u009f\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007*\u00010\u0018\u00002\u00020\u0001BM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0013J\b\u0010B\u001a\u00020CH\u0002J\u001e\u0010D\u001a\u00020C2\u0006\u0010E\u001a\u00020F2\f\u0010G\u001a\b\u0012\u0004\u0012\u00020.0-H\u0002J\b\u0010H\u001a\u00020\u0007H\u0002J\u0010\u0010I\u001a\u00020J2\u0006\u0010E\u001a\u00020FH\u0002J\u001e\u0010K\u001a\b\u0012\u0004\u0012\u00020.0-2\u0006\u0010L\u001a\u00020\u000f2\u0006\u0010E\u001a\u00020FH\u0002J\b\u0010M\u001a\u00020CH\u0002J\b\u0010N\u001a\u00020CH\u0016J\b\u0010O\u001a\u00020CH\u0002J\b\u0010P\u001a\u00020CH\u0002R\u0012\u0010\u0014\u001a\u00020\t8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0018\u001a\u00020\u000f8\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001c\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u0014\u0010#\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010(\u001a\u00020\u00078\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010*\u001a\u0004\u0018\u00010+X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010/\u001a\u000200X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u00101R\u001e\u00102\u001a\u00020\u000f8\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u0010\u001a\"\u0004\b4\u0010\u001cR\u000e\u00105\u001a\u000206X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00107\u001a\u000208X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00109\u001a\u0004\u0018\u00010:X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010;\u001a\u00020\u000f8\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u0010\u001a\"\u0004\b=\u0010\u001cR\u0014\u0010>\u001a\u0004\u0018\u00010?8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010@\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010A\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006Q"}, d2={"Lcom/tonyodev/fetch2/downloader/ParallelFileDownloaderImpl;", "Lcom/tonyodev/fetch2/downloader/FileDownloader;", "initialDownload", "Lcom/tonyodev/fetch2/Download;", "downloader", "Lcom/tonyodev/fetch2core/Downloader;", "progressReportingIntervalMillis", "", "downloadBufferSizeBytes", "", "logger", "Lcom/tonyodev/fetch2core/Logger;", "networkInfoProvider", "Lcom/tonyodev/fetch2/provider/NetworkInfoProvider;", "retryOnNetworkGain", "", "fileTempDir", "", "md5CheckingEnabled", "(Lcom/tonyodev/fetch2/Download;Lcom/tonyodev/fetch2core/Downloader;JILcom/tonyodev/fetch2core/Logger;Lcom/tonyodev/fetch2/provider/NetworkInfoProvider;ZLjava/lang/String;Z)V", "actionsCounter", "actionsTotal", "averageDownloadedBytesPerSecond", "", "completedDownload", "getCompletedDownload", "()Z", "setCompletedDownload", "(Z)V", "delegate", "Lcom/tonyodev/fetch2/downloader/FileDownloader$Delegate;", "getDelegate", "()Lcom/tonyodev/fetch2/downloader/FileDownloader$Delegate;", "setDelegate", "(Lcom/tonyodev/fetch2/downloader/FileDownloader$Delegate;)V", "download", "getDownload", "()Lcom/tonyodev/fetch2/Download;", "downloadInfo", "Lcom/tonyodev/fetch2/database/DownloadInfo;", "downloaded", "estimatedTimeRemainingInMilliseconds", "executorService", "Ljava/util/concurrent/ExecutorService;", "fileSlices", "", "Lcom/tonyodev/fetch2core/FileSlice;", "interruptMonitor", "com/tonyodev/fetch2/downloader/ParallelFileDownloaderImpl$interruptMonitor$1", "Lcom/tonyodev/fetch2/downloader/ParallelFileDownloaderImpl$interruptMonitor$1;", "interrupted", "getInterrupted", "setInterrupted", "lock", "Ljava/lang/Object;", "movingAverageCalculator", "Lcom/tonyodev/fetch2core/AverageCalculator;", "outputResourceWrapper", "Lcom/tonyodev/fetch2core/OutputResourceWrapper;", "terminated", "getTerminated", "setTerminated", "throwable", "", "total", "totalDownloadBlocks", "deleteAllTempFiles", "", "downloadSliceFiles", "request", "Lcom/tonyodev/fetch2core/Downloader$ServerRequest;", "fileSlicesDownloadsList", "getAverageDownloadedBytesPerSecond", "getChuckInfo", "Lcom/tonyodev/fetch2core/FileSliceInfo;", "getFileSliceList", "acceptsRanges", "incrementActionCompletedCount", "run", "throwExceptionIfFound", "waitAndPerformProgressReporting", "fetch2_release"})
public final class ParallelFileDownloaderImpl
implements FileDownloader {
    private volatile boolean interrupted;
    private volatile boolean terminated;
    private volatile boolean completedDownload;
    @Nullable
    private FileDownloader.Delegate delegate;
    private DownloadInfo downloadInfo;
    private volatile long downloaded;
    private long total;
    private double averageDownloadedBytesPerSecond;
    private final AverageCalculator movingAverageCalculator;
    private long estimatedTimeRemainingInMilliseconds;
    private ExecutorService executorService;
    private volatile int actionsCounter;
    private int actionsTotal;
    private final Object lock;
    private volatile Throwable throwable;
    private List<FileSlice> fileSlices;
    private OutputResourceWrapper outputResourceWrapper;
    private int totalDownloadBlocks;
    private final interruptMonitor.1 interruptMonitor;
    private final Download initialDownload;
    private final Downloader downloader;
    private final long progressReportingIntervalMillis;
    private final int downloadBufferSizeBytes;
    private final Logger logger;
    private final NetworkInfoProvider networkInfoProvider;
    private final boolean retryOnNetworkGain;
    private final String fileTempDir;
    private final boolean md5CheckingEnabled;

    @Override
    public boolean getInterrupted() {
        return this.interrupted;
    }

    @Override
    public void setInterrupted(boolean bl) {
        this.interrupted = bl;
    }

    @Override
    public boolean getTerminated() {
        return this.terminated;
    }

    @Override
    public void setTerminated(boolean bl) {
        this.terminated = bl;
    }

    @Override
    public boolean getCompletedDownload() {
        return this.completedDownload;
    }

    @Override
    public void setCompletedDownload(boolean bl) {
        this.completedDownload = bl;
    }

    @Override
    @Nullable
    public FileDownloader.Delegate getDelegate() {
        return this.delegate;
    }

    @Override
    public void setDelegate(@Nullable FileDownloader.Delegate delegate) {
        this.delegate = delegate;
    }

    @Override
    @NotNull
    public Download getDownload() {
        this.downloadInfo.setDownloaded(this.downloaded);
        this.downloadInfo.setTotal(this.total);
        return this.downloadInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        Downloader.Response openingResponse = null;
        try {
            Downloader.ServerRequest openingRequest = this.downloader.getHeadRequestMethodSupported(FetchUtils.getRequestForDownload$default(this.initialDownload, null, 2, null)) ? FetchUtils.getRequestForDownload(this.initialDownload, "HEAD") : FetchUtils.getRequestForDownload$default(this.initialDownload, null, 2, null);
            openingResponse = this.downloader.execute(openingRequest, (InterruptMonitor)this.interruptMonitor);
            if (!this.getInterrupted() && !this.getTerminated()) {
                Downloader.Response response = openingResponse;
                if (response != null) {
                    if (response.isSuccessful()) {
                        Iterator $receiver$iv$iv;
                        Iterable $receiver$iv;
                        this.total = openingResponse.getContentLength();
                        if (this.total <= 0L) throw (Throwable)new FetchException("empty_response_body", FetchException.Code.EMPTY_RESPONSE_BODY);
                        this.fileSlices = this.getFileSliceList(openingResponse.getAcceptsRanges(), openingRequest);
                        this.totalDownloadBlocks = this.fileSlices.size();
                        try {
                            this.downloader.disconnect(openingResponse);
                        }
                        catch (Exception e) {
                            this.logger.e("FileDownloader", (Throwable)e);
                        }
                        Iterable iterable = $receiver$iv = (Iterable)this.fileSlices;
                        Collection destination$iv$iv = new ArrayList();
                        Iterator iterator = $receiver$iv$iv.iterator();
                        while (iterator.hasNext()) {
                            Object element$iv$iv = iterator.next();
                            FileSlice it = (FileSlice)element$iv$iv;
                            if (!(!it.isDownloaded())) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        List sliceFileDownloadsList = (List)destination$iv$iv;
                        if (this.getInterrupted() || this.getTerminated()) return;
                        this.downloadInfo.setDownloaded(this.downloaded);
                        this.downloadInfo.setTotal(this.total);
                        FileDownloader.Delegate delegate = this.getDelegate();
                        if (delegate != null) {
                            delegate.onStarted(this.downloadInfo, this.estimatedTimeRemainingInMilliseconds, this.getAverageDownloadedBytesPerSecond());
                        }
                        $receiver$iv = this.fileSlices;
                        for (Object element$iv : $receiver$iv) {
                            FileSlice it = (FileSlice)element$iv;
                            DownloadBlockInfo downloadBlock2 = new DownloadBlockInfo();
                            downloadBlock2.setDownloadId(it.getId());
                            downloadBlock2.setBlockPosition(it.getPosition());
                            downloadBlock2.setDownloadedBytes(it.getDownloaded());
                            downloadBlock2.setStartByte(it.getStartBytes());
                            downloadBlock2.setEndByte(it.getEndBytes());
                            FileDownloader.Delegate delegate2 = this.getDelegate();
                            if (delegate2 == null) continue;
                            delegate2.onDownloadBlockUpdated(this.downloadInfo, (DownloadBlock)downloadBlock2, this.totalDownloadBlocks);
                        }
                        $receiver$iv = sliceFileDownloadsList;
                        if (!$receiver$iv.isEmpty()) {
                            this.executorService = Executors.newFixedThreadPool(sliceFileDownloadsList.size());
                        }
                        this.downloadSliceFiles(openingRequest, sliceFileDownloadsList);
                        this.waitAndPerformProgressReporting();
                        this.downloadInfo.setDownloaded(this.downloaded);
                        this.downloadInfo.setTotal(this.total);
                        if (!this.getInterrupted() && !this.getTerminated()) {
                            long fileSlicesTotal = 0L;
                            Iterable $receiver$iv2 = this.fileSlices;
                            for (Object element$iv : $receiver$iv2) {
                                FileSlice it = (FileSlice)element$iv;
                                fileSlicesTotal += it.getDownloaded();
                            }
                            if (fileSlicesTotal != this.total) {
                                this.throwable = new FetchException("download_incomplete", FetchException.Code.DOWNLOAD_INCOMPLETE);
                            }
                            this.throwExceptionIfFound();
                            this.setCompletedDownload(true);
                            if (this.md5CheckingEnabled) {
                                if (!this.downloader.verifyContentMD5(openingResponse.getRequest(), openingResponse.getMd5())) throw (Throwable)new FetchException("invalid content md5", FetchException.Code.INVALID_CONTENT_MD5);
                                FileDownloader.Delegate delegate3 = this.getDelegate();
                                if (delegate3 != null) {
                                    delegate3.onProgress(this.downloadInfo, this.estimatedTimeRemainingInMilliseconds, this.getAverageDownloadedBytesPerSecond());
                                }
                                FileDownloader.Delegate delegate4 = this.getDelegate();
                                if (delegate4 != null) {
                                    delegate4.onComplete(this.downloadInfo);
                                }
                            } else {
                                FileDownloader.Delegate delegate5 = this.getDelegate();
                                if (delegate5 != null) {
                                    delegate5.onProgress(this.downloadInfo, this.estimatedTimeRemainingInMilliseconds, this.getAverageDownloadedBytesPerSecond());
                                }
                                FileDownloader.Delegate delegate6 = this.getDelegate();
                                if (delegate6 != null) {
                                    delegate6.onComplete(this.downloadInfo);
                                }
                            }
                        }
                        if (this.getCompletedDownload()) return;
                        this.downloadInfo.setDownloaded(this.downloaded);
                        this.downloadInfo.setTotal(this.total);
                        if (this.getTerminated()) return;
                        FileDownloader.Delegate delegate7 = this.getDelegate();
                        if (delegate7 != null) {
                            delegate7.saveDownloadProgress(this.downloadInfo);
                        }
                        FileDownloader.Delegate delegate8 = this.getDelegate();
                        if (delegate8 == null) return;
                        delegate8.onProgress(this.downloadInfo, this.estimatedTimeRemainingInMilliseconds, this.getAverageDownloadedBytesPerSecond());
                        return;
                    }
                }
            }
            if (openingResponse == null && !this.getInterrupted() && !this.getTerminated()) {
                throw (Throwable)new FetchException("empty_response_body", FetchException.Code.EMPTY_RESPONSE_BODY);
            }
            Downloader.Response response = openingResponse;
            if (response != null) {
                if (!response.isSuccessful()) {
                    if (!this.getInterrupted() && !this.getTerminated()) {
                        throw (Throwable)new FetchException("request_not_successful", FetchException.Code.REQUEST_NOT_SUCCESSFUL);
                    }
                }
            }
            if (this.getInterrupted() || this.getTerminated()) return;
            throw (Throwable)new FetchException("unknown", FetchException.Code.UNKNOWN);
        }
        catch (Exception e) {
            if (this.getInterrupted() || this.getTerminated()) return;
            this.logger.e("FileDownloader", (Throwable)e);
            Error error = FetchErrorUtils.getErrorFromThrowable(e);
            error.setThrowable(e);
            if (this.retryOnNetworkGain) {
                boolean disconnectDetected = !this.networkInfoProvider.isNetworkAvailable();
                int $receiver$iv2 = 1;
                int n = 10;
                while ($receiver$iv2 <= n) {
                    void i;
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e2) {
                        this.logger.e("FileDownloader", (Throwable)e2);
                        break;
                    }
                    if (!this.networkInfoProvider.isNetworkAvailable()) {
                        disconnectDetected = true;
                        break;
                    }
                    ++i;
                }
                if (disconnectDetected) {
                    error = Error.NO_NETWORK_CONNECTION;
                }
            }
            this.downloadInfo.setDownloaded(this.downloaded);
            this.downloadInfo.setTotal(this.total);
            this.downloadInfo.setError(error);
            if (this.getTerminated()) return;
            FileDownloader.Delegate delegate = this.getDelegate();
            if (delegate == null) return;
            delegate.onError(this.downloadInfo);
            return;
        }
        finally {
            try {
                ExecutorService executorService = this.executorService;
                if (executorService != null) {
                    executorService.shutdown();
                }
            }
            catch (Exception e) {
                this.logger.e("FileDownloader", (Throwable)e);
            }
            try {
                OutputResourceWrapper outputResourceWrapper = this.outputResourceWrapper;
                if (outputResourceWrapper != null) {
                    outputResourceWrapper.close();
                }
            }
            catch (Exception e) {
                this.logger.e("FileDownloader", (Throwable)e);
            }
            if (openingResponse != null) {
                try {
                    this.downloader.disconnect(openingResponse);
                }
                catch (Exception e) {
                    this.logger.e("FileDownloader", (Throwable)e);
                }
            }
            this.setTerminated(true);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<FileSlice> getFileSliceList(boolean acceptsRanges, Downloader.ServerRequest request) {
        List list;
        File file = FetchCoreUtils.getFile((String)this.downloadInfo.getFile());
        if (!file.exists()) {
            this.deleteAllTempFiles();
        }
        int previousSliceSize = FetchUtils.getPreviousSliceCount(this.downloadInfo.getId(), this.fileTempDir);
        if (acceptsRanges) {
            FileSliceInfo fileSliceInfo = this.getChuckInfo(request);
            if (previousSliceSize != fileSliceInfo.getSlicingCount()) {
                this.deleteAllTempFiles();
            }
            FetchUtils.saveCurrentSliceCount(this.downloadInfo.getId(), fileSliceInfo.getSlicingCount(), this.fileTempDir);
            long counterBytes = 0L;
            List fileSlices = new ArrayList();
            int n = 1;
            int n2 = fileSliceInfo.getSlicingCount();
            if (n <= n2) {
                while (!this.getInterrupted() && !this.getTerminated()) {
                    void position;
                    long endBytes;
                    long startBytes = counterBytes;
                    counterBytes = endBytes = fileSliceInfo.getSlicingCount() == position ? this.total : counterBytes + fileSliceInfo.getBytesPerFileSlice();
                    FileSlice fileSlice = new FileSlice(this.downloadInfo.getId(), (int)position, startBytes, endBytes, FetchUtils.getSavedDownloadedInfo(this.downloadInfo.getId(), (int)position, this.fileTempDir));
                    this.downloaded += fileSlice.getDownloaded();
                    fileSlices.add(fileSlice);
                    if (position == n2) break;
                    ++position;
                }
            }
            list = fileSlices;
        } else {
            if (previousSliceSize != 1) {
                this.deleteAllTempFiles();
            }
            FetchUtils.saveCurrentSliceCount(this.downloadInfo.getId(), 1, this.fileTempDir);
            FileSlice fileSlice = new FileSlice(this.downloadInfo.getId(), 1, 0L, this.total, FetchUtils.getSavedDownloadedInfo(this.downloadInfo.getId(), 1, this.fileTempDir));
            this.downloaded += fileSlice.getDownloaded();
            list = CollectionsKt.listOf((Object)fileSlice);
        }
        return list;
    }

    private final FileSliceInfo getChuckInfo(Downloader.ServerRequest request) {
        Integer n = this.downloader.getFileSlicingCount(request, this.total);
        int fileSliceSize = n != null ? n : -1;
        return FetchUtils.getFileSliceInfo(fileSliceSize, this.total);
    }

    private final long getAverageDownloadedBytesPerSecond() {
        if (this.averageDownloadedBytesPerSecond < 1.0) {
            return 0L;
        }
        double d = this.averageDownloadedBytesPerSecond;
        return (long)Math.ceil(d);
    }

    private final void waitAndPerformProgressReporting() {
        long downloadedBytesPerSecond = this.downloaded;
        long reportingStartTime = System.nanoTime();
        long downloadSpeedStartTime = System.nanoTime();
        while (this.actionsCounter != this.actionsTotal && !this.getInterrupted() && !this.getTerminated()) {
            long reportingStopTime;
            boolean hasReportingTimeElapsed;
            this.downloadInfo.setDownloaded(this.downloaded);
            this.downloadInfo.setTotal(this.total);
            long downloadSpeedStopTime = System.nanoTime();
            boolean downloadSpeedCheckTimeElapsed = FetchCoreUtils.hasIntervalTimeElapsed((long)downloadSpeedStartTime, (long)downloadSpeedStopTime, (long)1000L);
            if (downloadSpeedCheckTimeElapsed) {
                downloadedBytesPerSecond = this.downloaded - downloadedBytesPerSecond;
                this.movingAverageCalculator.add((double)downloadedBytesPerSecond);
                this.averageDownloadedBytesPerSecond = AverageCalculator.getMovingAverageWithWeightOnRecentValues$default((AverageCalculator)this.movingAverageCalculator, (int)0, (int)1, null);
                this.estimatedTimeRemainingInMilliseconds = FetchCoreUtils.calculateEstimatedTimeRemainingInMilliseconds((long)this.downloaded, (long)this.total, (long)this.getAverageDownloadedBytesPerSecond());
                downloadedBytesPerSecond = this.downloaded;
                if (this.progressReportingIntervalMillis > 1000L) {
                    FileDownloader.Delegate delegate = this.getDelegate();
                    if (delegate != null) {
                        delegate.saveDownloadProgress(this.downloadInfo);
                    }
                }
            }
            if (hasReportingTimeElapsed = FetchCoreUtils.hasIntervalTimeElapsed((long)reportingStartTime, (long)(reportingStopTime = System.nanoTime()), (long)this.progressReportingIntervalMillis)) {
                if (this.progressReportingIntervalMillis <= 1000L) {
                    FileDownloader.Delegate delegate = this.getDelegate();
                    if (delegate != null) {
                        delegate.saveDownloadProgress(this.downloadInfo);
                    }
                }
                if (!this.getTerminated()) {
                    FileDownloader.Delegate delegate = this.getDelegate();
                    if (delegate != null) {
                        delegate.onProgress(this.downloadInfo, this.estimatedTimeRemainingInMilliseconds, this.getAverageDownloadedBytesPerSecond());
                    }
                }
                reportingStartTime = System.nanoTime();
            }
            if (!downloadSpeedCheckTimeElapsed) continue;
            downloadSpeedStartTime = System.nanoTime();
        }
    }

    private final void downloadSliceFiles(Downloader.ServerRequest request, List<FileSlice> fileSlicesDownloadsList) {
        this.actionsCounter = 0;
        this.actionsTotal = fileSlicesDownloadsList.size();
        this.outputResourceWrapper = this.downloader.getRequestOutputResourceWrapper(request);
        if (this.outputResourceWrapper == null) {
            this.outputResourceWrapper = new OutputResourceWrapper(this){
                private final RandomAccessFile randomAccessFile;
                final /* synthetic */ ParallelFileDownloaderImpl this$0;

                public void write(@NotNull byte[] byteArray, int offSet, int length) {
                    Intrinsics.checkParameterIsNotNull((Object)byteArray, (String)"byteArray");
                    this.randomAccessFile.write(byteArray, offSet, length);
                }

                public void setWriteOffset(long offset) {
                    this.randomAccessFile.seek(offset);
                }

                public void flush() {
                }

                public void close() {
                    this.randomAccessFile.close();
                }
                {
                    this.this$0 = $outer;
                    this.randomAccessFile = new RandomAccessFile(ParallelFileDownloaderImpl.access$getDownloadInfo$p($outer).getFile(), "rw");
                    this.randomAccessFile.seek(0L);
                }
            };
        }
        for (FileSlice fileSlice : fileSlicesDownloadsList) {
            if (this.getInterrupted() || this.getTerminated()) continue;
            ExecutorService executorService = this.executorService;
            if (executorService == null) continue;
            executorService.execute(new Runnable(this, fileSlice){
                final /* synthetic */ ParallelFileDownloaderImpl this$0;
                final /* synthetic */ FileSlice $fileSlice;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void run() {
                    block32: {
                        DownloadBlockInfo downloadBlock2 = new DownloadBlockInfo();
                        downloadBlock2.setDownloadId(this.$fileSlice.getId());
                        downloadBlock2.setBlockPosition(this.$fileSlice.getPosition());
                        downloadBlock2.setDownloadedBytes(this.$fileSlice.getDownloaded());
                        downloadBlock2.setStartByte(this.$fileSlice.getStartBytes());
                        downloadBlock2.setEndByte(this.$fileSlice.getEndBytes());
                        Downloader.ServerRequest downloadRequest = FetchUtils.getRequestForDownload$default(ParallelFileDownloaderImpl.access$getDownloadInfo$p(this.this$0), this.$fileSlice.getStartBytes() + this.$fileSlice.getDownloaded(), 0L, null, 12, null);
                        Downloader.Response downloadResponse = null;
                        try {
                            downloadResponse = ParallelFileDownloaderImpl.access$getDownloader$p(this.this$0).execute(downloadRequest, (InterruptMonitor)ParallelFileDownloaderImpl.access$getInterruptMonitor$p(this.this$0));
                            if (!this.this$0.getTerminated() && !this.this$0.getInterrupted()) {
                                Downloader.Response response = downloadResponse;
                                if (response != null) {
                                    if (response.isSuccessful()) {
                                        byte[] buffer = new byte[ParallelFileDownloaderImpl.access$getDownloadBufferSizeBytes$p(this.this$0)];
                                        InputStream inputStream = downloadResponse.getByteStream();
                                        int read = inputStream != null ? inputStream.read(buffer, 0, ParallelFileDownloaderImpl.access$getDownloadBufferSizeBytes$p(this.this$0)) : -1;
                                        long remainderBytes = this.$fileSlice.getEndBytes() - (this.$fileSlice.getStartBytes() + this.$fileSlice.getDownloaded());
                                        long reportingStartTime = System.nanoTime();
                                        Ref.IntRef streamBytes = new Ref.IntRef();
                                        Ref.LongRef longRef = new Ref.LongRef();
                                        while (remainderBytes > 0L && read != -1 && !this.this$0.getInterrupted() && !this.this$0.getTerminated()) {
                                            int n;
                                            if ((long)read <= remainderBytes) {
                                                n = read;
                                            } else {
                                                read = -1;
                                                n = (int)remainderBytes;
                                            }
                                            streamBytes.element = n;
                                            longRef.element = this.$fileSlice.getStartBytes() + this.$fileSlice.getDownloaded();
                                            Object object = ParallelFileDownloaderImpl.access$getLock$p(this.this$0);
                                            synchronized (object) {
                                                if (!this.this$0.getInterrupted() && !this.this$0.getTerminated()) {
                                                    OutputResourceWrapper outputResourceWrapper = ParallelFileDownloaderImpl.access$getOutputResourceWrapper$p(this.this$0);
                                                    if (outputResourceWrapper != null) {
                                                        outputResourceWrapper.setWriteOffset(longRef.element);
                                                    }
                                                    OutputResourceWrapper outputResourceWrapper2 = ParallelFileDownloaderImpl.access$getOutputResourceWrapper$p(this.this$0);
                                                    if (outputResourceWrapper2 != null) {
                                                        outputResourceWrapper2.write(buffer, 0, streamBytes.element);
                                                    }
                                                    FileSlice fileSlice = this.$fileSlice;
                                                    fileSlice.setDownloaded(fileSlice.getDownloaded() + (long)streamBytes.element);
                                                    ParallelFileDownloaderImpl parallelFileDownloaderImpl = this.this$0;
                                                    ParallelFileDownloaderImpl.access$setDownloaded$p(parallelFileDownloaderImpl, ParallelFileDownloaderImpl.access$getDownloaded$p(parallelFileDownloaderImpl) + (long)streamBytes.element);
                                                }
                                                Unit unit = Unit.INSTANCE;
                                            }
                                            if (this.this$0.getInterrupted() || this.this$0.getTerminated()) continue;
                                            long reportingStopTime = System.nanoTime();
                                            boolean hasReportingTimeElapsed = FetchCoreUtils.hasIntervalTimeElapsed((long)reportingStartTime, (long)reportingStopTime, (long)1000L);
                                            if (hasReportingTimeElapsed) {
                                                FetchUtils.saveDownloadedInfo(this.$fileSlice.getId(), this.$fileSlice.getPosition(), this.$fileSlice.getDownloaded(), ParallelFileDownloaderImpl.access$getFileTempDir$p(this.this$0));
                                                downloadBlock2.setDownloadedBytes(this.$fileSlice.getDownloaded());
                                                FileDownloader.Delegate delegate = this.this$0.getDelegate();
                                                if (delegate != null) {
                                                    delegate.onDownloadBlockUpdated(ParallelFileDownloaderImpl.access$getDownloadInfo$p(this.this$0), (DownloadBlock)downloadBlock2, ParallelFileDownloaderImpl.access$getTotalDownloadBlocks$p(this.this$0));
                                                }
                                                reportingStartTime = System.nanoTime();
                                            }
                                            if (read == -1) continue;
                                            InputStream inputStream2 = downloadResponse.getByteStream();
                                            read = inputStream2 != null ? inputStream2.read(buffer, 0, ParallelFileDownloaderImpl.access$getDownloadBufferSizeBytes$p(this.this$0)) : -1;
                                            remainderBytes = this.$fileSlice.getEndBytes() - (this.$fileSlice.getStartBytes() + this.$fileSlice.getDownloaded());
                                        }
                                        FetchUtils.saveDownloadedInfo(this.$fileSlice.getId(), this.$fileSlice.getPosition(), this.$fileSlice.getDownloaded(), ParallelFileDownloaderImpl.access$getFileTempDir$p(this.this$0));
                                        downloadBlock2.setDownloadedBytes(this.$fileSlice.getDownloaded());
                                        FileDownloader.Delegate delegate = this.this$0.getDelegate();
                                        if (delegate != null) {
                                            delegate.onDownloadBlockUpdated(ParallelFileDownloaderImpl.access$getDownloadInfo$p(this.this$0), (DownloadBlock)downloadBlock2, ParallelFileDownloaderImpl.access$getTotalDownloadBlocks$p(this.this$0));
                                        }
                                        break block32;
                                    }
                                }
                            }
                            if (downloadResponse == null && !this.this$0.getInterrupted() && !this.this$0.getTerminated()) {
                                throw (Throwable)new FetchException("empty_response_body", FetchException.Code.EMPTY_RESPONSE_BODY);
                            }
                            Downloader.Response response = downloadResponse;
                            if (response != null) {
                                if (!response.isSuccessful()) {
                                    if (!this.this$0.getInterrupted() && !this.this$0.getTerminated()) {
                                        throw (Throwable)new FetchException("request_not_successful", FetchException.Code.REQUEST_NOT_SUCCESSFUL);
                                    }
                                }
                            }
                            if (!this.this$0.getInterrupted() && !this.this$0.getTerminated()) {
                                throw (Throwable)new FetchException("unknown", FetchException.Code.UNKNOWN);
                            }
                        }
                        catch (Exception e) {
                            ParallelFileDownloaderImpl.access$setThrowable$p(this.this$0, e);
                        }
                        finally {
                            try {
                                if (downloadResponse != null) {
                                    ParallelFileDownloaderImpl.access$getDownloader$p(this.this$0).disconnect(downloadResponse);
                                }
                            }
                            catch (Exception e) {
                                ParallelFileDownloaderImpl.access$getLogger$p(this.this$0).e("FileDownloader", (Throwable)e);
                            }
                            ParallelFileDownloaderImpl.access$incrementActionCompletedCount(this.this$0);
                        }
                    }
                }
                {
                    this.this$0 = parallelFileDownloaderImpl;
                    this.$fileSlice = fileSlice;
                }
            });
        }
    }

    private final void deleteAllTempFiles() {
        try {
            for (FileSlice fileSlice : this.fileSlices) {
                FetchUtils.deleteTempFile(fileSlice.getId(), fileSlice.getPosition(), this.fileTempDir);
            }
            FetchUtils.deleteMetaFile(this.downloadInfo.getId(), this.fileTempDir);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void incrementActionCompletedCount() {
        Object object = this.lock;
        synchronized (object) {
            ++this.actionsCounter;
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void throwExceptionIfFound() {
        Throwable exception = this.throwable;
        if (exception != null) {
            throw exception;
        }
    }

    public ParallelFileDownloaderImpl(@NotNull Download initialDownload, @NotNull Downloader downloader, long progressReportingIntervalMillis, int downloadBufferSizeBytes, @NotNull Logger logger, @NotNull NetworkInfoProvider networkInfoProvider, boolean retryOnNetworkGain, @NotNull String fileTempDir, boolean md5CheckingEnabled) {
        Intrinsics.checkParameterIsNotNull((Object)initialDownload, (String)"initialDownload");
        Intrinsics.checkParameterIsNotNull((Object)downloader, (String)"downloader");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        Intrinsics.checkParameterIsNotNull((Object)networkInfoProvider, (String)"networkInfoProvider");
        Intrinsics.checkParameterIsNotNull((Object)fileTempDir, (String)"fileTempDir");
        this.initialDownload = initialDownload;
        this.downloader = downloader;
        this.progressReportingIntervalMillis = progressReportingIntervalMillis;
        this.downloadBufferSizeBytes = downloadBufferSizeBytes;
        this.logger = logger;
        this.networkInfoProvider = networkInfoProvider;
        this.retryOnNetworkGain = retryOnNetworkGain;
        this.fileTempDir = fileTempDir;
        this.md5CheckingEnabled = md5CheckingEnabled;
        this.downloadInfo = FetchTypeConverterExtensions.toDownloadInfo(this.initialDownload);
        this.total = -1L;
        this.movingAverageCalculator = new AverageCalculator(5);
        this.estimatedTimeRemainingInMilliseconds = -1L;
        this.lock = new Object();
        this.fileSlices = CollectionsKt.emptyList();
        this.interruptMonitor = new InterruptMonitor(this){
            final /* synthetic */ ParallelFileDownloaderImpl this$0;

            public boolean isInterrupted() {
                return this.this$0.getInterrupted();
            }
            {
                this.this$0 = $outer;
            }
        };
    }

    @NotNull
    public static final /* synthetic */ DownloadInfo access$getDownloadInfo$p(ParallelFileDownloaderImpl $this) {
        return $this.downloadInfo;
    }

    public static final /* synthetic */ void access$setDownloadInfo$p(ParallelFileDownloaderImpl $this, @NotNull DownloadInfo downloadInfo) {
        $this.downloadInfo = downloadInfo;
    }

    @NotNull
    public static final /* synthetic */ Downloader access$getDownloader$p(ParallelFileDownloaderImpl $this) {
        return $this.downloader;
    }

    @NotNull
    public static final /* synthetic */ interruptMonitor.1 access$getInterruptMonitor$p(ParallelFileDownloaderImpl $this) {
        return $this.interruptMonitor;
    }

    public static final /* synthetic */ int access$getDownloadBufferSizeBytes$p(ParallelFileDownloaderImpl $this) {
        return $this.downloadBufferSizeBytes;
    }

    @NotNull
    public static final /* synthetic */ Object access$getLock$p(ParallelFileDownloaderImpl $this) {
        return $this.lock;
    }

    @Nullable
    public static final /* synthetic */ OutputResourceWrapper access$getOutputResourceWrapper$p(ParallelFileDownloaderImpl $this) {
        return $this.outputResourceWrapper;
    }

    public static final /* synthetic */ void access$setOutputResourceWrapper$p(ParallelFileDownloaderImpl $this, @Nullable OutputResourceWrapper outputResourceWrapper) {
        $this.outputResourceWrapper = outputResourceWrapper;
    }

    public static final /* synthetic */ long access$getDownloaded$p(ParallelFileDownloaderImpl $this) {
        return $this.downloaded;
    }

    public static final /* synthetic */ void access$setDownloaded$p(ParallelFileDownloaderImpl $this, long l) {
        $this.downloaded = l;
    }

    @NotNull
    public static final /* synthetic */ String access$getFileTempDir$p(ParallelFileDownloaderImpl $this) {
        return $this.fileTempDir;
    }

    public static final /* synthetic */ int access$getTotalDownloadBlocks$p(ParallelFileDownloaderImpl $this) {
        return $this.totalDownloadBlocks;
    }

    public static final /* synthetic */ void access$setTotalDownloadBlocks$p(ParallelFileDownloaderImpl $this, int n) {
        $this.totalDownloadBlocks = n;
    }

    @NotNull
    public static final /* synthetic */ Logger access$getLogger$p(ParallelFileDownloaderImpl $this) {
        return $this.logger;
    }

    public static final /* synthetic */ void access$incrementActionCompletedCount(ParallelFileDownloaderImpl $this) {
        $this.incrementActionCompletedCount();
    }

    @Nullable
    public static final /* synthetic */ Throwable access$getThrowable$p(ParallelFileDownloaderImpl $this) {
        return $this.throwable;
    }

    public static final /* synthetic */ void access$setThrowable$p(ParallelFileDownloaderImpl $this, @Nullable Throwable throwable) {
        $this.throwable = throwable;
    }
}

