/*
 * Decompiled with CFR 0.152.
 */
package com.tonyodev.fetch2.fetch;

import android.content.Context;
import com.tonyodev.fetch2.Downloader;
import com.tonyodev.fetch2.FetchLogger;
import com.tonyodev.fetch2.Logger;
import com.tonyodev.fetch2.NetworkType;
import com.tonyodev.fetch2.exception.FetchException;
import com.tonyodev.fetch2.fetch.FetchBuilderPrefs;
import com.tonyodev.fetch2.util.FetchDefaults;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\b&\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u0001*\u0006\b\u0001\u0010\u0002 \u00012\u00020\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\r\u0010\u0019\u001a\u00028\u0001H&\u00a2\u0006\u0002\u0010\u001aJ\u001a\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010\u001c\u001a\u00020\u0013J\u001a\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010\u001c\u001a\u00020\u0013J\u0006\u0010\u001e\u001a\u00020\u001fJ\u001a\u0010 \u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010!\u001a\u00020\fJ\u001a\u0010\"\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010#\u001a\u00020\fJ\u001a\u0010$\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010\u000e\u001a\u00020\u000fJ\u001a\u0010%\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010&\u001a\u00020\u0011J\u001a\u0010'\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010\u0014\u001a\u00020\u0015J\u001a\u0010(\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010\u0017\u001a\u00020\u0018R\u0016\u0010\t\u001a\n \n*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/tonyodev/fetch2/fetch/FetchBuilder;", "B", "F", "", "context", "Landroid/content/Context;", "namespace", "", "(Landroid/content/Context;Ljava/lang/String;)V", "appContext", "kotlin.jvm.PlatformType", "concurrentLimit", "", "downloadBufferSizeBytes", "downloader", "Lcom/tonyodev/fetch2/Downloader;", "globalNetworkType", "Lcom/tonyodev/fetch2/NetworkType;", "inMemoryDatabaseEnabled", "", "logger", "Lcom/tonyodev/fetch2/Logger;", "loggingEnabled", "progressReportingIntervalMillis", "", "build", "()Ljava/lang/Object;", "enableLogging", "enabled", "enabledInMemoryDatabase", "getBuilderPrefs", "Lcom/tonyodev/fetch2/fetch/FetchBuilderPrefs;", "setDownloadBufferSize", "bytes", "setDownloadConcurrentLimit", "downloadConcurrentLimit", "setDownloader", "setGlobalNetworkType", "networkType", "setLogger", "setProgressReportingInterval", "fetch2_release"})
public abstract class FetchBuilder<B, F> {
    private final Context appContext;
    private int concurrentLimit;
    private long progressReportingIntervalMillis;
    private int downloadBufferSizeBytes;
    private boolean loggingEnabled;
    private boolean inMemoryDatabaseEnabled;
    private Downloader downloader;
    private NetworkType globalNetworkType;
    private Logger logger;
    private final String namespace;

    @NotNull
    public final FetchBuilder<B, F> setDownloader(@NotNull Downloader downloader) {
        Intrinsics.checkParameterIsNotNull((Object)downloader, (String)"downloader");
        this.downloader = downloader;
        return this;
    }

    @NotNull
    public final FetchBuilder<B, F> setProgressReportingInterval(long progressReportingIntervalMillis) {
        if (progressReportingIntervalMillis < 0L) {
            throw (Throwable)new FetchException("progressReportingIntervalMillis cannot be less than 0", FetchException.Code.ILLEGAL_ARGUMENT);
        }
        this.progressReportingIntervalMillis = progressReportingIntervalMillis;
        return this;
    }

    @NotNull
    public final FetchBuilder<B, F> setDownloadConcurrentLimit(int downloadConcurrentLimit) {
        if (downloadConcurrentLimit < 1) {
            throw (Throwable)new FetchException("Concurrent limit cannot be less than 1", FetchException.Code.ILLEGAL_ARGUMENT);
        }
        this.concurrentLimit = downloadConcurrentLimit;
        return this;
    }

    @NotNull
    public final FetchBuilder<B, F> setGlobalNetworkType(@NotNull NetworkType networkType) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)networkType), (String)"networkType");
        this.globalNetworkType = networkType;
        return this;
    }

    @NotNull
    public final FetchBuilder<B, F> enableLogging(boolean enabled) {
        this.loggingEnabled = enabled;
        return this;
    }

    @NotNull
    public final FetchBuilder<B, F> enabledInMemoryDatabase(boolean enabled) {
        this.inMemoryDatabaseEnabled = enabled;
        return this;
    }

    @NotNull
    public final FetchBuilder<B, F> setDownloadBufferSize(int bytes) {
        if (bytes < 1) {
            throw (Throwable)new FetchException("Buffer size cannot be less than 1.", FetchException.Code.ILLEGAL_ARGUMENT);
        }
        this.downloadBufferSizeBytes = bytes;
        return this;
    }

    @NotNull
    public final FetchBuilder<B, F> setLogger(@NotNull Logger logger) {
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        this.logger = logger;
        return this;
    }

    @NotNull
    public final FetchBuilderPrefs getBuilderPrefs() {
        Logger prefsLogger = this.logger;
        if (prefsLogger instanceof FetchLogger) {
            prefsLogger.setEnabled(this.loggingEnabled);
            ((FetchLogger)prefsLogger).setTag(this.namespace);
        } else {
            this.logger.setEnabled(this.loggingEnabled);
        }
        Context context = this.appContext;
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"appContext");
        return new FetchBuilderPrefs(context, this.namespace, this.concurrentLimit, this.progressReportingIntervalMillis, this.downloadBufferSizeBytes, this.loggingEnabled, this.inMemoryDatabaseEnabled, this.downloader, this.globalNetworkType, prefsLogger);
    }

    public abstract F build();

    public FetchBuilder(@NotNull Context context, @NotNull String namespace) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)namespace, (String)"namespace");
        this.namespace = namespace;
        this.appContext = context.getApplicationContext();
        this.concurrentLimit = 1;
        this.progressReportingIntervalMillis = 2000L;
        this.downloadBufferSizeBytes = 8192;
        this.downloader = FetchDefaults.getDefaultDownloader();
        this.globalNetworkType = FetchDefaults.getDefaultGlobalNetworkType();
        this.logger = FetchDefaults.getDefaultLogger();
    }
}

