/*
 * Decompiled with CFR 0.152.
 */
package com.tonyodev.fetch2.database;

import android.arch.persistence.room.Room;
import android.arch.persistence.room.RoomDatabase;
import android.content.Context;
import com.tonyodev.fetch2.Logger;
import com.tonyodev.fetch2.Status;
import com.tonyodev.fetch2.database.DatabaseManager;
import com.tonyodev.fetch2.database.DownloadDatabase;
import com.tonyodev.fetch2.database.DownloadInfo;
import com.tonyodev.fetch2.exception.FetchImplementationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0016\u0010\u001c\u001a\u00020\u001b2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001e0 H\u0016J\b\u0010!\u001a\u00020\u001bH\u0016J\u000e\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001e0 H\u0016J\u0012\u0010\"\u001a\u0004\u0018\u00010\u001e2\u0006\u0010#\u001a\u00020$H\u0016J\u001e\u0010\"\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001e0 2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020$0 H\u0016J\u0016\u0010&\u001a\b\u0012\u0004\u0012\u00020\u001e0 2\u0006\u0010'\u001a\u00020$H\u0016J\u0016\u0010(\u001a\b\u0012\u0004\u0012\u00020\u001e0 2\u0006\u0010)\u001a\u00020*H\u0016J\u001e\u0010+\u001a\b\u0012\u0004\u0012\u00020\u001e0 2\u0006\u0010,\u001a\u00020$2\u0006\u0010)\u001a\u00020*H\u0016J\u001c\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u00070.2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J(\u0010-\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u00070.0 2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001e0 H\u0016J\b\u0010/\u001a\u00020\u001bH\u0016J\u0010\u00100\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0016\u00100\u001a\u00020\u001b2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001e0 H\u0016R\u0012\u0010\u000b\u001a\u00020\u00078\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u00061"}, d2={"Lcom/tonyodev/fetch2/database/DatabaseManagerImpl;", "Lcom/tonyodev/fetch2/database/DatabaseManager;", "context", "Landroid/content/Context;", "namespace", "", "isMemoryDatabase", "", "logger", "Lcom/tonyodev/fetch2/Logger;", "(Landroid/content/Context;Ljava/lang/String;ZLcom/tonyodev/fetch2/Logger;)V", "closed", "isClosed", "()Z", "lock", "Ljava/lang/Object;", "getLock", "()Ljava/lang/Object;", "getLogger", "()Lcom/tonyodev/fetch2/Logger;", "getNamespace", "()Ljava/lang/String;", "requestDatabaseInternal", "Lcom/tonyodev/fetch2/database/DownloadDatabase;", "getRequestDatabaseInternal", "()Lcom/tonyodev/fetch2/database/DownloadDatabase;", "close", "", "delete", "downloadInfo", "Lcom/tonyodev/fetch2/database/DownloadInfo;", "downloadInfoList", "", "deleteAll", "get", "id", "", "ids", "getByGroup", "group", "getByStatus", "status", "Lcom/tonyodev/fetch2/Status;", "getDownloadsInGroupWithStatus", "groupId", "insert", "Lkotlin/Pair;", "throwExceptionIfClosed", "update", "fetch2_release"})
public class DatabaseManagerImpl
implements DatabaseManager {
    @NotNull
    private final Object lock;
    private volatile boolean closed;
    @NotNull
    private final DownloadDatabase requestDatabaseInternal;
    @NotNull
    private final String namespace;
    private final boolean isMemoryDatabase;
    @NotNull
    private final Logger logger;

    @NotNull
    public final Object getLock() {
        return this.lock;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @NotNull
    public DownloadDatabase getRequestDatabaseInternal() {
        return this.requestDatabaseInternal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Pair<DownloadInfo, Boolean> insert(@NotNull DownloadInfo downloadInfo) {
        Intrinsics.checkParameterIsNotNull((Object)downloadInfo, (String)"downloadInfo");
        Object object = this.lock;
        synchronized (object) {
            this.throwExceptionIfClosed();
            long row = this.getRequestDatabaseInternal().requestDao().insert(downloadInfo);
            Pair pair = new Pair((Object)downloadInfo, (Object)this.getRequestDatabaseInternal().wasRowInserted(row));
            return pair;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Pair<DownloadInfo, Boolean>> insert(@NotNull List<DownloadInfo> downloadInfoList) {
        Intrinsics.checkParameterIsNotNull(downloadInfoList, (String)"downloadInfoList");
        Object object = this.lock;
        synchronized (object) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            this.throwExceptionIfClosed();
            List<Long> rowsList = this.getRequestDatabaseInternal().requestDao().insert(downloadInfoList);
            Iterable iterable = $receiver$iv = (Iterable)CollectionsKt.getIndices((Collection)rowsList);
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            Iterator iterator = $receiver$iv$iv.iterator();
            while (iterator.hasNext()) {
                void it;
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator).nextInt();
                Collection collection = destination$iv$iv;
                Pair pair = new Pair((Object)downloadInfoList.get((int)it), (Object)this.getRequestDatabaseInternal().wasRowInserted(((Number)rowsList.get((int)it)).longValue()));
                Pair pair2 = pair;
                collection.add(pair2);
            }
            List list = (List)destination$iv$iv;
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(@NotNull DownloadInfo downloadInfo) {
        Intrinsics.checkParameterIsNotNull((Object)downloadInfo, (String)"downloadInfo");
        Object object = this.lock;
        synchronized (object) {
            this.throwExceptionIfClosed();
            this.getRequestDatabaseInternal().requestDao().delete(downloadInfo);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(@NotNull List<DownloadInfo> downloadInfoList) {
        Intrinsics.checkParameterIsNotNull(downloadInfoList, (String)"downloadInfoList");
        Object object = this.lock;
        synchronized (object) {
            this.throwExceptionIfClosed();
            this.getRequestDatabaseInternal().requestDao().delete(downloadInfoList);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteAll() {
        Object object = this.lock;
        synchronized (object) {
            this.throwExceptionIfClosed();
            this.getRequestDatabaseInternal().requestDao().deleteAll();
            this.getLogger().d("Cleared Database " + this.namespace + ".db");
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(@NotNull DownloadInfo downloadInfo) {
        Intrinsics.checkParameterIsNotNull((Object)downloadInfo, (String)"downloadInfo");
        Object object = this.lock;
        synchronized (object) {
            this.throwExceptionIfClosed();
            this.getRequestDatabaseInternal().requestDao().update(downloadInfo);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(@NotNull List<DownloadInfo> downloadInfoList) {
        Intrinsics.checkParameterIsNotNull(downloadInfoList, (String)"downloadInfoList");
        Object object = this.lock;
        synchronized (object) {
            this.throwExceptionIfClosed();
            this.getRequestDatabaseInternal().requestDao().update(downloadInfoList);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<DownloadInfo> get() {
        Object object = this.lock;
        synchronized (object) {
            this.throwExceptionIfClosed();
            List<DownloadInfo> list = this.getRequestDatabaseInternal().requestDao().get();
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public DownloadInfo get(int id) {
        Object object = this.lock;
        synchronized (object) {
            this.throwExceptionIfClosed();
            DownloadInfo downloadInfo = this.getRequestDatabaseInternal().requestDao().get(id);
            return downloadInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<DownloadInfo> get(@NotNull List<Integer> ids) {
        Intrinsics.checkParameterIsNotNull(ids, (String)"ids");
        Object object = this.lock;
        synchronized (object) {
            this.throwExceptionIfClosed();
            List<DownloadInfo> list = this.getRequestDatabaseInternal().requestDao().get(ids);
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<DownloadInfo> getByStatus(@NotNull Status status) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)status), (String)"status");
        Object object = this.lock;
        synchronized (object) {
            this.throwExceptionIfClosed();
            List<DownloadInfo> list = this.getRequestDatabaseInternal().requestDao().getByStatus(status);
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<DownloadInfo> getByGroup(int group) {
        Object object = this.lock;
        synchronized (object) {
            this.throwExceptionIfClosed();
            List<DownloadInfo> list = this.getRequestDatabaseInternal().requestDao().getByGroup(group);
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<DownloadInfo> getDownloadsInGroupWithStatus(int groupId, @NotNull Status status) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)status), (String)"status");
        Object object = this.lock;
        synchronized (object) {
            List<DownloadInfo> list = this.getRequestDatabaseInternal().requestDao().getByGroupWithStatus(groupId, status);
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.getRequestDatabaseInternal().close();
            this.getLogger().d("Database closed");
            Unit unit = Unit.INSTANCE;
        }
    }

    public void throwExceptionIfClosed() {
        if (this.closed) {
            throw (Throwable)new FetchImplementationException("database is closed", FetchImplementationException.Code.CLOSED);
        }
    }

    @NotNull
    public final String getNamespace() {
        return this.namespace;
    }

    @Override
    public boolean isMemoryDatabase() {
        return this.isMemoryDatabase;
    }

    @Override
    @NotNull
    public Logger getLogger() {
        return this.logger;
    }

    public DatabaseManagerImpl(@NotNull Context context, @NotNull String namespace, boolean isMemoryDatabase, @NotNull Logger logger) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)namespace, (String)"namespace");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        this.namespace = namespace;
        this.isMemoryDatabase = isMemoryDatabase;
        this.logger = logger;
        this.lock = new Object();
        this.requestDatabaseInternal = (DownloadDatabase)((Object)((Function0)new Function0<DownloadDatabase>(this, context){
            final /* synthetic */ DatabaseManagerImpl this$0;
            final /* synthetic */ Context $context;

            @NotNull
            public final DownloadDatabase invoke() {
                RoomDatabase.Builder builder;
                if (this.this$0.isMemoryDatabase()) {
                    this.this$0.getLogger().d("Init in memory database named " + this.this$0.getNamespace());
                    builder = Room.inMemoryDatabaseBuilder((Context)this.$context, DownloadDatabase.class);
                } else {
                    this.this$0.getLogger().d("Init file based database named " + this.this$0.getNamespace() + ".db");
                    builder = Room.databaseBuilder((Context)this.$context, DownloadDatabase.class, (String)("" + this.this$0.getNamespace() + ".db"));
                }
                RoomDatabase.Builder builder2 = builder;
                return (DownloadDatabase)builder2.build();
            }
            {
                this.this$0 = databaseManagerImpl;
                this.$context = context;
                super(0);
            }
        }).invoke());
    }
}

