/*
 * Decompiled with CFR 0.152.
 */
package com.tonyodev.fetch2.util;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\f\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0011\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0011\u001a\u00020\u000eJ\u0006\u0010\u0012\u001a\u00020\u0003J\b\u0010\u0013\u001a\u00020\u000eH\u0002J\u0006\u0010\u0014\u001a\u00020\u0010J\u0010\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0003H\u0002J\u0006\u0010\u0017\u001a\u00020\u0010J\u0006\u0010\u0018\u001a\u00020\u0010J\u0012\u0010\u0019\u001a\u00020\u00102\b\b\u0002\u0010\u001a\u001a\u00020\u0003H\u0007J\u0012\u0010\u001b\u001a\u00020\u00102\b\b\u0002\u0010\u001a\u001a\u00020\u0003H\u0007J\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00100\u001dJ\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/tonyodev/fetch2/util/AverageCalculator;", "", "discardLimit", "", "(I)V", "defaultIndexPosition", "defaultValueListSize", "getDiscardLimit", "()I", "endIndex", "startIndex", "valueList", "", "add", "", "value", "", "clear", "count", "expandValueList", "getAverage", "getDenominator", "number", "getFirstInputValue", "getLastInputValue", "getMovingAverageWithWeightOnOlderValues", "inclusionCount", "getMovingAverageWithWeightOnRecentValues", "getValues", "", "hasInputValue", "", "fetch2_release"})
public final class AverageCalculator {
    private final int defaultValueListSize = 16;
    private final int defaultIndexPosition = -1;
    private double[] valueList;
    private int startIndex;
    private int endIndex;
    private final int discardLimit;

    public final void add(double value) {
        if (this.discardLimit > 0 && this.count() == this.discardLimit) {
            ++this.startIndex;
        }
        if (this.endIndex == this.valueList.length - 1) {
            this.expandValueList();
        }
        ++this.endIndex;
        if (this.endIndex == 0) {
            this.startIndex = this.endIndex;
        }
        this.valueList[this.endIndex] = value;
    }

    private final void expandValueList() {
        double[] newList = new double[this.valueList.length * 2];
        int length = this.count();
        System.arraycopy(this.valueList, this.startIndex, newList, 0, length);
        this.valueList = newList;
        this.startIndex = 0;
        this.endIndex = length - 1;
    }

    public final void clear() {
        this.valueList = new double[this.defaultValueListSize];
        this.startIndex = this.defaultIndexPosition;
        this.endIndex = this.defaultIndexPosition;
    }

    public final int count() {
        return this.endIndex - this.startIndex + 1;
    }

    public final double getLastInputValue() {
        if (this.count() < 1) {
            throw (Throwable)new ArrayIndexOutOfBoundsException("value array is empty");
        }
        return this.valueList[this.endIndex];
    }

    public final double getFirstInputValue() {
        if (this.count() < 1) {
            throw (Throwable)new ArrayIndexOutOfBoundsException("value array is empty");
        }
        return this.valueList[this.startIndex];
    }

    public final boolean hasInputValue(double value) {
        return ArraysKt.contains((double[])this.valueList, (double)value);
    }

    @NotNull
    public final List<Double> getValues() {
        return ArraysKt.toList((double[])this.valueList);
    }

    /*
     * WARNING - void declaration
     */
    public final double getAverage() {
        double total = 0.0;
        int n = this.startIndex;
        int n2 = this.endIndex;
        if (n <= n2) {
            while (true) {
                void index;
                total += this.valueList[index];
                if (index == n2) break;
                ++index;
            }
        }
        return total / (double)this.count();
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public final double getMovingAverageWithWeightOnRecentValues(int inclusionCount) {
        if (inclusionCount < 1) {
            throw (Throwable)new IllegalArgumentException("inclusionCount cannot be less than 1.");
        }
        if (inclusionCount > this.count()) {
            throw (Throwable)new IllegalArgumentException("inclusionCount cannot be greater than the inserted value count.");
        }
        double movingAverage = 0.0;
        int weight = inclusionCount;
        double denominator = this.getDenominator(inclusionCount);
        int n = this.endIndex;
        int n2 = this.endIndex - (inclusionCount - 1);
        if (n >= n2) {
            while (true) {
                void index;
                movingAverage += this.valueList[index] * ((double)weight / denominator);
                --weight;
                if (index == n2) break;
                --index;
            }
        }
        return movingAverage;
    }

    @JvmOverloads
    public static /* bridge */ /* synthetic */ double getMovingAverageWithWeightOnRecentValues$default(AverageCalculator averageCalculator, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = averageCalculator.count();
        }
        return averageCalculator.getMovingAverageWithWeightOnRecentValues(n);
    }

    @JvmOverloads
    public final double getMovingAverageWithWeightOnRecentValues() {
        return AverageCalculator.getMovingAverageWithWeightOnRecentValues$default(this, 0, 1, null);
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public final double getMovingAverageWithWeightOnOlderValues(int inclusionCount) {
        if (inclusionCount < 1) {
            throw (Throwable)new IllegalArgumentException("inclusionCount cannot be less than 1.");
        }
        if (inclusionCount > this.count()) {
            throw (Throwable)new IllegalArgumentException("inclusionCount cannot be greater than the inserted value count.");
        }
        double movingAverage = 0.0;
        int weight = inclusionCount;
        double denominator = this.getDenominator(inclusionCount);
        int n = this.startIndex;
        int n2 = this.startIndex + (inclusionCount - 1);
        if (n <= n2) {
            while (true) {
                void index;
                movingAverage += this.valueList[index] * ((double)weight / denominator);
                --weight;
                if (index == n2) break;
                ++index;
            }
        }
        return movingAverage;
    }

    @JvmOverloads
    public static /* bridge */ /* synthetic */ double getMovingAverageWithWeightOnOlderValues$default(AverageCalculator averageCalculator, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = averageCalculator.count();
        }
        return averageCalculator.getMovingAverageWithWeightOnOlderValues(n);
    }

    @JvmOverloads
    public final double getMovingAverageWithWeightOnOlderValues() {
        return AverageCalculator.getMovingAverageWithWeightOnOlderValues$default(this, 0, 1, null);
    }

    /*
     * WARNING - void declaration
     */
    private final double getDenominator(int number) {
        double total = 0.0;
        int n = 1;
        int n2 = number;
        if (n <= n2) {
            while (true) {
                void n3;
                total += (double)n3;
                if (n3 == n2) break;
                ++n3;
            }
        }
        return total;
    }

    public final int getDiscardLimit() {
        return this.discardLimit;
    }

    @JvmOverloads
    public AverageCalculator(int discardLimit) {
        this.discardLimit = discardLimit;
        this.defaultValueListSize = 16;
        this.defaultIndexPosition = -1;
        this.valueList = new double[this.defaultValueListSize];
        this.startIndex = this.defaultIndexPosition;
        this.endIndex = this.defaultIndexPosition;
    }

    @JvmOverloads
    public /* synthetic */ AverageCalculator(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        this(n);
    }

    @JvmOverloads
    public AverageCalculator() {
        this(0, 1, null);
    }
}

