/*
 * Decompiled with CFR 0.152.
 */
package com.tonyodev.fetch2.helper;

import android.os.Handler;
import com.tonyodev.fetch2.Download;
import com.tonyodev.fetch2.Logger;
import com.tonyodev.fetch2.NetworkType;
import com.tonyodev.fetch2.downloader.DownloadManager;
import com.tonyodev.fetch2.helper.PriorityListProcessor;
import com.tonyodev.fetch2.provider.DownloadProvider;
import com.tonyodev.fetch2.provider.NetworkInfoProvider;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\b\u0010\u001e\u001a\u00020\u0015H\u0002J\u000e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00020 H\u0016J\b\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020\"H\u0002J\b\u0010$\u001a\u00020\"H\u0016J\b\u0010%\u001a\u00020\"H\u0016J\b\u0010&\u001a\u00020\"H\u0016J\b\u0010'\u001a\u00020\"H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000e\u001a\u00020\u000f8\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0016R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001a\u001a\u00020\u00158\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001d\u001a\u00020\u00158\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/tonyodev/fetch2/helper/PriorityListProcessorImpl;", "Lcom/tonyodev/fetch2/helper/PriorityListProcessor;", "Lcom/tonyodev/fetch2/Download;", "handler", "Landroid/os/Handler;", "downloadProvider", "Lcom/tonyodev/fetch2/provider/DownloadProvider;", "downloadManager", "Lcom/tonyodev/fetch2/downloader/DownloadManager;", "networkInfoProvider", "Lcom/tonyodev/fetch2/provider/NetworkInfoProvider;", "logger", "Lcom/tonyodev/fetch2/Logger;", "(Landroid/os/Handler;Lcom/tonyodev/fetch2/provider/DownloadProvider;Lcom/tonyodev/fetch2/downloader/DownloadManager;Lcom/tonyodev/fetch2/provider/NetworkInfoProvider;Lcom/tonyodev/fetch2/Logger;)V", "globalNetworkType", "Lcom/tonyodev/fetch2/NetworkType;", "getGlobalNetworkType", "()Lcom/tonyodev/fetch2/NetworkType;", "setGlobalNetworkType", "(Lcom/tonyodev/fetch2/NetworkType;)V", "isPaused", "", "()Z", "isStopped", "lock", "Ljava/lang/Object;", "paused", "priorityIteratorRunnable", "Ljava/lang/Runnable;", "stopped", "canContinueToProcess", "getPriorityList", "", "pause", "", "registerPriorityIterator", "resume", "start", "stop", "unregisterPriorityIterator", "fetch2_release"})
public final class PriorityListProcessorImpl
implements PriorityListProcessor<Download> {
    private final Object lock;
    @NotNull
    private volatile NetworkType globalNetworkType;
    private volatile boolean paused;
    private volatile boolean stopped;
    private final Runnable priorityIteratorRunnable;
    private final Handler handler;
    private final DownloadProvider downloadProvider;
    private final DownloadManager downloadManager;
    private final NetworkInfoProvider networkInfoProvider;
    private final Logger logger;

    @Override
    @NotNull
    public NetworkType getGlobalNetworkType() {
        return this.globalNetworkType;
    }

    @Override
    public void setGlobalNetworkType(@NotNull NetworkType networkType) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)networkType), (String)"<set-?>");
        this.globalNetworkType = networkType;
    }

    @Override
    public boolean isPaused() {
        return this.paused;
    }

    @Override
    public boolean isStopped() {
        return this.stopped;
    }

    private final boolean canContinueToProcess() {
        return !this.stopped && !this.paused;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        Object object = this.lock;
        synchronized (object) {
            this.stopped = false;
            this.paused = false;
            this.registerPriorityIterator();
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            this.unregisterPriorityIterator();
            this.paused = false;
            this.stopped = true;
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pause() {
        Object object = this.lock;
        synchronized (object) {
            this.unregisterPriorityIterator();
            this.paused = true;
            this.stopped = false;
            this.downloadManager.cancelAll();
            this.logger.d("PriorityIterator paused");
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resume() {
        Object object = this.lock;
        synchronized (object) {
            this.paused = false;
            this.stopped = false;
            this.registerPriorityIterator();
            this.logger.d("PriorityIterator resumed");
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<Download> getPriorityList() {
        Object object = this.lock;
        synchronized (object) {
            List list;
            try {
                list = this.downloadProvider.getPendingDownloadsSorted();
            }
            catch (Exception e) {
                this.logger.d("PriorityIterator failed access database", e);
                list = CollectionsKt.emptyList();
            }
            List list2 = list;
            return list2;
        }
    }

    private final void registerPriorityIterator() {
        this.handler.postDelayed(this.priorityIteratorRunnable, 500L);
    }

    private final void unregisterPriorityIterator() {
        this.handler.removeCallbacks(this.priorityIteratorRunnable);
    }

    public PriorityListProcessorImpl(@NotNull Handler handler, @NotNull DownloadProvider downloadProvider, @NotNull DownloadManager downloadManager, @NotNull NetworkInfoProvider networkInfoProvider, @NotNull Logger logger) {
        Intrinsics.checkParameterIsNotNull((Object)handler, (String)"handler");
        Intrinsics.checkParameterIsNotNull((Object)downloadProvider, (String)"downloadProvider");
        Intrinsics.checkParameterIsNotNull((Object)downloadManager, (String)"downloadManager");
        Intrinsics.checkParameterIsNotNull((Object)networkInfoProvider, (String)"networkInfoProvider");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        this.handler = handler;
        this.downloadProvider = downloadProvider;
        this.downloadManager = downloadManager;
        this.networkInfoProvider = networkInfoProvider;
        this.logger = logger;
        this.lock = new Object();
        this.globalNetworkType = NetworkType.GLOBAL_OFF;
        this.priorityIteratorRunnable = new Runnable(this){
            final /* synthetic */ PriorityListProcessorImpl this$0;

            /*
             * WARNING - void declaration
             */
            public final void run() {
                if (PriorityListProcessorImpl.access$canContinueToProcess(this.this$0)) {
                    List<Download> priorityList;
                    int n;
                    int n2;
                    if (PriorityListProcessorImpl.access$getNetworkInfoProvider$p(this.this$0).isNetworkAvailable() && (n2 = 0) <= (n = CollectionsKt.getLastIndex(priorityList = this.this$0.getPriorityList()))) {
                        while (PriorityListProcessorImpl.access$getDownloadManager$p(this.this$0).canAccommodateNewDownload() && PriorityListProcessorImpl.access$canContinueToProcess(this.this$0)) {
                            NetworkType networkType;
                            void index;
                            Download download = priorityList.get((int)index);
                            NetworkType networkType2 = Intrinsics.areEqual((Object)((Object)this.this$0.getGlobalNetworkType()), (Object)((Object)NetworkType.GLOBAL_OFF)) ^ true ? this.this$0.getGlobalNetworkType() : (networkType = Intrinsics.areEqual((Object)((Object)download.getNetworkType()), (Object)((Object)NetworkType.GLOBAL_OFF)) ? NetworkType.ALL : download.getNetworkType());
                            if (PriorityListProcessorImpl.access$getNetworkInfoProvider$p(this.this$0).isOnAllowedNetwork(networkType) && PriorityListProcessorImpl.access$canContinueToProcess(this.this$0)) {
                                PriorityListProcessorImpl.access$getDownloadManager$p(this.this$0).start(download);
                            }
                            if (index == n) break;
                            ++index;
                        }
                    }
                    if (PriorityListProcessorImpl.access$canContinueToProcess(this.this$0)) {
                        PriorityListProcessorImpl.access$registerPriorityIterator(this.this$0);
                    }
                }
            }
            {
                this.this$0 = priorityListProcessorImpl;
            }
        };
    }

    public static final /* synthetic */ boolean access$canContinueToProcess(PriorityListProcessorImpl $this) {
        return $this.canContinueToProcess();
    }

    @NotNull
    public static final /* synthetic */ NetworkInfoProvider access$getNetworkInfoProvider$p(PriorityListProcessorImpl $this) {
        return $this.networkInfoProvider;
    }

    @NotNull
    public static final /* synthetic */ DownloadManager access$getDownloadManager$p(PriorityListProcessorImpl $this) {
        return $this.downloadManager;
    }

    public static final /* synthetic */ void access$registerPriorityIterator(PriorityListProcessorImpl $this) {
        $this.registerPriorityIterator();
    }
}

