/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling.helper;

import ch.qos.logback.core.rolling.helper.PeriodicityType;
import ch.qos.logback.core.spi.ContextAwareBase;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Pattern;

public class RollingCalendar
extends GregorianCalendar {
    private static final long serialVersionUID = -5937537740925066161L;
    static final TimeZone GMT_TIMEZONE = TimeZone.getTimeZone("GMT");
    private PeriodicityType periodicityType = PeriodicityType.ERRONEOUS;
    private String datePattern;
    private static final HashMap<Character, PeriodicityType> PATTERN_LETTER_TO_PERIODICITY = new LinkedHashMap<Character, PeriodicityType>();

    public RollingCalendar(String datePattern) {
        this(datePattern, GMT_TIMEZONE, Locale.US);
    }

    public RollingCalendar(String datePattern, TimeZone tz, Locale locale) {
        super(tz, locale);
        this.datePattern = datePattern;
        this.periodicityType = this.computePeriodicityType();
    }

    public PeriodicityType getPeriodicityType() {
        return this.periodicityType;
    }

    public PeriodicityType computePeriodicityType() {
        if (this.datePattern != null) {
            for (Map.Entry<Character, PeriodicityType> entry : PATTERN_LETTER_TO_PERIODICITY.entrySet()) {
                if (this.datePattern.indexOf(entry.getKey().charValue()) <= -1) continue;
                return entry.getValue();
            }
        }
        return PeriodicityType.ERRONEOUS;
    }

    public boolean isCollisionFree() {
        switch (this.periodicityType) {
            case TOP_OF_HOUR: {
                return !this.collision(43200000L);
            }
            case TOP_OF_DAY: {
                if (this.collision(604800000L)) {
                    return false;
                }
                if (this.collision(2678400000L)) {
                    return false;
                }
                return !this.collision(31536000000L);
            }
            case TOP_OF_WEEK: {
                if (this.collision(2937600000L)) {
                    return false;
                }
                return !this.collision(31622400000L);
            }
        }
        return true;
    }

    private boolean collision(long delta) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.datePattern, Locale.US);
        simpleDateFormat.setTimeZone(GMT_TIMEZONE);
        Date epoch0 = new Date(0L);
        String r0 = simpleDateFormat.format(epoch0);
        Date epoch12 = new Date(delta);
        String r12 = simpleDateFormat.format(epoch12);
        return r0.equals(r12);
    }

    public void printPeriodicity(ContextAwareBase cab) {
        switch (this.periodicityType) {
            case TOP_OF_MILLISECOND: {
                cab.addInfo("Roll-over every millisecond.");
                break;
            }
            case TOP_OF_SECOND: {
                cab.addInfo("Roll-over every second.");
                break;
            }
            case TOP_OF_MINUTE: {
                cab.addInfo("Roll-over every minute.");
                break;
            }
            case TOP_OF_HOUR: {
                cab.addInfo("Roll-over at the top of every hour.");
                break;
            }
            case HALF_DAY: {
                cab.addInfo("Roll-over at midday and midnight.");
                break;
            }
            case TOP_OF_DAY: {
                cab.addInfo("Roll-over at midnight.");
                break;
            }
            case TOP_OF_WEEK: {
                cab.addInfo("Rollover at the start of week.");
                break;
            }
            case TOP_OF_MONTH: {
                cab.addInfo("Rollover at start of every month.");
                break;
            }
            default: {
                cab.addInfo("Unknown periodicity.");
            }
        }
    }

    public Date getEndOfNextNthPeriod(Date now, int numPeriods) {
        RollingCalendar cal = this;
        cal.setTime(now);
        this.roundDownTime(cal, this.datePattern);
        switch (this.periodicityType) {
            case TOP_OF_MILLISECOND: {
                ((Calendar)cal).add(14, numPeriods);
                break;
            }
            case TOP_OF_SECOND: {
                ((Calendar)cal).add(13, numPeriods);
                break;
            }
            case TOP_OF_MINUTE: {
                ((Calendar)cal).add(12, numPeriods);
                break;
            }
            case TOP_OF_HOUR: {
                ((Calendar)cal).add(11, numPeriods);
                break;
            }
            case TOP_OF_DAY: {
                ((Calendar)cal).add(5, numPeriods);
                break;
            }
            case TOP_OF_WEEK: {
                cal.set(7, cal.getFirstDayOfWeek());
                ((Calendar)cal).add(3, numPeriods);
                break;
            }
            case TOP_OF_MONTH: {
                ((Calendar)cal).add(2, numPeriods);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown periodicity type.");
            }
        }
        return cal.getTime();
    }

    public Date getNextTriggeringDate(Date now) {
        return this.getEndOfNextNthPeriod(now, 1);
    }

    public Date normalizeDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        this.roundDownTime(cal, this.datePattern);
        return cal.getTime();
    }

    private void roundDownTime(Calendar cal, String datePattern) {
        Pattern monthPattern;
        Pattern dayOfMonthPattern;
        Pattern hourOfDayPattern;
        if (datePattern.indexOf(83) == -1) {
            cal.roll(14, -cal.get(14));
        }
        if (datePattern.indexOf(115) == -1) {
            cal.roll(13, -cal.get(13));
        }
        if (datePattern.indexOf(109) == -1) {
            cal.roll(12, -cal.get(12));
        }
        if (!(hourOfDayPattern = Pattern.compile("[hKkH]")).matcher(datePattern).find()) {
            cal.roll(11, -cal.get(11));
        }
        if (!(dayOfMonthPattern = Pattern.compile("[uEFdD]")).matcher(datePattern).find()) {
            cal.set(5, 1);
        }
        if (!(monthPattern = Pattern.compile("[MDw]")).matcher(datePattern).find()) {
            cal.set(2, 0);
        }
    }

    static {
        PATTERN_LETTER_TO_PERIODICITY.put(Character.valueOf('S'), PeriodicityType.TOP_OF_MILLISECOND);
        PATTERN_LETTER_TO_PERIODICITY.put(Character.valueOf('s'), PeriodicityType.TOP_OF_SECOND);
        PATTERN_LETTER_TO_PERIODICITY.put(Character.valueOf('m'), PeriodicityType.TOP_OF_MINUTE);
        PATTERN_LETTER_TO_PERIODICITY.put(Character.valueOf('h'), PeriodicityType.TOP_OF_HOUR);
        PATTERN_LETTER_TO_PERIODICITY.put(Character.valueOf('K'), PeriodicityType.TOP_OF_HOUR);
        PATTERN_LETTER_TO_PERIODICITY.put(Character.valueOf('k'), PeriodicityType.TOP_OF_HOUR);
        PATTERN_LETTER_TO_PERIODICITY.put(Character.valueOf('H'), PeriodicityType.TOP_OF_HOUR);
        PATTERN_LETTER_TO_PERIODICITY.put(Character.valueOf('a'), PeriodicityType.HALF_DAY);
        PATTERN_LETTER_TO_PERIODICITY.put(Character.valueOf('u'), PeriodicityType.TOP_OF_DAY);
        PATTERN_LETTER_TO_PERIODICITY.put(Character.valueOf('E'), PeriodicityType.TOP_OF_DAY);
        PATTERN_LETTER_TO_PERIODICITY.put(Character.valueOf('F'), PeriodicityType.TOP_OF_DAY);
        PATTERN_LETTER_TO_PERIODICITY.put(Character.valueOf('d'), PeriodicityType.TOP_OF_DAY);
        PATTERN_LETTER_TO_PERIODICITY.put(Character.valueOf('D'), PeriodicityType.TOP_OF_DAY);
        PATTERN_LETTER_TO_PERIODICITY.put(Character.valueOf('W'), PeriodicityType.TOP_OF_WEEK);
        PATTERN_LETTER_TO_PERIODICITY.put(Character.valueOf('w'), PeriodicityType.TOP_OF_WEEK);
        PATTERN_LETTER_TO_PERIODICITY.put(Character.valueOf('M'), PeriodicityType.TOP_OF_MONTH);
        PATTERN_LETTER_TO_PERIODICITY.put(Character.valueOf('Y'), PeriodicityType.TOP_OF_WEEK);
    }
}

