/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling.helper;

import ch.qos.logback.core.rolling.helper.FileFinder;
import ch.qos.logback.core.rolling.helper.FileNamePattern;
import ch.qos.logback.core.rolling.helper.FilenameParser;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class IntParser
implements FilenameParser<Integer> {
    private final Pattern pathPattern;

    IntParser(FileNamePattern fileNamePattern) {
        String pathRegexString = fileNamePattern.toRegex(false, true);
        pathRegexString = FileFinder.unescapePath(pathRegexString);
        this.pathPattern = Pattern.compile(pathRegexString);
    }

    @Override
    public Integer parseFilename(String filename) {
        Integer intValue = -1;
        try {
            intValue = Integer.parseInt(this.findToken(filename), 10);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return intValue;
    }

    private String findToken(String input) {
        Matcher m = this.pathPattern.matcher(input);
        return m.find() && m.groupCount() >= 1 ? m.group(1) : "";
    }
}

