/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.pattern;

import ch.qos.logback.classic.pattern.ClassicConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.util.CachingDateFormatter;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;

public class DateConverter
extends ClassicConverter {
    CachingDateFormatter cachingDateFormatter = null;

    public void start() {
        String datePattern = this.getFirstOption();
        if (datePattern == null) {
            datePattern = "yyyy-MM-dd HH:mm:ss,SSS";
        }
        if (datePattern.equals("ISO8601")) {
            datePattern = "yyyy-MM-dd HH:mm:ss,SSS";
        }
        TimeZone tz = TimeZone.getDefault();
        Locale locale = Locale.ENGLISH;
        List<String> optionList = this.getOptionList();
        if (optionList != null) {
            if (optionList.size() > 1) {
                tz = TimeZone.getTimeZone(optionList.get(1));
            }
            if (optionList.size() > 2) {
                locale = this.parseLocale(optionList.get(2));
            }
        }
        try {
            this.cachingDateFormatter = new CachingDateFormatter(datePattern, locale);
        }
        catch (IllegalArgumentException e) {
            this.addWarn("Could not instantiate SimpleDateFormat with pattern " + datePattern, e);
            this.cachingDateFormatter = new CachingDateFormatter("yyyy-MM-dd HH:mm:ss,SSS", locale);
        }
        this.cachingDateFormatter.setTimeZone(tz);
    }

    private Locale parseLocale(String input) {
        String[] localeParts = input.split(",");
        Locale locale = localeParts.length > 1 ? new Locale(localeParts[0], localeParts[1]) : new Locale(localeParts[0]);
        return locale;
    }

    public String convert(ILoggingEvent le) {
        long timestamp = le.getTimeStamp();
        return this.cachingDateFormatter.format(timestamp);
    }
}

