/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.android;

import android.annotation.TargetApi;
import android.content.ContextWrapper;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Environment;
import ch.qos.logback.classic.LoggerContext;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Properties;

public class AndroidContextUtil {
    private ContextWrapper context;

    public AndroidContextUtil() {
        this(AndroidContextUtil.getContext());
    }

    public AndroidContextUtil(ContextWrapper contextWrapper) {
        this.context = contextWrapper;
    }

    public void setupProperties(LoggerContext context) {
        Properties props = new Properties();
        props.setProperty("DATA_DIR", this.getFilesDirectoryPath());
        String extDir = this.getMountedExternalStorageDirectoryPath();
        if (extDir != null) {
            props.setProperty("EXT_DIR", extDir);
        }
        props.setProperty("PACKAGE_NAME", this.getPackageName());
        props.setProperty("VERSION_CODE", this.getVersionCode());
        props.setProperty("VERSION_NAME", this.getVersionName());
        context.putProperties(props);
    }

    private static ContextWrapper getContext() {
        try {
            Class<?> c = Class.forName("android.app.AppGlobals");
            Method method = c.getDeclaredMethod("getInitialApplication", new Class[0]);
            return (ContextWrapper)method.invoke(c, new Object[0]);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return null;
    }

    public String getMountedExternalStorageDirectoryPath() {
        String path = null;
        String state = Environment.getExternalStorageState();
        if (state.equals("mounted") || state.equals("mounted_ro")) {
            path = this.absPath(Environment.getExternalStorageDirectory());
        }
        return path;
    }

    public String getExternalStorageDirectoryPath() {
        return Environment.getExternalStorageDirectory().getAbsolutePath();
    }

    public String getExternalFilesDirectoryPath() {
        return this.context != null ? this.absPath(this.context.getExternalFilesDir(null)) : "";
    }

    public String getCacheDirectoryPath() {
        return this.context != null ? this.absPath(this.context.getCacheDir()) : "";
    }

    public String getExternalCacheDirectoryPath() {
        return this.context != null ? this.absPath(this.context.getExternalCacheDir()) : "";
    }

    public String getPackageName() {
        return this.context != null ? this.context.getPackageName() : "";
    }

    public String getFilesDirectoryPath() {
        return this.context != null ? this.absPath(this.context.getFilesDir()) : "";
    }

    @TargetApi(value=21)
    public String getNoBackupFilesDirectoryPath() {
        return Build.VERSION.SDK_INT >= 21 && this.context != null ? this.absPath(this.context.getNoBackupFilesDir()) : "";
    }

    public String getDatabaseDirectoryPath() {
        return this.context != null && this.context.getDatabasePath("x") != null ? this.context.getDatabasePath("x").getParent() : "";
    }

    public String getDatabasePath(String databaseName) {
        return this.context != null ? this.absPath(this.context.getDatabasePath(databaseName)) : "";
    }

    public String getVersionCode() {
        String versionCode = "";
        if (this.context != null) {
            try {
                PackageInfo pkgInfo = this.context.getPackageManager().getPackageInfo(this.getPackageName(), 0);
                versionCode = "" + pkgInfo.versionCode;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                // empty catch block
            }
        }
        return versionCode;
    }

    public String getVersionName() {
        String versionName = "";
        if (this.context != null) {
            try {
                PackageInfo pkgInfo = this.context.getPackageManager().getPackageInfo(this.getPackageName(), 0);
                versionName = pkgInfo.versionName;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                // empty catch block
            }
        }
        return versionName != null ? versionName : "";
    }

    private String absPath(File file) {
        return file != null ? file.getAbsolutePath() : "";
    }
}

