/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.util;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.android.AndroidContextUtil;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.status.InfoStatus;
import ch.qos.logback.core.status.StatusManager;
import ch.qos.logback.core.util.Loader;
import ch.qos.logback.core.util.OptionHelper;
import ch.qos.logback.core.util.StatusListenerConfigHelper;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

public class ContextInitializer {
    public static final String AUTOCONFIG_FILE = "assets/logback.xml";
    public static final String CONFIG_FILE_PROPERTY = "logback.configurationFile";
    final ClassLoader classLoader;
    final LoggerContext loggerContext;

    public ContextInitializer(LoggerContext loggerContext) {
        this.loggerContext = loggerContext;
        this.classLoader = Loader.getClassLoaderOfObject(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URL findConfigFileFromSystemProperties(boolean updateStatus) {
        String logbackConfigFile = OptionHelper.getSystemProperty(CONFIG_FILE_PROPERTY);
        if (logbackConfigFile != null) {
            URL result = null;
            try {
                File file = new File(logbackConfigFile);
                if (file.exists() && file.isFile()) {
                    if (updateStatus) {
                        this.statusOnResourceSearch(logbackConfigFile, this.classLoader, logbackConfigFile);
                    }
                    result = file.toURI().toURL();
                } else {
                    result = new URL(logbackConfigFile);
                }
                URL uRL = result;
                if (updateStatus) {
                    this.statusOnResourceSearch(logbackConfigFile, this.classLoader, result != null ? result.toString() : null);
                }
                return uRL;
            }
            catch (MalformedURLException e) {
                try {
                    result = Loader.getResource(logbackConfigFile, this.classLoader);
                    if (result != null) {
                        URL uRL = result;
                        if (updateStatus) {
                            this.statusOnResourceSearch(logbackConfigFile, this.classLoader, result != null ? result.toString() : null);
                        }
                        return uRL;
                    }
                    if (updateStatus) {
                        this.statusOnResourceSearch(logbackConfigFile, this.classLoader, result != null ? result.toString() : null);
                    }
                }
                catch (Throwable throwable) {
                    if (updateStatus) {
                        this.statusOnResourceSearch(logbackConfigFile, this.classLoader, result != null ? result.toString() : null);
                    }
                    throw throwable;
                }
            }
        }
        return null;
    }

    private URL findConfigFileURLFromAssets(boolean updateStatus) {
        return this.getResource(AUTOCONFIG_FILE, this.classLoader, updateStatus);
    }

    private URL getResource(String filename, ClassLoader myClassLoader, boolean updateStatus) {
        URL url = myClassLoader.getResource(filename);
        if (updateStatus) {
            String resourcePath = null;
            if (url != null) {
                resourcePath = filename;
            }
            this.statusOnResourceSearch(filename, myClassLoader, resourcePath);
        }
        return url;
    }

    public void autoConfig() throws JoranException {
        URL assetsConfigUrl;
        URL url;
        StatusListenerConfigHelper.installIfAsked(this.loggerContext);
        new AndroidContextUtil().setupProperties(this.loggerContext);
        boolean verbose = true;
        boolean configured = false;
        JoranConfigurator configurator = new JoranConfigurator();
        configurator.setContext(this.loggerContext);
        if (!configured && (url = this.findConfigFileFromSystemProperties(verbose)) != null) {
            configurator.doConfigure(url);
            configured = true;
        }
        if (!configured && (assetsConfigUrl = this.findConfigFileURLFromAssets(verbose)) != null) {
            configurator.doConfigure(assetsConfigUrl);
            configured = true;
        }
    }

    private void statusOnResourceSearch(String resourceName, ClassLoader classLoader, String path) {
        StatusManager sm = this.loggerContext.getStatusManager();
        if (path == null) {
            sm.add(new InfoStatus("Could NOT find resource [" + resourceName + "]", this.loggerContext));
        } else {
            sm.add(new InfoStatus("Found resource [" + resourceName + "] at [" + path + "]", this.loggerContext));
        }
    }
}

