/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.action;

import ch.qos.logback.core.joran.action.Action;
import ch.qos.logback.core.joran.spi.ActionException;
import ch.qos.logback.core.joran.spi.InterpretationContext;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.util.Loader;
import ch.qos.logback.core.util.OptionHelper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import org.xml.sax.Attributes;

public abstract class AbstractIncludeAction
extends Action {
    private static final String FILE_ATTR = "file";
    private static final String URL_ATTR = "url";
    private static final String RESOURCE_ATTR = "resource";
    private static final String OPTIONAL_ATTR = "optional";
    private String attributeInUse;
    private boolean optional;
    private URL urlInUse;

    public URL getUrl() {
        return this.urlInUse;
    }

    protected abstract void processInclude(InterpretationContext var1, URL var2) throws JoranException;

    protected void handleError(String message, Exception e) {
        this.addError(message, e);
    }

    public void begin(InterpretationContext ec, String name, Attributes attributes) throws ActionException {
        this.attributeInUse = null;
        this.optional = OptionHelper.toBoolean(attributes.getValue(OPTIONAL_ATTR), false);
        if (!this.checkAttributes(attributes)) {
            return;
        }
        try {
            URL url = this.getInputURL(ec, attributes);
            if (url != null) {
                this.processInclude(ec, url);
            }
        }
        catch (JoranException e) {
            this.handleError("Error while parsing " + this.attributeInUse, e);
        }
    }

    protected void close(InputStream in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private boolean checkAttributes(Attributes attributes) {
        String fileAttribute = attributes.getValue(FILE_ATTR);
        String urlAttribute = attributes.getValue(URL_ATTR);
        String resourceAttribute = attributes.getValue(RESOURCE_ATTR);
        int count = 0;
        if (!OptionHelper.isEmpty(fileAttribute)) {
            ++count;
        }
        if (!OptionHelper.isEmpty(urlAttribute)) {
            ++count;
        }
        if (!OptionHelper.isEmpty(resourceAttribute)) {
            ++count;
        }
        if (count == 0) {
            this.handleError(String.format("One of \"%1$s\", \"%2$s\" or \"%3$s\" attributes must be set.", FILE_ATTR, RESOURCE_ATTR, URL_ATTR), null);
            return false;
        }
        if (count > 1) {
            this.handleError(String.format("Only one of \"%1$s\", \"%2$s\" or \"%3$s\" attributes should be set.", FILE_ATTR, RESOURCE_ATTR, URL_ATTR), null);
            return false;
        }
        if (count == 1) {
            return true;
        }
        throw new IllegalStateException("Count value [" + count + "] is not expected");
    }

    private URL attributeToURL(String urlAttribute) {
        block4: {
            try {
                URL url = new URL(urlAttribute);
                InputStream stream = url.openStream();
                stream.close();
                stream = null;
                return url;
            }
            catch (MalformedURLException mue) {
                if (!this.optional) {
                    String errMsg = "URL [" + urlAttribute + "] is not well formed.";
                    this.handleError(errMsg, mue);
                }
            }
            catch (IOException e) {
                if (this.optional) break block4;
                String errMsg = "URL [" + urlAttribute + "] cannot be opened.";
                this.handleError(errMsg, e);
            }
        }
        return null;
    }

    private URL resourceAsURL(String resourceAttribute) {
        URL url = Loader.getResourceBySelfClassLoader(resourceAttribute);
        if (url == null) {
            if (!this.optional) {
                String errMsg = "Could not find resource corresponding to [" + resourceAttribute + "]";
                this.handleError(errMsg, null);
            }
            return null;
        }
        return url;
    }

    private URL filePathAsURL(String path) {
        File file = new File(path);
        if (!file.exists() || !file.isFile()) {
            if (!this.optional) {
                this.handleError("File does not exist [" + path + "]", new FileNotFoundException(path));
            }
            return null;
        }
        URI uri = file.toURI();
        try {
            return uri.toURL();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected String getAttributeInUse() {
        return this.attributeInUse;
    }

    protected boolean isOptional() {
        return this.optional;
    }

    private URL getInputURL(InterpretationContext ec, Attributes attributes) {
        String fileAttribute = attributes.getValue(FILE_ATTR);
        String urlAttribute = attributes.getValue(URL_ATTR);
        String resourceAttribute = attributes.getValue(RESOURCE_ATTR);
        if (!OptionHelper.isEmpty(fileAttribute)) {
            this.attributeInUse = ec.subst(fileAttribute);
            return this.filePathAsURL(this.attributeInUse);
        }
        if (!OptionHelper.isEmpty(urlAttribute)) {
            this.attributeInUse = ec.subst(urlAttribute);
            return this.attributeToURL(this.attributeInUse);
        }
        if (!OptionHelper.isEmpty(resourceAttribute)) {
            this.attributeInUse = ec.subst(resourceAttribute);
            return this.resourceAsURL(this.attributeInUse);
        }
        throw new IllegalStateException("A URL stream should have been returned");
    }

    public void end(InterpretationContext ec, String name) throws ActionException {
    }
}

