/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.android;

import brut.androlib.res.decoder.AXmlResourceParser;
import ch.qos.logback.core.joran.event.SaxEvent;
import ch.qos.logback.core.joran.event.SaxEventRecorder;
import ch.qos.logback.core.joran.spi.JoranException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.LocatorImpl;
import org.xmlpull.v1.XmlPullParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASaxEventRecorder
extends SaxEventRecorder {
    private int[] holderForStartAndLength = new int[2];
    private StatePassFilter filter = new StatePassFilter(new String[0]);
    private String elemNameToWatch = null;
    private Map<String, String> elemAttrs = null;

    public void setFilter(String ... names) {
        this.filter = new StatePassFilter(names);
    }

    public void setAttributeWatch(String elemName) {
        this.elemNameToWatch = elemName;
    }

    public Map<String, String> getAttributeWatchValues() {
        return this.elemAttrs;
    }

    @Override
    public List<SaxEvent> recordEvents(InputSource src) throws JoranException {
        InputStream stream = src.getByteStream();
        if (stream == null) {
            throw new IllegalArgumentException("Input source must specify an input stream");
        }
        List<SaxEvent> events = null;
        try {
            AXmlResourceParser xpp = new AXmlResourceParser(stream);
            this.elemAttrs = null;
            int eventType = -1;
            while ((eventType = xpp.next()) > -1) {
                if (0 == eventType) {
                    this.filter.reset();
                    this.startDocument((XmlPullParser)xpp);
                    continue;
                }
                if (1 == eventType) {
                    this.filter.reset();
                    this.endDocument();
                    break;
                }
                if (2 == eventType) {
                    this.startElement((XmlPullParser)xpp);
                    continue;
                }
                if (3 == eventType) {
                    this.endElement((XmlPullParser)xpp);
                    continue;
                }
                if (4 != eventType) continue;
                this.characters((XmlPullParser)xpp);
            }
            events = this.getSaxEventList();
        }
        catch (Exception e) {
            this.addError(e.getMessage(), e);
            throw new JoranException("Can't parse Android XML resource", e);
        }
        return events;
    }

    private void startDocument(XmlPullParser xpp) {
        super.startDocument();
        super.setDocumentLocator(new LocatorImpl());
    }

    private void characters(XmlPullParser xpp) {
        if (this.filter.passed()) {
            char[] ch = xpp.getTextCharacters(this.holderForStartAndLength);
            int start = this.holderForStartAndLength[0];
            int length = this.holderForStartAndLength[1];
            super.characters(ch, start, length);
        }
    }

    private void endElement(XmlPullParser xpp) {
        String name = xpp.getName();
        if (this.filter.checkEnd(name)) {
            this.endElement(xpp.getNamespace(), name, name);
        }
    }

    private void startElement(XmlPullParser xpp) {
        String name = xpp.getName();
        if (this.filter.checkStart(name)) {
            AttributesImpl atts = new AttributesImpl();
            for (int i = 0; i < xpp.getAttributeCount(); ++i) {
                atts.addAttribute(xpp.getAttributeNamespace(i), xpp.getAttributeName(i), xpp.getAttributeName(i), xpp.getAttributeType(i), xpp.getAttributeValue(i));
            }
            this.startElement(xpp.getNamespace(), name, name, atts);
        }
        this.checkForWatchedAttributes(xpp);
    }

    private void checkForWatchedAttributes(XmlPullParser xpp) {
        if (this.elemNameToWatch != null && this.elemAttrs == null && xpp.getName().equals(this.elemNameToWatch)) {
            HashMap<String, String> map = new HashMap<String, String>();
            for (int i = 0; i < xpp.getAttributeCount(); ++i) {
                String key = "";
                String ns = xpp.getAttributeNamespace(i);
                if (ns.length() > 0) {
                    int pos = ns.lastIndexOf("/");
                    if (pos > -1 && pos + 1 < ns.length()) {
                        ns = ns.substring(pos + 1);
                    }
                    key = ns + ":";
                }
                key = key + xpp.getAttributeName(i);
                map.put(key, xpp.getAttributeValue(i));
            }
            this.elemAttrs = map;
        }
    }

    static class StatePassFilter {
        private final String[] _states;
        private int _depth = 0;

        public StatePassFilter(String ... states) {
            this._states = states == null ? new String[]{} : states;
        }

        public boolean checkStart(String name) {
            if (this._depth == this._states.length) {
                return true;
            }
            if (name.equals(this._states[this._depth])) {
                ++this._depth;
            }
            return false;
        }

        public boolean checkEnd(String name) {
            if (this._depth > 0 && name.equals(this._states[this._depth - 1])) {
                --this._depth;
                return false;
            }
            return this._depth == this._states.length;
        }

        public int size() {
            return this._states.length;
        }

        public int depth() {
            return this._depth;
        }

        public void reset() {
            this._depth = 0;
        }

        public boolean passed() {
            return this._depth == this._states.length;
        }
    }
}

