/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.util;

import ch.qos.logback.core.util.OptionHelper;
import java.util.ArrayList;

public class EnvUtil {
    public static boolean isAndroidOS() {
        String osname = OptionHelper.getSystemProperty("os.name");
        String root = OptionHelper.getEnv("ANDROID_ROOT");
        String data = OptionHelper.getEnv("ANDROID_DATA");
        return osname != null && osname.contains("Linux") && root != null && root.contains("/system") && data != null && data.contains("/data");
    }

    private static boolean isJDK_N_OrHigher(int n) {
        ArrayList<String> versionList = new ArrayList<String>();
        for (int i = 0; i < 5; ++i) {
            versionList.add("1." + (n + i));
        }
        String javaVersion = System.getProperty("java.version");
        if (javaVersion == null) {
            return false;
        }
        for (String v : versionList) {
            if (!javaVersion.startsWith(v)) continue;
            return true;
        }
        return false;
    }

    public static boolean isJDK5() {
        return EnvUtil.isJDK_N_OrHigher(5);
    }

    public static boolean isJDK6OrHigher() {
        return EnvUtil.isJDK_N_OrHigher(6);
    }

    public static boolean isJDK7OrHigher() {
        return EnvUtil.isJDK_N_OrHigher(7);
    }

    public static boolean isWindows() {
        String os = System.getProperty("os.name");
        return os.startsWith("Windows");
    }
}

