/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.subst;

import ch.qos.logback.core.spi.PropertyContainer;
import ch.qos.logback.core.spi.ScanException;
import ch.qos.logback.core.subst.Node;
import ch.qos.logback.core.subst.Parser;
import ch.qos.logback.core.subst.Token;
import ch.qos.logback.core.subst.Tokenizer;
import ch.qos.logback.core.util.OptionHelper;
import java.util.List;
import java.util.Stack;

public class NodeToStringTransformer {
    final Node node;
    final PropertyContainer propertyContainer0;
    final PropertyContainer propertyContainer1;

    public NodeToStringTransformer(Node node, PropertyContainer propertyContainer, PropertyContainer propertyContainer2) {
        this.node = node;
        this.propertyContainer0 = propertyContainer;
        this.propertyContainer1 = propertyContainer2;
    }

    public NodeToStringTransformer(Node node, PropertyContainer propertyContainer) {
        this(node, propertyContainer, null);
    }

    public static String substituteVariable(String string, PropertyContainer propertyContainer, PropertyContainer propertyContainer2) throws ScanException {
        Node node = NodeToStringTransformer.tokenizeAndParseString(string);
        NodeToStringTransformer nodeToStringTransformer = new NodeToStringTransformer(node, propertyContainer, propertyContainer2);
        return nodeToStringTransformer.transform();
    }

    private static Node tokenizeAndParseString(String string) throws ScanException {
        Tokenizer tokenizer = new Tokenizer(string);
        List<Token> list = tokenizer.tokenize();
        Parser parser = new Parser(list);
        return parser.parse();
    }

    public String transform() throws ScanException {
        StringBuilder stringBuilder = new StringBuilder();
        this.compileNode(this.node, stringBuilder, new Stack<Node>());
        return stringBuilder.toString();
    }

    private void compileNode(Node node, StringBuilder stringBuilder, Stack<Node> stack) throws ScanException {
        Node node2 = node;
        while (node2 != null) {
            switch (node2.type) {
                case LITERAL: {
                    this.handleLiteral(node2, stringBuilder);
                    break;
                }
                case VARIABLE: {
                    this.handleVariable(node2, stringBuilder, stack);
                }
            }
            node2 = node2.next;
        }
    }

    private void handleVariable(Node node, StringBuilder stringBuilder, Stack<Node> stack) throws ScanException {
        if (this.haveVisitedNodeAlready(node, stack)) {
            stack.push(node);
            String string = this.constructRecursionErrorMessage(stack);
            throw new IllegalArgumentException(string);
        }
        stack.push(node);
        StringBuilder stringBuilder2 = new StringBuilder();
        Node node2 = (Node)node.payload;
        this.compileNode(node2, stringBuilder2, stack);
        String string = stringBuilder2.toString();
        String string2 = this.lookupKey(string);
        if (string2 != null) {
            Node node3 = NodeToStringTransformer.tokenizeAndParseString(string2);
            this.compileNode(node3, stringBuilder, stack);
            stack.pop();
            return;
        }
        if (node.defaultPart == null) {
            stringBuilder.append(string + "_IS_UNDEFINED");
            stack.pop();
            return;
        }
        Node node4 = (Node)node.defaultPart;
        StringBuilder stringBuilder3 = new StringBuilder();
        this.compileNode(node4, stringBuilder3, stack);
        stack.pop();
        String string3 = stringBuilder3.toString();
        stringBuilder.append(string3);
    }

    private String lookupKey(String string) {
        String string2 = this.propertyContainer0.getProperty(string);
        if (string2 != null) {
            return string2;
        }
        if (this.propertyContainer1 != null && (string2 = this.propertyContainer1.getProperty(string)) != null) {
            return string2;
        }
        string2 = OptionHelper.getSystemProperty(string, null);
        if (string2 != null) {
            return string2;
        }
        string2 = OptionHelper.getEnv(string);
        if (string2 != null) {
            return string2;
        }
        return null;
    }

    private void handleLiteral(Node node, StringBuilder stringBuilder) {
        stringBuilder.append((String)node.payload);
    }

    private String variableNodeValue(Node node) {
        Node node2 = (Node)node.payload;
        return (String)node2.payload;
    }

    private String constructRecursionErrorMessage(Stack<Node> stack) {
        StringBuilder stringBuilder = new StringBuilder("Circular variable reference detected while parsing input [");
        for (Node node : stack) {
            stringBuilder.append("${").append(this.variableNodeValue(node)).append("}");
            if (stack.lastElement() == node) continue;
            stringBuilder.append(" --> ");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    private boolean haveVisitedNodeAlready(Node node, Stack<Node> stack) {
        for (Node node2 : stack) {
            if (!this.equalNodes(node, node2)) continue;
            return true;
        }
        return false;
    }

    private boolean equalNodes(Node node, Node node2) {
        if (node.type != null && !node.type.equals((Object)node2.type)) {
            return false;
        }
        if (node.payload != null && !node.payload.equals(node2.payload)) {
            return false;
        }
        return node.defaultPart == null || node.defaultPart.equals(node2.defaultPart);
    }
}

