/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling.helper;

import ch.qos.logback.core.rolling.helper.FileFinder;
import ch.qos.logback.core.rolling.helper.FileNamePattern;
import ch.qos.logback.core.rolling.helper.FilenameParser;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class IntParser
implements FilenameParser<Integer> {
    private final Pattern pathPattern;

    IntParser(FileNamePattern fileNamePattern) {
        String string = fileNamePattern.toRegex(false, true);
        string = FileFinder.unescapePath(string);
        this.pathPattern = Pattern.compile(string);
    }

    @Override
    public Integer parseFilename(String string) {
        Integer n = -1;
        try {
            n = Integer.parseInt(this.findToken(string), 10);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n;
    }

    private String findToken(String string) {
        Matcher matcher = this.pathPattern.matcher(string);
        return matcher.find() && matcher.groupCount() >= 1 ? matcher.group(1) : "";
    }
}

