/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.turbo;

import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LRUMessageCache
extends LinkedHashMap<String, Integer> {
    private static final long serialVersionUID = 1L;
    final int cacheSize;

    LRUMessageCache(int n) {
        super((int)((float)n * 1.3333334f), 0.75f, true);
        if (n < 1) {
            throw new IllegalArgumentException("Cache size cannot be smaller than 1");
        }
        this.cacheSize = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getMessageCountAndThenIncrement(String string) {
        Integer n;
        if (string == null) {
            return 0;
        }
        LRUMessageCache lRUMessageCache = this;
        synchronized (lRUMessageCache) {
            n = (Integer)super.get(string);
            n = n == null ? Integer.valueOf(0) : Integer.valueOf(n + 1);
            super.put(string, n);
        }
        return n;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<String, Integer> entry) {
        return this.size() > this.cacheSize;
    }

    @Override
    public synchronized void clear() {
        super.clear();
    }
}

