/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.util;

import ch.qos.logback.core.spi.ContextAware;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringToObjectConverter {
    private static final Class<?>[] STING_CLASS_PARAMETER = new Class[]{String.class};

    public static boolean canBeBuiltFromSimpleString(Class<?> clazz) {
        Package package_ = clazz.getPackage();
        if (clazz.isPrimitive()) {
            return true;
        }
        if (package_ != null && "java.lang".equals(package_.getName())) {
            return true;
        }
        if (StringToObjectConverter.followsTheValueOfConvention(clazz)) {
            return true;
        }
        if (clazz.isEnum()) {
            return true;
        }
        return StringToObjectConverter.isOfTypeCharset(clazz);
    }

    public static Object convertArg(ContextAware contextAware, String string, Class<?> clazz) {
        if (string == null) {
            return null;
        }
        String string2 = string.trim();
        if (String.class.isAssignableFrom(clazz)) {
            return string2;
        }
        if (Integer.TYPE.isAssignableFrom(clazz)) {
            return Integer.valueOf(string2);
        }
        if (Long.TYPE.isAssignableFrom(clazz)) {
            return Long.valueOf(string2);
        }
        if (Float.TYPE.isAssignableFrom(clazz)) {
            return Float.valueOf(string2);
        }
        if (Double.TYPE.isAssignableFrom(clazz)) {
            return Double.valueOf(string2);
        }
        if (Boolean.TYPE.isAssignableFrom(clazz)) {
            if ("true".equalsIgnoreCase(string2)) {
                return Boolean.TRUE;
            }
            if ("false".equalsIgnoreCase(string2)) {
                return Boolean.FALSE;
            }
        } else {
            if (clazz.isEnum()) {
                return StringToObjectConverter.convertToEnum(contextAware, string2, clazz);
            }
            if (StringToObjectConverter.followsTheValueOfConvention(clazz)) {
                return StringToObjectConverter.convertByValueOfMethod(contextAware, clazz, string2);
            }
            if (StringToObjectConverter.isOfTypeCharset(clazz)) {
                return StringToObjectConverter.convertToCharset(contextAware, string);
            }
        }
        return null;
    }

    private static boolean isOfTypeCharset(Class<?> clazz) {
        return Charset.class.isAssignableFrom(clazz);
    }

    private static Charset convertToCharset(ContextAware contextAware, String string) {
        try {
            return Charset.forName(string);
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            contextAware.addError("Failed to get charset [" + string + "]", unsupportedCharsetException);
            return null;
        }
    }

    public static Method getValueOfMethod(Class<?> clazz) {
        try {
            return clazz.getMethod("valueOf", STING_CLASS_PARAMETER);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
        catch (SecurityException securityException) {
            return null;
        }
    }

    private static boolean followsTheValueOfConvention(Class<?> clazz) {
        Method method = StringToObjectConverter.getValueOfMethod(clazz);
        if (method == null) {
            return false;
        }
        int n = method.getModifiers();
        return Modifier.isStatic(n);
    }

    private static Object convertByValueOfMethod(ContextAware contextAware, Class<?> clazz, String string) {
        try {
            Method method = clazz.getMethod("valueOf", STING_CLASS_PARAMETER);
            return method.invoke(null, string);
        }
        catch (Exception exception) {
            contextAware.addError("Failed to invoke valueOf{} method in class [" + clazz.getName() + "] with value [" + string + "]");
            return null;
        }
    }

    private static Object convertToEnum(ContextAware contextAware, String string, Class<? extends Enum> clazz) {
        return Enum.valueOf(clazz, string);
    }

    boolean isBuildableFromSimpleString() {
        return false;
    }
}

