/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.status;

import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.spi.LifeCycle;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.StatusListener;
import ch.qos.logback.core.status.StatusManager;
import ch.qos.logback.core.util.StatusPrinter;
import java.io.PrintStream;
import java.util.List;

abstract class OnPrintStreamStatusListenerBase
extends ContextAwareBase
implements StatusListener,
LifeCycle {
    boolean isStarted = false;
    static final long DEFAULT_RETROSPECTIVE = 300L;
    long retrospectiveThresold = 300L;

    OnPrintStreamStatusListenerBase() {
    }

    protected abstract PrintStream getPrintStream();

    private void print(Status status) {
        StringBuilder stringBuilder = new StringBuilder();
        StatusPrinter.buildStr(stringBuilder, "", status);
        this.getPrintStream().print(stringBuilder);
    }

    public void addStatusEvent(Status status) {
        if (!this.isStarted) {
            return;
        }
        this.print(status);
    }

    private void retrospectivePrint() {
        if (this.context == null) {
            return;
        }
        long l = System.currentTimeMillis();
        StatusManager statusManager = this.context.getStatusManager();
        List<Status> list = statusManager.getCopyOfStatusList();
        for (Status status : list) {
            long l2 = status.getDate();
            if (!this.isElapsedTimeLongerThanThreshold(l, l2)) continue;
            this.print(status);
        }
    }

    private boolean isElapsedTimeLongerThanThreshold(long l, long l2) {
        long l3 = l - l2;
        return l3 < this.retrospectiveThresold;
    }

    public void start() {
        this.isStarted = true;
        if (this.retrospectiveThresold > 0L) {
            this.retrospectivePrint();
        }
    }

    public void setRetrospective(long l) {
        this.retrospectiveThresold = l;
    }

    public long getRetrospective() {
        return this.retrospectiveThresold;
    }

    public void stop() {
        this.isStarted = false;
    }

    public boolean isStarted() {
        return this.isStarted;
    }
}

