/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core;

import ch.qos.logback.core.NOPOutputStream;
import ch.qos.logback.core.OutputStreamAppender;
import ch.qos.logback.core.recovery.ResilientFileOutputStream;
import ch.qos.logback.core.util.ContextUtil;
import ch.qos.logback.core.util.EnvUtil;
import ch.qos.logback.core.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileAppender<E>
extends OutputStreamAppender<E> {
    protected static String COLLISION_WITH_EARLIER_APPENDER_URL = "http://logback.qos.ch/codes.html#earlier_fa_collision";
    protected boolean append = true;
    protected String fileName = null;
    private boolean prudent = false;
    private boolean initialized = false;
    private boolean lazyInit = false;

    public void setFile(String string) {
        this.fileName = string == null ? null : string.trim();
    }

    public boolean isAppend() {
        return this.append;
    }

    public final String rawFileProperty() {
        return this.fileName;
    }

    public String getFile() {
        return this.fileName;
    }

    @Override
    public void start() {
        int n = 0;
        String string = this.getFile();
        if (string != null) {
            string = this.getAbsoluteFilePath(string);
            this.addInfo("File property is set to [" + string + "]");
            if (this.prudent && !this.isAppend()) {
                this.setAppend(true);
                this.addWarn("Setting \"Append\" property to true on account of \"Prudent\" mode");
            }
            if (!this.lazyInit) {
                if (this.checkForFileCollisionInPreviousFileAppenders()) {
                    this.addError("Collisions detected with FileAppender/RollingAppender instances defined earlier. Aborting.");
                    this.addError(COLLISION_WITH_EARLIER_APPENDER_URL);
                    ++n;
                } else {
                    try {
                        this.openFile(string);
                    }
                    catch (IOException iOException) {
                        ++n;
                        this.addError("openFile(" + string + "," + this.append + ") failed", iOException);
                    }
                }
            } else {
                this.setOutputStream(new NOPOutputStream());
            }
        } else {
            ++n;
            this.addError("\"File\" property not set for appender named [" + this.name + "]");
        }
        if (n == 0) {
            super.start();
        }
    }

    @Override
    public void stop() {
        super.stop();
        Map<String, String> map = ContextUtil.getFilenameCollisionMap(this.context);
        if (map == null || this.getName() == null) {
            return;
        }
        map.remove(this.getName());
    }

    protected boolean checkForFileCollisionInPreviousFileAppenders() {
        boolean bl = false;
        if (this.fileName == null) {
            return false;
        }
        Map map = (Map)this.context.getObject("FA_FILENAME_COLLISION_MAP");
        if (map == null) {
            return bl;
        }
        for (Map.Entry entry : map.entrySet()) {
            if (!this.fileName.equals(entry.getValue())) continue;
            this.addErrorForCollision("File", (String)entry.getValue(), (String)entry.getKey());
            bl = true;
        }
        if (this.name != null) {
            map.put(this.getName(), this.fileName);
        }
        return bl;
    }

    protected void addErrorForCollision(String string, String string2, String string3) {
        this.addError("'" + string + "' option has the same value \"" + string2 + "\" as that given for appender [" + string3 + "] defined earlier.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean openFile(String string) throws IOException {
        boolean bl = false;
        string = this.getAbsoluteFilePath(string);
        this.lock.lock();
        try {
            File file = new File(string);
            boolean bl2 = FileUtil.createMissingParentDirectories(file);
            if (!bl2) {
                this.addError("Failed to create parent directories for [" + file.getAbsolutePath() + "]");
            }
            ResilientFileOutputStream resilientFileOutputStream = new ResilientFileOutputStream(file, this.append);
            resilientFileOutputStream.setContext(this.context);
            this.setOutputStream(resilientFileOutputStream);
            bl = true;
        }
        finally {
            this.lock.unlock();
        }
        return bl;
    }

    public boolean isPrudent() {
        return this.prudent;
    }

    public void setPrudent(boolean bl) {
        this.prudent = bl;
    }

    public void setAppend(boolean bl) {
        this.append = bl;
    }

    public boolean getLazy() {
        return this.lazyInit;
    }

    public void setLazy(boolean bl) {
        this.lazyInit = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void safeWrite(E e) throws IOException {
        ResilientFileOutputStream resilientFileOutputStream = (ResilientFileOutputStream)this.getOutputStream();
        FileChannel fileChannel = resilientFileOutputStream.getChannel();
        if (fileChannel == null) {
            return;
        }
        boolean bl = Thread.interrupted();
        FileLock fileLock = null;
        try {
            fileLock = fileChannel.lock();
            long l = fileChannel.position();
            long l2 = fileChannel.size();
            if (l2 != l) {
                fileChannel.position(l2);
            }
            super.writeOut(e);
        }
        catch (IOException iOException) {
            resilientFileOutputStream.postIOFailure(iOException);
        }
        finally {
            if (fileLock != null && fileLock.isValid()) {
                fileLock.release();
            }
            if (bl) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    protected void writeOut(E e) throws IOException {
        if (this.prudent) {
            this.safeWrite(e);
        } else {
            super.writeOut(e);
        }
    }

    @Override
    protected void subAppend(E e) {
        if (!this.initialized && this.lazyInit) {
            this.initialized = true;
            if (this.checkForFileCollisionInPreviousFileAppenders()) {
                this.addError("Collisions detected with FileAppender/RollingAppender instances defined earlier. Aborting.");
                this.addError(COLLISION_WITH_EARLIER_APPENDER_URL);
            } else {
                try {
                    this.openFile(this.getFile());
                    super.start();
                }
                catch (IOException iOException) {
                    this.started = false;
                    this.addError("openFile(" + this.fileName + "," + this.append + ") failed", iOException);
                }
            }
        }
        super.subAppend(e);
    }

    private String getAbsoluteFilePath(String string) {
        if (EnvUtil.isAndroidOS() && !new File(string).isAbsolute()) {
            String string2 = this.context.getProperty("DATA_DIR");
            string = FileUtil.prefixRelativePath(string2, string);
        }
        return string;
    }
}

