/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.pattern;

import ch.qos.logback.classic.pattern.ClassicConverter;
import ch.qos.logback.classic.spi.CallerData;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.boolex.EvaluationException;
import ch.qos.logback.core.boolex.EventEvaluator;
import ch.qos.logback.core.status.ErrorStatus;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CallerDataConverter
extends ClassicConverter {
    public static final String DEFAULT_CALLER_LINE_PREFIX = "Caller+";
    int depth = 5;
    List<EventEvaluator<ILoggingEvent>> evaluatorList = null;
    final int MAX_ERROR_COUNT = 4;
    int errorCount = 0;

    @Override
    public void start() {
        String string = this.getFirstOption();
        if (string == null) {
            return;
        }
        try {
            this.depth = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.addError("Failed to parse depth option [" + string + "]", numberFormatException);
        }
        List<String> list = this.getOptionList();
        if (list != null && list.size() > 1) {
            int n = list.size();
            for (int i = 1; i < n; ++i) {
                Map map;
                EventEvaluator eventEvaluator;
                String string2 = list.get(i);
                Context context = this.getContext();
                if (context == null || (eventEvaluator = (EventEvaluator)(map = (Map)context.getObject("EVALUATOR_MAP")).get(string2)) == null) continue;
                this.addEvaluator(eventEvaluator);
            }
        }
    }

    private void addEvaluator(EventEvaluator<ILoggingEvent> eventEvaluator) {
        if (this.evaluatorList == null) {
            this.evaluatorList = new ArrayList<EventEvaluator<ILoggingEvent>>();
        }
        this.evaluatorList.add(eventEvaluator);
    }

    @Override
    public String convert(ILoggingEvent iLoggingEvent) {
        StackTraceElement[] stackTraceElementArray;
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        if (this.evaluatorList != null) {
            boolean bl = false;
            for (n = 0; n < this.evaluatorList.size(); ++n) {
                EventEvaluator<ILoggingEvent> eventEvaluator = this.evaluatorList.get(n);
                try {
                    if (!eventEvaluator.evaluate(iLoggingEvent)) continue;
                    bl = true;
                    break;
                }
                catch (EvaluationException evaluationException) {
                    ++this.errorCount;
                    if (this.errorCount < 4) {
                        this.addError("Exception thrown for evaluator named [" + eventEvaluator.getName() + "]", evaluationException);
                        continue;
                    }
                    if (this.errorCount != 4) continue;
                    ErrorStatus errorStatus = new ErrorStatus("Exception thrown for evaluator named [" + eventEvaluator.getName() + "].", this, evaluationException);
                    errorStatus.add(new ErrorStatus("This was the last warning about this evaluator's errors.We don't want the StatusManager to get flooded.", this));
                    this.addStatus(errorStatus);
                }
            }
            if (!bl) {
                return "";
            }
        }
        if ((stackTraceElementArray = iLoggingEvent.getCallerData()) != null && stackTraceElementArray.length > 0) {
            n = this.depth < stackTraceElementArray.length ? this.depth : stackTraceElementArray.length;
            for (int i = 0; i < n; ++i) {
                stringBuilder.append(this.getCallerLinePrefix());
                stringBuilder.append(i);
                stringBuilder.append("\t at ");
                stringBuilder.append(stackTraceElementArray[i]);
                stringBuilder.append(CoreConstants.LINE_SEPARATOR);
            }
            return stringBuilder.toString();
        }
        return CallerData.CALLER_DATA_NA;
    }

    protected String getCallerLinePrefix() {
        return DEFAULT_CALLER_LINE_PREFIX;
    }
}

