/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.pattern;

import ch.qos.logback.classic.pattern.ClassicConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.util.CachingDateFormatter;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;

public class DateConverter
extends ClassicConverter {
    CachingDateFormatter cachingDateFormatter = null;

    public void start() {
        String string = this.getFirstOption();
        if (string == null) {
            string = "yyyy-MM-dd HH:mm:ss,SSS";
        }
        if (string.equals("ISO8601")) {
            string = "yyyy-MM-dd HH:mm:ss,SSS";
        }
        TimeZone timeZone = TimeZone.getDefault();
        Locale locale = Locale.ENGLISH;
        List<String> list = this.getOptionList();
        if (list != null) {
            if (list.size() > 1) {
                timeZone = TimeZone.getTimeZone(list.get(1));
            }
            if (list.size() > 2) {
                locale = this.parseLocale(list.get(2));
            }
        }
        try {
            this.cachingDateFormatter = new CachingDateFormatter(string, locale);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.addWarn("Could not instantiate SimpleDateFormat with pattern " + string, illegalArgumentException);
            this.cachingDateFormatter = new CachingDateFormatter("yyyy-MM-dd HH:mm:ss,SSS", locale);
        }
        this.cachingDateFormatter.setTimeZone(timeZone);
    }

    private Locale parseLocale(String string) {
        String[] stringArray = string.split(",");
        Locale locale = stringArray.length > 1 ? new Locale(stringArray[0], stringArray[1]) : new Locale(stringArray[0]);
        return locale;
    }

    public String convert(ILoggingEvent iLoggingEvent) {
        long l = iLoggingEvent.getTimeStamp();
        return this.cachingDateFormatter.format(l);
    }
}

