/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.android;

import brut.androlib.res.decoder.AXmlResourceParser;
import ch.qos.logback.core.joran.event.SaxEvent;
import ch.qos.logback.core.joran.event.SaxEventRecorder;
import ch.qos.logback.core.joran.spi.JoranException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.LocatorImpl;
import org.xmlpull.v1.XmlPullParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASaxEventRecorder
extends SaxEventRecorder {
    private int[] holderForStartAndLength = new int[2];
    private StatePassFilter filter = new StatePassFilter(new String[0]);
    private String elemNameToWatch = null;
    private Map<String, String> elemAttrs = null;

    public void setFilter(String ... stringArray) {
        this.filter = new StatePassFilter(stringArray);
    }

    public void setAttributeWatch(String string) {
        this.elemNameToWatch = string;
    }

    public Map<String, String> getAttributeWatchValues() {
        return this.elemAttrs;
    }

    @Override
    public List<SaxEvent> recordEvents(InputSource inputSource) throws JoranException {
        InputStream inputStream = inputSource.getByteStream();
        if (inputStream == null) {
            throw new IllegalArgumentException("Input source must specify an input stream");
        }
        List<SaxEvent> list = null;
        try {
            AXmlResourceParser aXmlResourceParser = new AXmlResourceParser(inputStream);
            this.elemAttrs = null;
            int n = -1;
            while ((n = aXmlResourceParser.next()) > -1) {
                if (0 == n) {
                    this.filter.reset();
                    this.startDocument((XmlPullParser)aXmlResourceParser);
                    continue;
                }
                if (1 == n) {
                    this.filter.reset();
                    this.endDocument();
                    break;
                }
                if (2 == n) {
                    this.startElement((XmlPullParser)aXmlResourceParser);
                    continue;
                }
                if (3 == n) {
                    this.endElement((XmlPullParser)aXmlResourceParser);
                    continue;
                }
                if (4 != n) continue;
                this.characters((XmlPullParser)aXmlResourceParser);
            }
            list = this.getSaxEventList();
        }
        catch (Exception exception) {
            this.addError(exception.getMessage(), exception);
            throw new JoranException("Can't parse Android XML resource", exception);
        }
        return list;
    }

    private void startDocument(XmlPullParser xmlPullParser) {
        super.startDocument();
        super.setDocumentLocator(new LocatorImpl());
    }

    private void characters(XmlPullParser xmlPullParser) {
        if (this.filter.passed()) {
            char[] cArray = xmlPullParser.getTextCharacters(this.holderForStartAndLength);
            int n = this.holderForStartAndLength[0];
            int n2 = this.holderForStartAndLength[1];
            super.characters(cArray, n, n2);
        }
    }

    private void endElement(XmlPullParser xmlPullParser) {
        String string = xmlPullParser.getName();
        if (this.filter.checkEnd(string)) {
            this.endElement(xmlPullParser.getNamespace(), string, string);
        }
    }

    private void startElement(XmlPullParser xmlPullParser) {
        String string = xmlPullParser.getName();
        if (this.filter.checkStart(string)) {
            AttributesImpl attributesImpl = new AttributesImpl();
            for (int i = 0; i < xmlPullParser.getAttributeCount(); ++i) {
                attributesImpl.addAttribute(xmlPullParser.getAttributeNamespace(i), xmlPullParser.getAttributeName(i), xmlPullParser.getAttributeName(i), xmlPullParser.getAttributeType(i), xmlPullParser.getAttributeValue(i));
            }
            this.startElement(xmlPullParser.getNamespace(), string, string, attributesImpl);
        }
        this.checkForWatchedAttributes(xmlPullParser);
    }

    private void checkForWatchedAttributes(XmlPullParser xmlPullParser) {
        if (this.elemNameToWatch != null && this.elemAttrs == null && xmlPullParser.getName().equals(this.elemNameToWatch)) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (int i = 0; i < xmlPullParser.getAttributeCount(); ++i) {
                String string = "";
                String string2 = xmlPullParser.getAttributeNamespace(i);
                if (string2.length() > 0) {
                    int n = string2.lastIndexOf("/");
                    if (n > -1 && n + 1 < string2.length()) {
                        string2 = string2.substring(n + 1);
                    }
                    string = string2 + ":";
                }
                string = string + xmlPullParser.getAttributeName(i);
                hashMap.put(string, xmlPullParser.getAttributeValue(i));
            }
            this.elemAttrs = hashMap;
        }
    }

    static class StatePassFilter {
        private final String[] _states;
        private int _depth = 0;

        public StatePassFilter(String ... stringArray) {
            this._states = stringArray == null ? new String[]{} : stringArray;
        }

        public boolean checkStart(String string) {
            if (this._depth == this._states.length) {
                return true;
            }
            if (string.equals(this._states[this._depth])) {
                ++this._depth;
            }
            return false;
        }

        public boolean checkEnd(String string) {
            if (this._depth > 0 && string.equals(this._states[this._depth - 1])) {
                --this._depth;
                return false;
            }
            return this._depth == this._states.length;
        }

        public int size() {
            return this._states.length;
        }

        public int depth() {
            return this._depth;
        }

        public void reset() {
            this._depth = 0;
        }

        public boolean passed() {
            return this._depth == this._states.length;
        }
    }
}

