/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.pattern.parser;

import ch.qos.logback.core.pattern.CompositeConverter;
import ch.qos.logback.core.pattern.Converter;
import ch.qos.logback.core.pattern.DynamicConverter;
import ch.qos.logback.core.pattern.LiteralConverter;
import ch.qos.logback.core.pattern.parser.CompositeNode;
import ch.qos.logback.core.pattern.parser.Node;
import ch.qos.logback.core.pattern.parser.SimpleKeywordNode;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.status.ErrorStatus;
import ch.qos.logback.core.util.OptionHelper;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Compiler<E>
extends ContextAwareBase {
    Converter<E> head;
    Converter<E> tail;
    final Node top;
    final Map converterMap;

    Compiler(Node node, Map map) {
        this.top = node;
        this.converterMap = map;
    }

    Converter<E> compile() {
        this.tail = null;
        this.head = null;
        Node node = this.top;
        while (node != null) {
            switch (node.type) {
                case 0: {
                    this.addToList(new LiteralConverter((String)node.getValue()));
                    break;
                }
                case 2: {
                    CompositeNode compositeNode = (CompositeNode)node;
                    CompositeConverter<E> compositeConverter = this.createCompositeConverter(compositeNode);
                    if (compositeConverter == null) {
                        this.addError("Failed to create converter for [%" + compositeNode.getValue() + "] keyword");
                        this.addToList(new LiteralConverter("%PARSER_ERROR[" + compositeNode.getValue() + "]"));
                        break;
                    }
                    compositeConverter.setFormattingInfo(compositeNode.getFormatInfo());
                    compositeConverter.setOptionList(compositeNode.getOptions());
                    Compiler<E> compiler = new Compiler<E>(compositeNode.getChildNode(), this.converterMap);
                    compiler.setContext(this.context);
                    Converter<E> converter = compiler.compile();
                    compositeConverter.setChildConverter(converter);
                    this.addToList(compositeConverter);
                    break;
                }
                case 1: {
                    SimpleKeywordNode simpleKeywordNode = (SimpleKeywordNode)node;
                    DynamicConverter<E> dynamicConverter = this.createConverter(simpleKeywordNode);
                    if (dynamicConverter != null) {
                        dynamicConverter.setFormattingInfo(simpleKeywordNode.getFormatInfo());
                        dynamicConverter.setOptionList(simpleKeywordNode.getOptions());
                        this.addToList(dynamicConverter);
                        break;
                    }
                    LiteralConverter literalConverter = new LiteralConverter("%PARSER_ERROR[" + simpleKeywordNode.getValue() + "]");
                    this.addStatus(new ErrorStatus("[" + simpleKeywordNode.getValue() + "] is not a valid conversion word", this));
                    this.addToList(literalConverter);
                }
            }
            node = node.next;
        }
        return this.head;
    }

    private void addToList(Converter<E> converter) {
        if (this.head == null) {
            this.tail = converter;
            this.head = this.tail;
        } else {
            this.tail.setNext(converter);
            this.tail = converter;
        }
    }

    DynamicConverter<E> createConverter(SimpleKeywordNode simpleKeywordNode) {
        String string = (String)simpleKeywordNode.getValue();
        String string2 = (String)this.converterMap.get(string);
        if (string2 != null) {
            try {
                return (DynamicConverter)OptionHelper.instantiateByClassName(string2, DynamicConverter.class, this.context);
            }
            catch (Exception exception) {
                this.addError("Failed to instantiate converter class [" + string2 + "] for keyword [" + string + "]", exception);
                return null;
            }
        }
        this.addError("There is no conversion class registered for conversion word [" + string + "]");
        return null;
    }

    CompositeConverter<E> createCompositeConverter(CompositeNode compositeNode) {
        String string = (String)compositeNode.getValue();
        String string2 = (String)this.converterMap.get(string);
        if (string2 != null) {
            try {
                return (CompositeConverter)OptionHelper.instantiateByClassName(string2, CompositeConverter.class, this.context);
            }
            catch (Exception exception) {
                this.addError("Failed to instantiate converter class [" + string2 + "] as a composite converter for keyword [" + string + "]", exception);
                return null;
            }
        }
        this.addError("There is no conversion class registered for composite conversion word [" + string + "]");
        return null;
    }
}

