/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling.helper;

import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.RolloverFailure;
import ch.qos.logback.core.rolling.helper.FileStoreUtil;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.util.EnvUtil;
import ch.qos.logback.core.util.FileUtil;
import java.io.File;

public class RenameUtil
extends ContextAwareBase {
    static String RENAMING_ERROR_URL = "http://logback.qos.ch/codes.html#renamingError";

    public void rename(String string, String string2) throws RolloverFailure {
        if (string.equals(string2)) {
            this.addWarn("Source and target files are the same [" + string + "]. Skipping.");
            return;
        }
        File file = new File(string);
        if (file.exists()) {
            File file2 = new File(string2);
            this.createMissingTargetDirsIfNecessary(file2);
            this.addInfo("Renaming file [" + file + "] to [" + file2 + "]");
            boolean bl = file.renameTo(file2);
            if (!bl) {
                this.addWarn("Failed to rename file [" + file + "] as [" + file2 + "].");
                if (this.areOnDifferentVolumes(file, file2)) {
                    this.addWarn("Detected different file systems for source [" + string + "] and target [" + string2 + "]. Attempting rename by copying.");
                    this.renameByCopying(string, string2);
                    return;
                }
                this.addWarn("Please consider leaving the [file] option of " + RollingFileAppender.class.getSimpleName() + " empty.");
                this.addWarn("See also " + RENAMING_ERROR_URL);
            }
        } else {
            throw new RolloverFailure("File [" + string + "] does not exist.");
        }
    }

    boolean areOnDifferentVolumes(File file, File file2) throws RolloverFailure {
        if (!EnvUtil.isJDK7OrHigher()) {
            return false;
        }
        File file3 = file2.getParentFile();
        try {
            boolean bl = FileStoreUtil.areOnSameFileStore(file, file3);
            return !bl;
        }
        catch (RolloverFailure rolloverFailure) {
            this.addWarn("Error while checking file store equality", rolloverFailure);
            return false;
        }
    }

    public void renameByCopying(String string, String string2) throws RolloverFailure {
        FileUtil fileUtil = new FileUtil(this.getContext());
        fileUtil.copy(string, string2);
        File file = new File(string);
        if (!file.delete()) {
            this.addWarn("Could not delete " + string);
        }
    }

    void createMissingTargetDirsIfNecessary(File file) throws RolloverFailure {
        boolean bl;
        if (FileUtil.isParentDirectoryCreationRequired(file) && !(bl = FileUtil.createMissingParentDirectories(file))) {
            throw new RolloverFailure("Failed to create parent directories for [" + file.getAbsolutePath() + "]");
        }
    }

    public String toString() {
        return "c.q.l.co.rolling.helper.RenameUtil";
    }
}

