/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.android;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.android.LogcatAppender;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.core.status.InfoStatus;
import ch.qos.logback.core.status.StatusManager;
import org.slf4j.LoggerFactory;

public class BasicLogcatConfigurator {
    private BasicLogcatConfigurator() {
    }

    public static void configure(LoggerContext loggerContext) {
        StatusManager statusManager = loggerContext.getStatusManager();
        if (statusManager != null) {
            statusManager.add(new InfoStatus("Setting up default configuration.", loggerContext));
        }
        LogcatAppender logcatAppender = new LogcatAppender();
        logcatAppender.setContext(loggerContext);
        logcatAppender.setName("logcat");
        PatternLayoutEncoder patternLayoutEncoder = new PatternLayoutEncoder();
        patternLayoutEncoder.setContext(loggerContext);
        patternLayoutEncoder.setPattern("%msg");
        patternLayoutEncoder.start();
        logcatAppender.setEncoder(patternLayoutEncoder);
        logcatAppender.start();
        Logger logger = loggerContext.getLogger("ROOT");
        logger.addAppender(logcatAppender);
    }

    public static void configureDefaultContext() {
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        BasicLogcatConfigurator.configure(loggerContext);
    }
}

