/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.v5.routeprogress;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.Pair;
import com.google.auto.value.AutoValue;
import com.mapbox.api.directions.v5.models.DirectionsRoute;
import com.mapbox.api.directions.v5.models.LegStep;
import com.mapbox.api.directions.v5.models.RouteLeg;
import com.mapbox.api.directions.v5.models.StepIntersection;
import com.mapbox.geojson.Geometry;
import com.mapbox.geojson.Point;
import com.mapbox.navigator.BannerInstruction;
import com.mapbox.navigator.VoiceInstruction;
import com.mapbox.services.android.navigation.v5.routeprogress.AutoValue_RouteProgress;
import com.mapbox.services.android.navigation.v5.routeprogress.CurrentLegAnnotation;
import com.mapbox.services.android.navigation.v5.routeprogress.RouteLegProgress;
import com.mapbox.services.android.navigation.v5.routeprogress.RouteProgressState;
import java.util.List;

@AutoValue
public abstract class RouteProgress {
    public abstract DirectionsRoute directionsRoute();

    public abstract int legIndex();

    @NonNull
    public RouteLeg currentLeg() {
        return (RouteLeg)this.directionsRoute().legs().get(this.legIndex());
    }

    public double distanceTraveled() {
        double distanceTraveled = this.directionsRoute().distance() - this.distanceRemaining();
        if (distanceTraveled < 0.0) {
            distanceTraveled = 0.0;
        }
        return distanceTraveled;
    }

    public double durationRemaining() {
        return (double)(1.0f - this.fractionTraveled()) * this.directionsRoute().duration();
    }

    public float fractionTraveled() {
        float fractionRemaining = 1.0f;
        if (this.directionsRoute().distance() > 0.0) {
            fractionRemaining = (float)(this.distanceTraveled() / this.directionsRoute().distance());
        }
        return fractionRemaining;
    }

    public abstract double distanceRemaining();

    public int remainingWaypoints() {
        return this.directionsRoute().legs().size() - this.legIndex();
    }

    public abstract RouteLegProgress currentLegProgress();

    public abstract List<Point> currentStepPoints();

    @Nullable
    public abstract List<Point> upcomingStepPoints();

    public abstract boolean inTunnel();

    @Nullable
    public abstract VoiceInstruction voiceInstruction();

    @Nullable
    public abstract BannerInstruction bannerInstruction();

    @Nullable
    public abstract RouteProgressState currentState();

    @Nullable
    public abstract Geometry routeGeometry();

    @Nullable
    public abstract Geometry routeGeometryWithBuffer();

    public abstract Builder toBuilder();

    abstract LegStep currentStep();

    abstract int stepIndex();

    abstract double legDistanceRemaining();

    abstract double stepDistanceRemaining();

    abstract List<StepIntersection> intersections();

    abstract StepIntersection currentIntersection();

    @Nullable
    abstract StepIntersection upcomingIntersection();

    @Nullable
    abstract CurrentLegAnnotation currentLegAnnotation();

    abstract List<Pair<StepIntersection, Double>> intersectionDistancesAlongStep();

    abstract double legDurationRemaining();

    public static Builder builder() {
        return new AutoValue_RouteProgress.Builder();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder directionsRoute(DirectionsRoute var1);

        abstract DirectionsRoute directionsRoute();

        public abstract Builder legIndex(int var1);

        abstract int legIndex();

        public abstract Builder stepIndex(int var1);

        abstract int stepIndex();

        public abstract Builder legDistanceRemaining(double var1);

        abstract double legDistanceRemaining();

        public abstract Builder legDurationRemaining(double var1);

        abstract double legDurationRemaining();

        public abstract Builder stepDistanceRemaining(double var1);

        abstract double stepDistanceRemaining();

        public abstract Builder currentStep(LegStep var1);

        abstract LegStep currentStep();

        public abstract Builder currentStepPoints(List<Point> var1);

        abstract List<Point> currentStepPoints();

        public abstract Builder upcomingStepPoints(@Nullable List<Point> var1);

        abstract List<Point> upcomingStepPoints();

        public abstract Builder distanceRemaining(double var1);

        public abstract Builder intersections(List<StepIntersection> var1);

        abstract List<StepIntersection> intersections();

        public abstract Builder currentIntersection(StepIntersection var1);

        abstract StepIntersection currentIntersection();

        public abstract Builder upcomingIntersection(@Nullable StepIntersection var1);

        abstract StepIntersection upcomingIntersection();

        public abstract Builder intersectionDistancesAlongStep(List<Pair<StepIntersection, Double>> var1);

        abstract List<Pair<StepIntersection, Double>> intersectionDistancesAlongStep();

        public abstract Builder currentLegAnnotation(@Nullable CurrentLegAnnotation var1);

        abstract CurrentLegAnnotation currentLegAnnotation();

        abstract Builder currentLegProgress(RouteLegProgress var1);

        public abstract Builder inTunnel(boolean var1);

        public abstract Builder voiceInstruction(@Nullable VoiceInstruction var1);

        public abstract Builder bannerInstruction(@Nullable BannerInstruction var1);

        public abstract Builder currentState(@Nullable RouteProgressState var1);

        public abstract Builder routeGeometry(@Nullable Geometry var1);

        public abstract Builder routeGeometryWithBuffer(@Nullable Geometry var1);

        abstract RouteProgress autoBuild();

        public RouteProgress build() {
            RouteLeg currentLeg = (RouteLeg)this.directionsRoute().legs().get(this.legIndex());
            RouteLegProgress legProgress = RouteLegProgress.builder().routeLeg(currentLeg).currentStep(this.currentStep()).stepIndex(this.stepIndex()).distanceRemaining(this.legDistanceRemaining()).durationRemaining(this.legDurationRemaining()).stepDistanceRemaining(this.stepDistanceRemaining()).currentStepPoints(this.currentStepPoints()).upcomingStepPoints(this.upcomingStepPoints()).intersections(this.intersections()).currentIntersection(this.currentIntersection()).upcomingIntersection(this.upcomingIntersection()).intersectionDistancesAlongStep(this.intersectionDistancesAlongStep()).currentLegAnnotation(this.currentLegAnnotation()).build();
            this.currentLegProgress(legProgress);
            return this.autoBuild();
        }
    }
}

