/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.v5.navigation;

import android.text.TextUtils;
import com.mapbox.api.directions.v5.models.DirectionsRoute;
import com.mapbox.api.directionsrefresh.v1.MapboxDirectionsRefresh;
import com.mapbox.services.android.navigation.v5.navigation.RefreshCallback;
import com.mapbox.services.android.navigation.v5.navigation.RefreshError;
import com.mapbox.services.android.navigation.v5.navigation.RouteRefreshCallback;
import com.mapbox.services.android.navigation.v5.routeprogress.RouteProgress;
import retrofit2.Callback;
import timber.log.Timber;

public final class RouteRefresh {
    private static final String INVALID_DIRECTIONS_ROUTE = "RouteProgress passed has invalid DirectionsRoute";
    private final String accessToken;
    private RefreshCallback refreshCallback;

    @Deprecated
    public RouteRefresh(String accessToken, RefreshCallback refreshCallback) {
        this.accessToken = accessToken;
        this.refreshCallback = refreshCallback;
    }

    public RouteRefresh(String accessToken) {
        this.accessToken = accessToken;
    }

    @Deprecated
    public void refresh(RouteProgress routeProgress) {
        if (this.refreshCallback == null) {
            Timber.e((String)"RefreshCallback cannot be null.", (Object[])new Object[0]);
            return;
        }
        this.refresh(routeProgress.directionsRoute(), routeProgress.legIndex(), this.refreshCallback);
    }

    public void refresh(RouteProgress routeProgress, RefreshCallback refreshCallback) {
        this.refresh(routeProgress.directionsRoute(), routeProgress.legIndex(), refreshCallback);
    }

    private void refresh(DirectionsRoute directionsRoute, int legIndex, RefreshCallback refreshCallback) {
        if (this.isInvalid(directionsRoute, refreshCallback)) {
            return;
        }
        MapboxDirectionsRefresh.builder().requestId(directionsRoute.routeOptions().requestUuid()).routeIndex(Integer.valueOf(directionsRoute.routeIndex()).intValue()).legIndex(legIndex).accessToken(this.accessToken).build().enqueueCall((Callback)new RouteRefreshCallback(directionsRoute, legIndex, refreshCallback));
    }

    private boolean isInvalid(DirectionsRoute directionsRoute, RefreshCallback refreshCallback) {
        String requestUuid = directionsRoute.routeOptions().requestUuid();
        if (TextUtils.isEmpty((CharSequence)requestUuid) || directionsRoute.routeIndex() == null) {
            refreshCallback.onError(new RefreshError(INVALID_DIRECTIONS_ROUTE));
            return true;
        }
        return false;
    }
}

